## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, eval = FALSE)

## ----eval=FALSE---------------------------------------------------------------
# library(keras)
# 
# FLAGS <- flags(
#   flag_numeric("dropout_rate", 0.4)
# )
# 
# mnist <- dataset_mnist()
# x_train <- mnist$train$x
# y_train <- mnist$train$y
# x_test <- mnist$test$x
# y_test <- mnist$test$y
# 
# x_train <- array_reshape(x_train, c(nrow(x_train), 784))
# x_test <- array_reshape(x_test, c(nrow(x_test), 784))
# x_train <- x_train / 255
# x_test <- x_test / 255
# 
# y_train <- to_categorical(y_train, 10)
# y_test <- to_categorical(y_test, 10)
# 
# model <- keras_model_sequential()
# 
# model %>%
#   layer_dense(units = 256, activation = 'relu', input_shape = c(784)) %>%
#   layer_dropout(rate = FLAGS$dropout_rate) %>%
#   layer_dense(units = 128, activation = 'relu') %>%
#   layer_dropout(rate = 0.3) %>%
#   layer_dense(units = 10, activation = 'softmax')
# 
# model %>% compile(
#   loss = 'categorical_crossentropy',
#   optimizer = optimizer_rmsprop(),
#   metrics = c('accuracy')
# )
# 
# model %>% fit(
#   x_train, y_train,
#   epochs = 20, batch_size = 128,
#   validation_split = 0.2
# )
# 
# export_savedmodel(model, "savedmodel")

## ----eval=FALSE---------------------------------------------------------------
# cloudml_deploy("savedmodel", name = "keras_mnist")

## ----eval=FALSE---------------------------------------------------------------
# mnist_image <- keras::dataset_mnist()$train$x[1,,]
# grid::grid.raster(mnist_image / 255)

## ----eval=FALSE---------------------------------------------------------------
# cloudml_predict(
#   list(
#     as.vector(t(mnist_image))
#   ),
#   name = "keras_mnist",
# )

