# Run with: Rscript -e 'source(system.file("helper", "check_exports.R", package="robustfa")); check_exports("robustfa")'
check_exports <- function(pkg = "robustfa") {
  if (!requireNamespace("testthat", quietly = TRUE)) {
    stop("Please install 'testthat'")
  }
  source(system.file("testthat", "helper-exports.R", package = pkg), local = TRUE)
  details <- dangling_exports_details(pkg)
  if (!nrow(details)) {
    cat("No dangling exports detected in NAMESPACE\n")
    return(invisible(details))
  }
  cat("Dangling exports:\n")
  for (i in seq_len(nrow(details))) {
    ln <- details$namespace_line[i]
    cat(sprintf(" - %s (NAMESPACE:%s)%s\n",
                details$name[i],
                ifelse(is.na(ln), "?", ln),
                if (!is.na(details$namespace_text[i])) paste0(" -> ", details$namespace_text[i]) else ""
    ))
  }
  invisible(details)
}
