## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  warning = FALSE,
  message = FALSE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(rvolleydata)
library(dplyr)

## ----installation, eval=FALSE-------------------------------------------------
# # install.packages("devtools")
# devtools::install_github("awosoga/rvolleydata")

## ----schedule-----------------------------------------------------------------
schedule <- load_schedule("au", 2025)
glimpse(schedule)

## ----pbp----------------------------------------------------------------------
pbp <- load_pbp("lovb", 2025)
glimpse(pbp)

## ----officials----------------------------------------------------------------
officials <- load_officials("mlv", 2025)
glimpse(officials)

## ----boxscores----------------------------------------------------------------
player_info <- load_player_info("au", 2025)
glimpse(player_info)

## ----team_staff---------------------------------------------------------------
team_staff <- load_team_staff("lovb", 2025)
glimpse(team_staff)

## ----events_log---------------------------------------------------------------
events_log <- load_events_log("mlv", 2025)
glimpse(events_log)

## ----player_boxscores---------------------------------------------------------
player_boxscores <- load_player_boxscore("au", 2025)
glimpse(player_boxscores)

## ----team_boxscores-----------------------------------------------------------
team_boxscores <- load_team_boxscore("mlv", 2025)
glimpse(team_boxscores)

