/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;

public class FuzzyGL
implements GL {
    private final float ee;
    private final float ef;
    private final float ff;
    private final GL gl;

    public FuzzyGL(GL gL, float f) {
        if (gL == null) {
            throw new NullPointerException("gl==null");
        }
        if (Double.isNaN(f) || (double)f < 0.0 || (double)f >= 1.0) {
            throw new IllegalArgumentException("err: " + f);
        }
        float f2 = f;
        float f3 = 1.0f - f;
        this.ee = f2 * f2;
        this.ef = f2 * f3;
        this.ff = f3 * f3;
        this.gl = gL;
    }

    @Override
    public float gl(int n, int n2, int n3, int n4) {
        int n5 = this.gl.allele1(n, n2);
        int n6 = this.gl.allele2(n, n2);
        if (n5 >= 0 && n6 >= 0) {
            if (n5 == n6 || this.gl.isPhased(n, n2)) {
                return this.phasedGL(n5, n6, n3, n4);
            }
            return this.phasedGL(n5, n6, n3, n4) + this.phasedGL(n6, n5, n3, n4);
        }
        return this.gl.gl(n, n2, n3, n4);
    }

    private float phasedGL(int n, int n2, int n3, int n4) {
        if (n == n3) {
            return n2 == n4 ? this.ff : this.ef;
        }
        return n2 == n4 ? this.ef : this.ee;
    }

    @Override
    public boolean isRefData() {
        return this.gl.isRefData();
    }

    @Override
    public boolean isPhased(int n, int n2) {
        return this.gl.isPhased(n, n2);
    }

    @Override
    public int allele1(int n, int n2) {
        return this.gl.allele1(n, n2);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.gl.allele2(n, n2);
    }

    @Override
    public int allele(int n, int n2) {
        return this.gl.allele(n, n2);
    }

    @Override
    public int nMarkers() {
        return this.gl.nMarkers();
    }

    @Override
    public Marker marker(int n) {
        return this.gl.marker(n);
    }

    @Override
    public Markers markers() {
        return this.gl.markers();
    }

    @Override
    public int nHaps() {
        return this.gl.nHaps();
    }

    @Override
    public int nSamples() {
        return this.gl.nSamples();
    }

    @Override
    public Samples samples() {
        return this.gl.samples();
    }
}

