% Generated by roxygen2: do not edit by hand
\name{backsolve}
\alias{backsolve}
\alias{forwardsolve}
\title{Solve an Upper (or Lower) Triangular System}
\arguments{
  \item{r,l}{an upper (or lower) triangular matrix}
  \item{b}{a numeric or complex vector or matrix}
  \item{transpose}{logical. If TRUE, solve system with the transpose of `r`.
}
}

\details{
Solve a system of linear equations with an upper triangular matrix
\code{
(r <- matrix(c(1, 0, 0, 2, 1, 0, 3, 2, 1), ncol = 3))
(b <- c(1, 2, 3))
backsolve(r, b)  # solution to the system
}

Solve system with the transpose of `r`, i.e. \{.help [\{.fun forwardsolve\}](base::forwardsolve)\}
\code{
t(r) # = l
backsolve(r, b, transpose = TRUE)  # solution to the system with transposed `r`
forwardsolve(t(r), b)
}}

