/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.datatype.DataType;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.treelikelihood.AncestralStateBeagleTreeLikelihood;
import dr.inference.model.Statistic;
import dr.xml.Reportable;
import java.util.Set;

public class ASRBranchSubstitutionMatrix
extends Statistic.Abstract
implements Reportable {
    private AncestralStateBeagleTreeLikelihood asrLikelihood;
    private final Set<String> leafSetDescendant;
    private final Tree tree;
    private final String name;
    private final boolean useDoublets;
    private final int dim;
    private final DataType dataType;
    private final String[] dimNames;

    public ASRBranchSubstitutionMatrix(String string, AncestralStateBeagleTreeLikelihood ancestralStateBeagleTreeLikelihood, DataType dataType, Boolean bl, TaxonList taxonList) throws TreeUtils.MissingTaxonException {
        this.name = string;
        this.asrLikelihood = ancestralStateBeagleTreeLikelihood;
        this.tree = this.asrLikelihood.getTreeModel();
        this.dataType = dataType;
        if (dataType == null) {
            throw new RuntimeException("DataType not found;");
        }
        this.leafSetDescendant = taxonList != null ? TreeUtils.getLeavesForTaxa(this.tree, taxonList) : null;
        this.useDoublets = bl;
        int n = dataType.getStateCount() * dataType.getStateCount();
        if (this.useDoublets) {
            n *= n;
        }
        this.dim = n;
        this.dimNames = this.constructDimNames();
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public String getDimensionName(int n) {
        return this.dimNames[n];
    }

    private int[] singlesFromDoublet(int n, int n2) {
        int[] nArray;
        nArray = new int[]{Math.floorDiv(n, n2), n - nArray[0] * n2};
        return nArray;
    }

    public String[] constructDimNames() {
        int n = this.dataType.getStateCount();
        String[] stringArray = new String[this.dim];
        if (this.useDoublets) {
            int n2 = n * n;
            for (int i = 0; i < this.dim; ++i) {
                int n3 = Math.floorDiv(i, n2);
                int n4 = i - n3 * n2;
                System.err.println("from " + n3 + " to " + n4);
                int[] nArray = this.singlesFromDoublet(n3, n);
                int[] nArray2 = this.singlesFromDoublet(n4, n);
                System.err.println("  from[0] " + nArray[0] + " from[1] " + nArray[1]);
                System.err.println("  to[0] " + nArray2[0] + " to[1] " + nArray2[1]);
                stringArray[i] = this.name + "[" + this.dataType.getChar(nArray[0]) + this.dataType.getChar(nArray[1]) + "," + this.dataType.getChar(nArray2[0]) + this.dataType.getChar(nArray2[1]) + "]";
            }
        } else {
            for (int i = 0; i < this.dim; ++i) {
                int n5 = Math.floorDiv(i, n);
                int n6 = i - n5 * n;
                stringArray[i] = this.name + "[" + this.dataType.getChar(n5) + "," + this.dataType.getChar(n6) + "]";
            }
        }
        return stringArray;
    }

    @Override
    public String getStatisticName() {
        return "name";
    }

    private NodeRef getNode(Set<String> set) {
        return set != null ? TreeUtils.getCommonAncestorNode(this.tree, set) : this.tree.getRoot();
    }

    private double[] getSingletCountMatrix(int[] nArray, int[] nArray2) {
        int n = this.dataType.getStateCount();
        double[] dArray = new double[n * n];
        for (int i = 0; i < nArray.length - 1; ++i) {
            int n2 = nArray[i];
            int n3 = nArray2[i];
            int n4 = n * n2 + n3;
            dArray[n4] = dArray[n4] + 1.0;
        }
        return dArray;
    }

    private double[] getDoubletCountMatrix(int[] nArray, int[] nArray2) {
        int n = this.dataType.getStateCount();
        int n2 = n * n;
        double[] dArray = new double[n2 * n2];
        for (int i = 0; i < nArray.length - 1; ++i) {
            int n3 = n * nArray[i] + nArray[i + 1];
            int n4 = n * nArray2[i] + nArray2[i + 1];
            int n5 = n2 * n3 + n4;
            dArray[n5] = dArray[n5] + 1.0;
        }
        return dArray;
    }

    private int getDoublet(int n, int n2, int n3) {
        return n * n3 + n2;
    }

    private int[] getTargetsForDim(int n) {
        int[] nArray = new int[2];
        int n2 = this.dataType.getStateCount();
        if (this.useDoublets) {
            int n3 = n2 * n2;
            nArray[0] = Math.floorDiv(n, n3);
            nArray[1] = n - nArray[0] * n3;
        } else {
            nArray[0] = Math.floorDiv(n, n2);
            nArray[1] = n - nArray[0] * n2;
        }
        return nArray;
    }

    @Override
    public double getStatisticValue(int n) {
        int n2 = this.dataType.getStateCount();
        int n3 = n2 * n2;
        double d = 0.0;
        int[] nArray = this.getTargetsForDim(n);
        NodeRef nodeRef = this.getNode(this.leafSetDescendant);
        NodeRef nodeRef2 = this.tree.getParent(nodeRef);
        int[] nArray2 = this.asrLikelihood.getStatesForNode(this.tree, nodeRef2);
        int[] nArray3 = this.asrLikelihood.getStatesForNode(this.tree, nodeRef);
        int n4 = nArray2.length;
        if (this.useDoublets) {
            --n4;
        }
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6;
            if (this.useDoublets) {
                n6 = this.getDoublet(nArray2[i], nArray2[i + 1], n2);
                n5 = this.getDoublet(nArray3[i], nArray3[i + 1], n2);
            } else {
                n6 = nArray2[i];
                n5 = nArray3[i];
            }
            if (n6 != nArray[0] || n5 != nArray[1]) continue;
            d += 1.0;
        }
        return d;
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder("ASRBranchSubstitutionMatrix Report\n\n");
        for (int i = 0; i < this.dim; ++i) {
            stringBuilder.append(this.dimNames[i] + ": " + this.getStatisticValue(i) + "; ");
        }
        stringBuilder.append(this.getStatisticValue(0));
        return stringBuilder.toString();
    }
}

