/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.ErlangDist;
import umontreal.iro.lecuyer.randvar.GammaGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class ErlangGen
extends GammaGen {
    protected int k = -1;

    public ErlangGen(RandomStream s, int k, double lambda) {
        super(s, new ErlangDist(k, lambda));
        this.setParams(k, lambda);
    }

    public ErlangGen(RandomStream s, int k) {
        this(s, k, 1.0);
    }

    public ErlangGen(RandomStream s, ErlangDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getK(), dist.getLambda());
        }
    }

    public static double nextDouble(RandomStream s, int k, double lambda) {
        return ErlangDist.inverseF(k, lambda, 15, s.nextDouble());
    }

    public int getK() {
        return this.k;
    }

    protected void setParams(int k, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (k <= 0) {
            throw new IllegalArgumentException("k <= 0");
        }
        this.lambda = lambda;
        this.k = k;
    }
}

