/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types.tests;

import cc.mallet.types.SparseMatrixn;
import cc.mallet.types.tests.TestSerializable;
import com.carrotsearch.hppc.DoubleArrayList;
import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestSparseMatrixn
extends TestCase {
    public TestSparseMatrixn(String name) {
        super(name);
    }

    public void testIndexing1d() {
        double[] m1 = new double[]{1.0, 2.0, 3.0, 4.0};
        int[] idx1 = new int[1];
        SparseMatrixn a = new SparseMatrixn(m1);
        a.singleToIndices(3, idx1);
        TestSparseMatrixn.assertEquals(3, idx1[0]);
        TestSparseMatrixn.assertEquals(3, a.singleIndex(idx1));
    }

    public void testIndexing2d() {
        int[] sizes = new int[]{2, 3};
        double[] m1 = new double[6];
        for (int i = 0; i < 6; ++i) {
            m1[i] = 2.0 * (double)i;
        }
        SparseMatrixn a = new SparseMatrixn(sizes, m1);
        int[] idx1 = new int[2];
        a.singleToIndices(5, idx1);
        System.out.println(idx1[0] + " , " + idx1[1]);
        int[] trueIdx = new int[]{1, 2};
        TestSparseMatrixn.assertTrue(Arrays.equals(trueIdx, idx1));
        TestSparseMatrixn.assertEquals(5, a.singleIndex(idx1));
        TestSparseMatrixn.assertEquals(10.0, a.value(idx1), 1.0E-12);
    }

    public void testIndexing3d() {
        SparseMatrixn a = this.make3dMatrix();
        int[] idx1 = new int[3];
        a.singleToIndices(21, idx1);
        int[] trueIdx = new int[]{1, 2, 1};
        TestSparseMatrixn.assertTrue(Arrays.equals(trueIdx, idx1));
        TestSparseMatrixn.assertEquals(21, a.singleIndex(idx1));
        TestSparseMatrixn.assertEquals(0.0, a.value(idx1), 1.0E-12);
        int[] idx2 = new int[]{1, 2, 2};
        TestSparseMatrixn.assertEquals(22, a.singleIndex(idx2));
        TestSparseMatrixn.assertEquals(44.0, a.value(idx2), 1.0E-12);
    }

    private SparseMatrixn make3dMatrix() {
        int[] sizes = new int[]{2, 3, 4};
        IntArrayList idxs = new IntArrayList();
        DoubleArrayList vals = new DoubleArrayList();
        for (int i = 0; i < 24; ++i) {
            if (i % 3 == 0) continue;
            idxs.add(i);
            vals.add(2.0 * (double)i);
        }
        SparseMatrixn a = new SparseMatrixn(sizes, idxs.toArray(), vals.toArray());
        return a;
    }

    public void testSparseMatrixnSerializable() throws IOException, ClassNotFoundException {
        SparseMatrixn a = this.make3dMatrix();
        SparseMatrixn b = (SparseMatrixn)TestSerializable.cloneViaSerialization(a);
        TestSparseMatrixn.assertEquals(a.singleSize(), b.singleSize());
        for (int i = 0; i < a.singleSize(); ++i) {
            int[] idxa = new int[a.getNumDimensions()];
            int[] idxb = new int[a.getNumDimensions()];
            a.singleToIndices(i, idxa);
            b.singleToIndices(i, idxb);
            TestSparseMatrixn.assertTrue(Arrays.equals(idxa, idxb));
            TestSparseMatrixn.assertEquals(a.value(idxa), b.value(idxb), 1.0E-12);
        }
    }

    public static Test suite() {
        return new TestSuite((Class<?>)TestSparseMatrixn.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest(new TestSparseMatrixn(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestSparseMatrixn.suite();
        }
        TestRunner.run(theSuite);
    }
}

