## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  cache = TRUE,
  eval = TRUE
  )

## ----echo=FALSE---------------------------------------------------------------
df.params <- data.frame(
    Parameter = c(
        "detection.window",
        "splice.region",
        "check.soft.clipping",
        "softClippedReads.realign.window",
        "softClippedReads.realign.match",
        "softClippedReads.realign.mismatch",
        "softClippedReads.realign.gapOpening",
        "softClippedReads.realign.gapExtension",
        "check.wildtype.reads",
        "is.paired.end",
        "keep.duplicate.reads",
        "keep.secondary.alignment",
        "keep.supplementary.alignment",
        "minimum.mapping.quality",
        "verbose",
        "out.failed.reads"
    ),
    Description = c(
        "the length of flanking regions to be added to both ends of pathogenic mutation locus for detecting reversion mutations",
        "the length of splicing junction region to be considered in introns",
        "whether soft-clipped reads to be realigned",
        "the length of flanking regions to be added to both ends of pathogenic mutation locus for realigning soft-clipped reads",
        "the scoring for a nucleotide match for realigning soft-clipped reads",
        "the scoring for a nucleotide mismatch for realigning soft-clipped reads",
        "the cost for opening a gap in the realignment of soft-clipped reads",
        "the incremental cost incurred along the length of the gap in the realignment of soft-clipped reads",
        "whether wild type reads to be processed as revertant-to-wildtype reads",
        "whether reads in BAM file are paired-end (TRUE) or single-end (FALSE)",
        "whether duplicated reads in the BAM file to be processed (TRUE) or discarded (FALSE)",
        "whether secondary alignment reads in the BAM file to be processed (TRUE) or discarded (FALSE)",
        "whether supplementary alignment reads in the BAM file to be processed (TRUE) or discarded (FALSE)",
        "the minimum mapping quality of reads in the BAM file to be processed",
        "whether progress logging to be printed to stdout",
        "whether the name of failed reads to be written to '.failed_reads.txt' file"
    ),
    Default = c(
        "100",
        "8",
        "TRUE",
        "1000",
        "1",
        "4",
        "6",
        "0",
        "FALSE",
        "TRUE",
        "TRUE",
        "TRUE",
        "TRUE",
        "0",
        "TRUE",
        "FALSE"
    )
)
knitr::kable(df.params)

## ----echo=FALSE---------------------------------------------------------------
df.rev.tbl <- data.frame(
    Column = c(
        "pathogenic_mutation",
        "pathogenic_mutation_left_aligned",
        "reversion_id",
        "reversion_frequency",
        "pathogenic_mutation_retained",
        "reversion",
        "reads_total",
        "reads_wildtype",
        "reads_withPathogenicMutation",
        "reads_withReplacementMutation",
        "mutations_in_reversion"
    ),
    Description = c(
        "the original pathogenic mutation",
        "left-aligned position of the pathogenic mutation if it is an insertion or deletion",
        "unique identifier of the reversion",
        "number of reads carrying the reversion",
        "whether the pathogenic locus retained the original mutation (Yes), arose a different mutation (No), or reverted to wild type (WT)",
        "the reversion for pathogenic mutation, consisting of one or more mutations",
        "number of total reads aligned to the pathogenic mutation locus",
        "number of reads exhibiting wild type at the pathogenic mutation locus",
        "number of reads carrying the pathogenic mutation",
        "number of reads carrying a different mutation but not the pathogenic mutation at the pathogenic locus",
        "number of mutations included in the reversion"
    )
)
knitr::kable(df.rev.tbl)

## ----echo=FALSE---------------------------------------------------------------
df.mut.tbl <- data.frame(
    Column = c(
        "reversion_id",
        "mutation_id",
        "mutation_type",
        "mutation",
        "mutation_length_change",
        "pathogenic_mutation",
        "distance_to_pathogenic_mutation"
    ),
    Description = c(
        "unique identifier of a reversion, corresponding to the 'reversion_id' in '.reversions.txt'",
        "unique identifier of each single mutation in a reversion",
        "SNV, INS, DEL, DELINS or WT (self-revertant mutation represented by MT>WT)",
        "genomic position of the mutation in HGVS-like syntax",
        "length of the reference sequence change caused by the mutation",
        "the original pathogenic mutation",
        "distance in reference sequence between the mutation and the pathogenic mutation"
    )
)
knitr::kable(df.mut.tbl)

## ----del_example, eval=FALSE--------------------------------------------------
# library(revert)
# 
# getReversions(
#     bam.file = system.file("extdata", "toy_data_1.bam", package="revert"),
#     out.dir = tempdir(),
#     reference = "hg19",
#     pathog.mut = "chr13:g.32913319_32913320delTG",
#     gene.name = "BRCA2",
#     transcript.id = "ENST00000544455" )

## ----ins_example, eval=FALSE--------------------------------------------------
# getReversions(
#     bam.file = system.file("extdata", "toy_data_2.bam", package="revert"),
#     out.dir = tempdir(),
#     reference = "hg19",
#     pathog.mut = "chr17:g.41244706_41244707insT",
#     gene.name = "BRCA1",
#     transcript.id = "ENST00000357654" )

## ----delins_example, eval=FALSE-----------------------------------------------
# getReversions(
#     bam.file = system.file("extdata", "toy_data_3.bam", package="revert"),
#     out.dir = tempdir(),
#     reference = "hg19",
#     pathog.mut = "chr17:g.41244936delinsAA",
#     gene.name = "BRCA1",
#     transcript.id = "ENST00000357654" )

## ----ns_snv_example, eval=FALSE-----------------------------------------------
# getReversions(
#     bam.file = system.file("extdata", "toy_data_4.bam", package="revert"),
#     out.dir = tempdir(),
#     reference = "hg19",
#     pathog.mut = "chr13:g.32913778T>G",
#     gene.name = "BRCA2",
#     transcript.id = "ENST00000544455" )

## ----splice_snv_example, eval=FALSE-------------------------------------------
# getReversions(
#     bam.file = system.file("extdata", "toy_data_5.bam", package="revert"),
#     out.dir = tempdir(),
#     reference = "hg19",
#     pathog.mut = "chr13:g.32928997G>A",
#     gene.name = "BRCA2",
#     transcript.id = "ENST00000544455" )

## ----targeted_del_example, eval=FALSE-----------------------------------------
# getReversions(
#     bam.file = system.file("extdata", "toy_data_6.bam", package="revert"),
#     out.dir = tempdir(),
#     reference = system.file("extdata", "toy_data_6_reference.fa", package="revert"),
#     pathog.mut = "Brca2_5805_wt:117del",
#     softClippedReads.realign.gapOpening = 8,
#     check.wildtype.reads = TRUE )

