/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.core.ObjectRepository;
import moa.tasks.TaskMonitor;

public class RDDM
extends AbstractChangeDetector {
    private static final long serialVersionUID = -489867468386968209L;
    public IntOption minNumInstancesOption = new IntOption("minNumInstances", 'n', "Minimum number of instances before monitoring changes.", 129, 0, Integer.MAX_VALUE);
    public FloatOption warningLevelOption = new FloatOption("warningLevel", 'w', "Warning Level.", 1.773, 1.0, 4.0);
    public FloatOption driftLevelOption = new FloatOption("driftLevel", 'o', "Drift Level.", 2.258, 1.0, 5.0);
    public IntOption maxSizeConceptOption = new IntOption("maxSizeConcept", 'x', "Maximum Size of Concept.", 40000, 1, Integer.MAX_VALUE);
    public IntOption minSizeStableConceptOption = new IntOption("minSizeStableConcept", 'y', "Minimum Size of Stable Concept.", 7000, 1, 20000);
    public IntOption warnLimitOption = new IntOption("warnLimit", 'z', "Warning Limit of instances", 1400, 1, 20000);
    private int minNumInstances;
    private double warningLevel;
    private double driftLevel;
    private int maxSizeConcept;
    private int minSizeStableConcept;
    private int warnLimit;
    private int m_n;
    private double m_p;
    private double m_s;
    private double m_pmin;
    private double m_smin;
    private double m_psmin;
    private byte[] storedPredictions;
    private int numStoredInstances;
    private int firstPos;
    private int lastPos;
    private int pos;
    private int i;
    private int lastWarnInst;
    private int lastWarnPos;
    private int instNum;
    private boolean rddmDrift;

    public void initialize() {
        this.minNumInstances = this.minNumInstancesOption.getValue();
        this.warningLevel = this.warningLevelOption.getValue();
        this.driftLevel = this.driftLevelOption.getValue();
        this.maxSizeConcept = this.maxSizeConceptOption.getValue();
        this.minSizeStableConcept = this.minSizeStableConceptOption.getValue();
        this.warnLimit = this.warnLimitOption.getValue();
        this.storedPredictions = new byte[this.minSizeStableConcept];
        this.numStoredInstances = 0;
        this.firstPos = 0;
        this.lastPos = -1;
        this.lastWarnPos = -1;
        this.lastWarnInst = -1;
        this.instNum = 0;
        this.rddmDrift = false;
        this.isChangeDetected = false;
        this.resetLearning();
        this.m_pmin = Double.MAX_VALUE;
        this.m_smin = Double.MAX_VALUE;
        this.m_psmin = Double.MAX_VALUE;
    }

    @Override
    public void resetLearning() {
        this.m_n = 1;
        this.m_p = 1.0;
        this.m_s = 0.0;
        if (this.isChangeDetected) {
            this.m_pmin = Double.MAX_VALUE;
            this.m_smin = Double.MAX_VALUE;
            this.m_psmin = Double.MAX_VALUE;
        }
    }

    @Override
    public void input(double prediction) {
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        if (this.rddmDrift) {
            this.resetLearning();
            if (this.lastWarnPos != -1) {
                this.firstPos = this.lastWarnPos;
                this.numStoredInstances = this.lastPos - this.firstPos + 1;
                if (this.numStoredInstances <= 0) {
                    this.numStoredInstances += this.minSizeStableConcept;
                }
            }
            this.pos = this.firstPos;
            this.i = 0;
            while (this.i < this.numStoredInstances) {
                this.m_p += ((double)this.storedPredictions[this.pos] - this.m_p) / (double)this.m_n;
                this.m_s = Math.sqrt(this.m_p * (1.0 - this.m_p) / (double)this.m_n);
                if (this.isChangeDetected && this.m_n > this.minNumInstances && this.m_p + this.m_s < this.m_psmin) {
                    this.m_pmin = this.m_p;
                    this.m_smin = this.m_s;
                    this.m_psmin = this.m_p + this.m_s;
                }
                ++this.m_n;
                this.pos = (this.pos + 1) % this.minSizeStableConcept;
                ++this.i;
            }
            this.lastWarnPos = -1;
            this.lastWarnInst = -1;
            this.rddmDrift = false;
            this.isChangeDetected = false;
        }
        this.lastPos = (this.lastPos + 1) % this.minSizeStableConcept;
        this.storedPredictions[this.lastPos] = (byte)prediction;
        if (this.numStoredInstances < this.minSizeStableConcept) {
            ++this.numStoredInstances;
        } else {
            this.firstPos = (this.firstPos + 1) % this.minSizeStableConcept;
            if (this.lastWarnPos == this.lastPos) {
                this.lastWarnPos = -1;
            }
        }
        this.m_p += (prediction - this.m_p) / (double)this.m_n;
        this.m_s = Math.sqrt(this.m_p * (1.0 - this.m_p) / (double)this.m_n);
        ++this.instNum;
        ++this.m_n;
        this.estimation = this.m_p;
        this.isWarningZone = false;
        if (this.m_n <= this.minNumInstances) {
            return;
        }
        if (this.m_p + this.m_s < this.m_psmin) {
            this.m_pmin = this.m_p;
            this.m_smin = this.m_s;
            this.m_psmin = this.m_p + this.m_s;
        }
        if (this.m_p + this.m_s > this.m_pmin + this.driftLevel * this.m_smin) {
            this.isChangeDetected = true;
            this.rddmDrift = true;
            if (this.lastWarnInst == -1) {
                this.firstPos = this.lastPos;
                this.numStoredInstances = 1;
            }
            return;
        }
        if (this.m_p + this.m_s > this.m_pmin + this.warningLevel * this.m_smin) {
            if (this.lastWarnInst != -1 && this.lastWarnInst + this.warnLimit <= this.instNum) {
                this.isChangeDetected = true;
                this.rddmDrift = true;
                this.firstPos = this.lastPos;
                this.numStoredInstances = 1;
                this.lastWarnPos = -1;
                this.lastWarnInst = -1;
                return;
            }
            this.isWarningZone = true;
            if (this.lastWarnInst == -1) {
                this.lastWarnInst = this.instNum;
                this.lastWarnPos = this.lastPos;
            }
        } else {
            this.lastWarnInst = -1;
            this.lastWarnPos = -1;
        }
        if (this.m_n > this.maxSizeConcept && !this.isWarningZone) {
            this.rddmDrift = true;
        }
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

