/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function n(e){return e+" is required, actual value was undefined"}function r(e,t,n){return"Expected "+n+" to be typeof "+t+", actual typeof was "+e}var a={};return a.typeOf={},a.defined=function(r,a){if(!e(a))throw new t(n(r))},a.typeOf.func=function(e,n){if("function"!=typeof n)throw new t(r(typeof n,"function",e))},a.typeOf.string=function(e,n){if("string"!=typeof n)throw new t(r(typeof n,"string",e))},a.typeOf.number=function(e,n){if("number"!=typeof n)throw new t(r(typeof n,"number",e))},a.typeOf.number.lessThan=function(e,n,r){if(a.typeOf.number(e,n),n>=r)throw new t("Expected "+e+" to be less than "+r+", actual value was "+n)},a.typeOf.number.lessThanOrEquals=function(e,n,r){if(a.typeOf.number(e,n),n>r)throw new t("Expected "+e+" to be less than or equal to "+r+", actual value was "+n)},a.typeOf.number.greaterThan=function(e,n,r){if(a.typeOf.number(e,n),n<=r)throw new t("Expected "+e+" to be greater than "+r+", actual value was "+n)},a.typeOf.number.greaterThanOrEquals=function(e,n,r){if(a.typeOf.number(e,n),n<r)throw new t("Expected "+e+" to be greater than or equal to"+r+", actual value was "+n)},a.typeOf.object=function(e,n){if("object"!=typeof n)throw new t(r(typeof n,"object",e))},a.typeOf.bool=function(e,n){if("boolean"!=typeof n)throw new t(r(typeof n,"boolean",e))},a}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";var a={};a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=function(e){return e>0?1:e<0?-1:0},a.signNotZero=function(e){return e<0?-1:1},a.toSNorm=function(e,n){return n=t(n,255),Math.round((.5*a.clamp(e,-1,1)+.5)*n)},a.fromSNorm=function(e,n){return n=t(n,255),a.clamp(e,0,n)/n*2-1},a.sinh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t-n)},a.cosh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t+n)},a.lerp=function(e,t,n){return(1-n)*e+n*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=.5*Math.PI,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI*.5,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){var t=a.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},a.clampToLatitudeRange=function(e){return a.clamp(e,-1*a.PI_OVER_TWO,a.PI_OVER_TWO)},a.negativePiToPi=function(e){return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){return(e%t+t)%t},a.equalsEpsilon=function(e,n,r,a){a=t(a,r);var i=Math.abs(e-n);return i<=a||i<=r*Math.max(Math.abs(e),Math.abs(n))};var i=[1];a.factorial=function(e){var t=i.length;if(e>=t)for(var n=i[t-1],r=t;r<=e;r++)i.push(n*r);return i[e]},a.incrementWrap=function(e,n,r){return r=t(r,0),++e,e>n&&(e=r),e},a.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},a.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},a.clamp=function(e,t,n){return e<t?t:e>n?n:e};var o=new e;return a.setRandomNumberSeed=function(t){o=new e(t)},a.nextRandomNumber=function(){return o.random()},a.acosClamped=function(e){return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},a.logBase=function(e,t){return Math.log(e)/Math.log(t)},a.fog=function(e,t){var n=e*t;return 1-Math.exp(-(n*n))},a}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a,i){"use strict";function o(e,n){this.x=t(e,0),this.y=t(n,0)}o.fromElements=function(e,t,r){return n(r)?(r.x=e,r.y=t,r):new o(e,t)},o.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y)},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(e,n,r){return r=t(r,0),n[r++]=e.x,n[r]=e.y,n},o.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new o),a.x=e[r++],a.y=e[r],a},o.packArray=function(e,t){var r=e.length;n(t)?t.length=2*r:t=new Array(2*r);for(var a=0;a<r;++a)o.pack(e[a],t,2*a);return t},o.unpackArray=function(e,t){var r=e.length;n(t)?t.length=r/2:t=new Array(r/2);for(var a=0;a<r;a+=2){var i=a/2;t[i]=o.unpack(e,a,t[i])}return t},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y)},o.minimumComponent=function(e){return Math.min(e.x,e.y)},o.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n},o.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(e,t){var n=o.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y},o.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n},o.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n},o.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n},o.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n},o.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n},o.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var s=new o;o.lerp=function(e,t,n,r){return o.multiplyByScalar(t,n,s),r=o.multiplyByScalar(e,1-n,r),o.add(s,r,r)};var c=new o,l=new o;o.angleBetween=function(e,t){return o.normalize(e,c),o.normalize(t,l),i.acosClamped(o.dot(c,l))};var h=new o;return o.mostOrthogonalAxis=function(e,t){var n=o.normalize(e,h);return o.abs(n,n),t=n.x<=n.y?o.clone(o.UNIT_X,t):o.clone(o.UNIT_Y,t)},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]},o.equalsEpsilon=function(e,t,r,a){return e===t||n(e)&&n(t)&&i.equalsEpsilon(e.x,t.x,r,a)&&i.equalsEpsilon(e.y,t.y,r,a)},o.ZERO=a(new o(0,0)),o.UNIT_X=a(new o(1,0)),o.UNIT_Y=a(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,n){return o.equalsEpsilon(this,e,t,n)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a,i){"use strict";function o(e,n,r){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0)}o.fromSpherical=function(e,r){n(r)||(r=new o);var a=e.clock,i=e.cone,u=t(e.magnitude,1),s=u*Math.sin(i);return r.x=s*Math.cos(a),r.y=s*Math.sin(a),r.z=u*Math.cos(i),r},o.fromElements=function(e,t,r,a){return n(a)?(a.x=e,a.y=t,a.z=r,a):new o(e,t,r)},o.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z)},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(e,n,r){return r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r]=e.z,n},o.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new o),a.x=e[r++],a.y=e[r++],a.z=e[r],a},o.packArray=function(e,t){var r=e.length;n(t)?t.length=3*r:t=new Array(3*r);for(var a=0;a<r;++a)o.pack(e[a],t,3*a);return t},o.unpackArray=function(e,t){var r=e.length;n(t)?t.length=r/3:t=new Array(r/3);for(var a=0;a<r;a+=3){var i=a/3;t[i]=o.unpack(e,a,t[i])}return t},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},o.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(e,t){var n=o.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},o.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},o.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n.z=e.z/t.z,n},o.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},o.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},o.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},o.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var s=new o;o.lerp=function(e,t,n,r){return o.multiplyByScalar(t,n,s),r=o.multiplyByScalar(e,1-n,r),o.add(s,r,r)};var c=new o,l=new o;o.angleBetween=function(e,t){o.normalize(e,c),o.normalize(t,l);var n=o.dot(c,l),r=o.magnitude(o.cross(c,l,c));return Math.atan2(r,n)};var h=new o;o.mostOrthogonalAxis=function(e,t){var n=o.normalize(e,h);return o.abs(n,n),t=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,t):o.clone(o.UNIT_Z,t):n.y<=n.z?o.clone(o.UNIT_Y,t):o.clone(o.UNIT_Z,t)},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},o.equalsEpsilon=function(e,t,r,a){return e===t||n(e)&&n(t)&&i.equalsEpsilon(e.x,t.x,r,a)&&i.equalsEpsilon(e.y,t.y,r,a)&&i.equalsEpsilon(e.z,t.z,r,a)},o.cross=function(e,t,n){var r=e.x,a=e.y,i=e.z,o=t.x,u=t.y,s=t.z,c=a*s-i*u,l=i*o-r*s,h=r*u-a*o;return n.x=c,n.y=l,n.z=h,n},o.fromDegrees=function(e,t,n,r,a){return e=i.toRadians(e),t=i.toRadians(t),o.fromRadians(e,t,n,r,a)};var f=new o,d=new o,E=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(e,r,a,i,u){a=t(a,0);var s=n(i)?i.radiiSquared:E,c=Math.cos(r);f.x=c*Math.cos(e),f.y=c*Math.sin(e),f.z=Math.sin(r),f=o.normalize(f,f),o.multiplyComponents(s,f,d);var l=Math.sqrt(o.dot(f,d));return d=o.divideByScalar(d,l,d),f=o.multiplyByScalar(f,a,f),n(u)||(u=new o),o.add(d,f,u)},o.fromDegreesArray=function(e,t,r){var a=e.length;n(r)?r.length=a/2:r=new Array(a/2);for(var i=0;i<a;i+=2){var u=e[i],s=e[i+1],c=i/2;r[c]=o.fromDegrees(u,s,0,t,r[c])}return r},o.fromRadiansArray=function(e,t,r){var a=e.length;n(r)?r.length=a/2:r=new Array(a/2);for(var i=0;i<a;i+=2){var u=e[i],s=e[i+1],c=i/2;r[c]=o.fromRadians(u,s,0,t,r[c])}return r},o.fromDegreesArrayHeights=function(e,t,r){var a=e.length;n(r)?r.length=a/3:r=new Array(a/3);for(var i=0;i<a;i+=3){var u=e[i],s=e[i+1],c=e[i+2],l=i/3;r[l]=o.fromDegrees(u,s,c,t,r[l])}return r},o.fromRadiansArrayHeights=function(e,t,r){var a=e.length;n(r)?r.length=a/3:r=new Array(a/3);for(var i=0;i<a;i+=3){var u=e[i],s=e[i+1],c=e[i+2],l=i/3;r[l]=o.fromRadians(u,s,c,t,r[l])}return r},o.ZERO=a(new o(0,0,0)),o.UNIT_X=a(new o(1,0,0)),o.UNIT_Y=a(new o(0,1,0)),o.UNIT_Z=a(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,n){return o.equalsEpsilon(this,e,t,n)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,n,r,a){"use strict";var i={};i.octEncodeInRange=function(e,t,n){if(n.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),n.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=n.x,i=n.y;n.x=(1-Math.abs(i))*a.signNotZero(r),n.y=(1-Math.abs(r))*a.signNotZero(i)}return n.x=a.toSNorm(n.x,t),n.y=a.toSNorm(n.y,t),n},i.octEncode=function(e,t){return i.octEncodeInRange(e,255,t)},i.octDecodeInRange=function(e,n,r,i){if(i.x=a.fromSNorm(e,r),i.y=a.fromSNorm(n,r),i.z=1-(Math.abs(i.x)+Math.abs(i.y)),i.z<0){var o=i.x;i.x=(1-Math.abs(i.y))*a.signNotZero(o),i.y=(1-Math.abs(o))*a.signNotZero(i.y)}return t.normalize(i,i)},i.octDecode=function(e,t,n){return i.octDecodeInRange(e,t,255,n)},i.octPackFloat=function(e){return 256*e.x+e.y};var o=new e;return i.octEncodeFloat=function(e){return i.octEncode(e,o),i.octPackFloat(o)},i.octDecodeFloat=function(e,t){var n=e/256,r=Math.floor(n),a=256*(n-r);return i.octDecode(r,a,t)},i.octPack=function(e,t,n,r){var a=i.octEncodeFloat(e),u=i.octEncodeFloat(t),s=i.octEncode(n,o);return r.x=65536*s.x+a,r.y=65536*s.y+u,r},i.octUnpack=function(e,t,n,r){var a=e.x/65536,o=Math.floor(a),u=65536*(a-o);a=e.y/65536;var s=Math.floor(a),c=65536*(a-s);i.octDecodeFloat(u,t),i.octDecodeFloat(c,n),i.octDecode(o,s,r)},i.compressTextureCoordinates=function(e){var t=4095*e.x|0,n=4095*e.y|0;return 4096*t+n},i.decompressTextureCoordinates=function(e,t){var n=e/4096,r=Math.floor(n);return t.x=r/4095,t.y=(e-4096*r)/4095,t},i}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,n,r){"use strict";function a(n,a,u,s,c){var l=n.x,h=n.y,f=n.z,d=a.x,E=a.y,m=a.z,p=l*l*d*d,_=h*h*E*E,T=f*f*m*m,y=p+_+T,R=Math.sqrt(1/y),A=e.multiplyByScalar(n,R,i);if(y<s)return isFinite(R)?e.clone(A,c):void 0;var S=u.x,N=u.y,M=u.z,I=o;I.x=A.x*S*2,I.y=A.y*N*2,I.z=A.z*M*2;var g,v,O,w,x,C,P,U,D,F,L,B=(1-R)*e.magnitude(n)/(.5*e.magnitude(I)),z=0;do{B-=z,O=1/(1+B*S),w=1/(1+B*N),x=1/(1+B*M),C=O*O,P=w*w,U=x*x,D=C*O,F=P*w,L=U*x,g=p*C+_*P+T*U-1,v=p*D*S+_*F*N+T*L*M;var b=-2*v;z=g/b}while(Math.abs(g)>r.EPSILON12);return t(c)?(c.x=l*O,c.y=h*w,c.z=f*x,c):new e(l*O,h*w,f*x)}var i=new e,o=new e;return a}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,a,i,o){"use strict";function u(e,n,r){this.longitude=t(e,0),this.latitude=t(n,0),this.height=t(r,0)}u.fromRadians=function(e,r,a,i){return a=t(a,0),n(i)?(i.longitude=e,i.latitude=r,i.height=a,i):new u(e,r,a)},u.fromDegrees=function(e,t,n,r){return e=i.toRadians(e),t=i.toRadians(t),u.fromRadians(e,t,n,r)};var s=new e,c=new e,l=new e,h=new e(1/6378137,1/6378137,1/6356752.314245179),f=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),d=i.EPSILON1;return u.fromCartesian=function(t,r,a){var E=n(r)?r.oneOverRadii:h,m=n(r)?r.oneOverRadiiSquared:f,p=n(r)?r._centerToleranceSquared:d,_=o(t,E,m,p,c);if(n(_)){var T=e.multiplyComponents(_,m,s);T=e.normalize(T,T);var y=e.subtract(t,_,l),R=Math.atan2(T.y,T.x),A=Math.asin(T.z),S=i.sign(e.dot(y,t))*e.magnitude(y);return n(a)?(a.longitude=R,a.latitude=A,a.height=S,a):new u(R,A,S)}},u.clone=function(e,t){if(n(e))return n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.longitude-t.longitude)<=r&&Math.abs(e.latitude-t.latitude)<=r&&Math.abs(e.height-t.height)<=r},u.ZERO=a(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),n=Object.defineProperties;return t&&e(n)||(n=function(e){return e}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,a,i,o,u,s){"use strict";function c(t,r,a,i){r=n(r,0),a=n(a,0),i=n(i,0),t._radii=new e(r,a,i),t._radiiSquared=new e(r*r,a*a,i*i),t._radiiToTheFourth=new e(r*r*r*r,a*a*a*a,i*i*i*i),t._oneOverRadii=new e(0===r?0:1/r,0===a?0:1/a,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===a?0:1/(a*a),0===i?0:1/(i*i)),t._minimumRadius=Math.min(r,a,i),t._maximumRadius=Math.max(r,a,i),t._centerToleranceSquared=u.EPSILON1,0!==t._radiiSquared.z&&(t._sqauredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._sqauredXOverSquaredZ=void 0,c(this,e,t,n)}a(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,n){if(r(t)){var a=t._radii;return r(n)?(e.clone(a,n._radii),e.clone(t._radiiSquared,n._radiiSquared),e.clone(t._radiiToTheFourth,n._radiiToTheFourth),e.clone(t._oneOverRadii,n._oneOverRadii),e.clone(t._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=t._minimumRadius,n._maximumRadius=t._maximumRadius,n._centerToleranceSquared=t._centerToleranceSquared,n):new l(a.x,a.y,a.z)}},l.fromCartesian3=function(e,t){return r(t)||(t=new l),r(e)?(c(t,e.x,e.y,e.z),t):t},l.WGS84=o(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=o(new l(1,1,1)),l.MOON=o(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,r,a){return a=n(a,0),e.pack(t._radii,r,a),r},l.unpack=function(t,r,a){r=n(r,0);var i=e.unpack(t,r);return l.fromCartesian3(i,a)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){var a=t.longitude,i=t.latitude,o=Math.cos(i),u=o*Math.cos(a),s=o*Math.sin(a),c=Math.sin(i);return r(n)||(n=new e),n.x=u,n.y=s,n.z=c,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,n){return r(n)||(n=new e),n=e.multiplyComponents(t,this._oneOverRadiiSquared,n),e.normalize(n,n)};var h=new e,f=new e;l.prototype.cartographicToCartesian=function(t,n){var a=h,i=f;this.geodeticSurfaceNormalCartographic(t,a),e.multiplyComponents(this._radiiSquared,a,i);var o=Math.sqrt(e.dot(a,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(a,t.height,a),r(n)||(n=new e),e.add(i,a,n)},l.prototype.cartographicArrayToCartesianArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var a=0;a<n;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var d=new e,E=new e,m=new e;return l.prototype.cartesianToCartographic=function(n,a){var i=this.scaleToGeodeticSurface(n,E);if(r(i)){var o=this.geodeticSurfaceNormal(i,d),s=e.subtract(n,i,m),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),h=u.sign(e.dot(s,n))*e.magnitude(s);return r(a)?(a.longitude=c,a.latitude=l,a.height=h,a):new t(c,l,h)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var a=0;a<n;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return s(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r(n)||(n=new e);var a=t.x,i=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(a*a*u.x+i*i*u.y+o*o*u.z);return e.multiplyByScalar(t,s,n)},l.prototype.transformPositionToScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._oneOverRadii,n)},l.prototype.transformPositionFromScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._radii,n)},l.prototype.equals=function(t){return this===t||r(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,a,i){a=n(a,0);var o=this._sqauredXOverSquaredZ;if(r(i)||(i=new e),i.x=0,i.y=0,i.z=t.z*(1-o),!(Math.abs(i.z)>=this._radii.z-a))return i},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,n,r,a,i,o){"use strict";function u(e){this._ellipsoid=n(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,n){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return r(n)?(n.x=i,n.y=o,n.z=u,n):new e(i,o,u)},u.prototype.unproject=function(e,n){var a=this._oneOverSemimajorAxis,i=e.x*a,o=e.y*a,u=e.z;return r(n)?(n.longitude=i,n.latitude=o,n.height=u,n):new t(i,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,n){this.start=e(t,0),this.stop=e(n,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a,i,o,u){"use strict";function s(e,t,r,a,i,o,u,s,c){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(u,0),this[3]=n(t,0),this[4]=n(i,0),this[5]=n(s,0),this[6]=n(r,0),this[7]=n(o,0),this[8]=n(c,0)}function c(e){for(var t=0,n=0;n<9;++n){var r=e[n];t+=r*r}return Math.sqrt(t)}function l(e){for(var t=0,n=0;n<3;++n){var r=e[s.getElementIndex(m[n],E[n])];t+=2*r*r}return Math.sqrt(t)}function h(e,t){for(var n=u.EPSILON15,r=0,a=1,i=0;i<3;++i){var o=Math.abs(e[s.getElementIndex(m[i],E[i])]);o>r&&(a=i,r=o)}var c=1,l=0,h=E[a],f=m[a];if(Math.abs(e[s.getElementIndex(f,h)])>n){var d,p=e[s.getElementIndex(f,f)],_=e[s.getElementIndex(h,h)],T=e[s.getElementIndex(f,h)],y=(p-_)/2/T;d=y<0?-1/(-y+Math.sqrt(1+y*y)):1/(y+Math.sqrt(1+y*y)),c=1/Math.sqrt(1+d*d),l=d*c}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(h,h)]=t[s.getElementIndex(f,f)]=c,t[s.getElementIndex(f,h)]=l,t[s.getElementIndex(h,f)]=-l,t}s.packedLength=9,s.pack=function(e,t,r){return r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t},s.unpack=function(e,t,a){return t=n(t,0),r(a)||(a=new s),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a},s.clone=function(e,t){if(r(e))return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,t,a){return t=n(t,0),r(a)||(a=new s),a[0]=e[t],a[1]=e[t+1],a[2]=e[t+2],a[3]=e[t+3],a[4]=e[t+4],a[5]=e[t+5],a[6]=e[t+6],a[7]=e[t+7],a[8]=e[t+8],a},s.fromColumnMajorArray=function(e,t){return s.clone(e,t)},s.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,t){var n=e.x*e.x,a=e.x*e.y,i=e.x*e.z,o=e.x*e.w,u=e.y*e.y,c=e.y*e.z,l=e.y*e.w,h=e.z*e.z,f=e.z*e.w,d=e.w*e.w,E=n-u-h+d,m=2*(a-f),p=2*(i+l),_=2*(a+f),T=-n+u-h+d,y=2*(c-o),R=2*(i-l),A=2*(c+o),S=-n-u+h+d;return r(t)?(t[0]=E,t[1]=_,t[2]=R,t[3]=m,t[4]=T,t[5]=A,t[6]=p,t[7]=y,t[8]=S,t):new s(E,m,p,_,T,y,R,A,S)},s.fromHeadingPitchRoll=function(e,t){var n=Math.cos(-e.pitch),a=Math.cos(-e.heading),i=Math.cos(e.roll),o=Math.sin(-e.pitch),u=Math.sin(-e.heading),c=Math.sin(e.roll),l=n*a,h=-i*u+c*o*a,f=c*u+i*o*a,d=n*u,E=i*a+c*o*u,m=-o*i+i*o*u,p=-o,_=c*n,T=i*n;return r(t)?(t[0]=l,t[1]=d,t[2]=p,t[3]=h,t[4]=E,t[5]=_,t[6]=f,t[7]=m,t[8]=T,t):new s(l,h,f,d,E,m,p,_,T)},s.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,t){return r(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=a,t[6]=0,t[7]=-a,t[8]=n,t):new s(1,0,0,0,n,-a,0,a,n)},s.fromRotationY=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=n,t):new s(n,0,a,0,1,0,-a,0,n)},s.fromRotationZ=function(e,t){var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=a,t[2]=0,t[3]=-a,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new s(n,-a,0,a,n,0,0,0,1)},s.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,t){return 3*e+t},s.getColumn=function(e,t,n){var r=3*t,a=e[r],i=e[r+1],o=e[r+2];return n.x=a,n.y=i,n.z=o,n},s.setColumn=function(e,t,n,r){r=s.clone(e,r);var a=3*t;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r},s.getRow=function(e,t,n){var r=e[t],a=e[t+3],i=e[t+6];return n.x=r,n.y=a,n.z=i,n},s.setRow=function(e,t,n,r){return r=s.clone(e,r),r[t]=n.x,r[t+3]=n.y,r[t+6]=n.z,r};var f=new e;s.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],f)),n.y=e.magnitude(e.fromElements(t[3],t[4],t[5],f)),n.z=e.magnitude(e.fromElements(t[6],t[7],t[8],f)),n};var d=new e;s.getMaximumScale=function(t){return s.getScale(t,d),e.maximumComponent(d)},s.multiply=function(e,t,n){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],h=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=r,n[1]=a,n[2]=i,n[3]=o,n[4]=u,n[5]=s,n[6]=c,n[7]=l,n[8]=h,n},s.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},s.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},s.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[3]*a+e[6]*i,u=e[1]*r+e[4]*a+e[7]*i,s=e[2]*r+e[5]*a+e[8]*i;return n.x=o,n.y=u,n.z=s,n},s.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},s.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n},s.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},s.transpose=function(e,t){var n=e[0],r=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=n,t[1]=r,t[2]=a,t[3]=i,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var E=[1,0,0],m=[2,2,1],p=new s,_=new s;return s.computeEigenDecomposition=function(e,t){var n=u.EPSILON20,a=10,i=0,o=0;r(t)||(t={});for(var f=t.unitary=s.clone(s.IDENTITY,t.unitary),d=t.diagonal=s.clone(e,t.diagonal),E=n*c(d);o<a&&l(d)>E;)h(d,p),s.transpose(p,_),s.multiply(d,p,d),s.multiply(_,d,d),s.multiply(f,p,f),++i>2&&(++o,i=0);return t},s.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},s.determinant=function(e){var t=e[0],n=e[3],r=e[6],a=e[1],i=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*o)+a*(s*r-n*c)+u*(n*o-i*r)},s.inverse=function(e,t){var n=e[0],r=e[1],a=e[2],i=e[3],o=e[4],u=e[5],c=e[6],l=e[7],h=e[8],f=s.determinant(e);t[0]=o*h-l*u,t[1]=l*a-r*h,t[2]=r*u-o*a,t[3]=c*u-i*h,t[4]=n*h-c*a,t[5]=i*a-n*u,t[6]=i*l-c*o,t[7]=c*r-n*l,t[8]=n*o-i*r;var d=1/f;return s.multiplyByScalar(t,d,t)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,a(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},
s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,a,i){"use strict";function o(e,n,r,a){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(a,0)}o.fromElements=function(e,t,r,a,i){return n(i)?(i.x=e,i.y=t,i.z=r,i.w=a,i):new o(e,t,r,a)},o.fromColor=function(e,t){return n(t)?(t.x=e.red,t.y=e.green,t.z=e.blue,t.w=e.alpha,t):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w)},o.packedLength=4,o.pack=function(e,n,r){return r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w,n},o.unpack=function(e,r,a){return r=t(r,0),n(a)||(a=new o),a.x=e[r++],a.y=e[r++],a.z=e[r++],a.w=e[r],a},o.packArray=function(e,t){var r=e.length;n(t)?t.length=4*r:t=new Array(4*r);for(var a=0;a<r;++a)o.pack(e[a],t,4*a);return t},o.unpackArray=function(e,t){var r=e.length;n(t)?t.length=r/4:t=new Array(r/4);for(var a=0;a<r;a+=4){var i=a/4;t[i]=o.unpack(e,a,t[i])}return t},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},o.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(e,t){var n=o.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},o.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n},o.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n.z=e.z/t.z,n.w=e.w/t.w,n},o.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},o.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},o.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},o.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var s=new o;o.lerp=function(e,t,n,r){return o.multiplyByScalar(t,n,s),r=o.multiplyByScalar(e,1-n,r),o.add(s,r,r)};var c=new o;return o.mostOrthogonalAxis=function(e,t){var n=o.normalize(e,c);return o.abs(n,n),t=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,t):o.clone(o.UNIT_W,t):n.z<=n.w?o.clone(o.UNIT_Z,t):o.clone(o.UNIT_W,t):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,t):o.clone(o.UNIT_W,t):n.z<=n.w?o.clone(o.UNIT_Z,t):o.clone(o.UNIT_W,t)},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]},o.equalsEpsilon=function(e,t,r,a){return e===t||n(e)&&n(t)&&i.equalsEpsilon(e.x,t.x,r,a)&&i.equalsEpsilon(e.y,t.y,r,a)&&i.equalsEpsilon(e.z,t.z,r,a)&&i.equalsEpsilon(e.w,t.w,r,a)},o.ZERO=a(new o(0,0,0,0)),o.UNIT_X=a(new o(1,0,0,0)),o.UNIT_Y=a(new o(0,1,0,0)),o.UNIT_Z=a(new o(0,0,1,0)),o.UNIT_W=a(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,n){return o.equalsEpsilon(this,e,t,n)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,n,r,a,i,o,u,s,c){"use strict";function l(e,t,n,a,i,o,u,s,c,l,h,f,d,E,m,p){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(c,0),this[3]=r(d,0),this[4]=r(t,0),this[5]=r(o,0),this[6]=r(l,0),this[7]=r(E,0),this[8]=r(n,0),this[9]=r(u,0),this[10]=r(h,0),this[11]=r(m,0),this[12]=r(a,0),this[13]=r(s,0),this[14]=r(f,0),this[15]=r(p,0)}l.packedLength=16,l.pack=function(e,t,n){return n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15],t},l.unpack=function(e,t,n){return t=r(t,0),a(n)||(n=new l),n[0]=e[t++],n[1]=e[t++],n[2]=e[t++],n[3]=e[t++],n[4]=e[t++],n[5]=e[t++],n[6]=e[t++],n[7]=e[t++],n[8]=e[t++],n[9]=e[t++],n[10]=e[t++],n[11]=e[t++],n[12]=e[t++],n[13]=e[t++],n[14]=e[t++],n[15]=e[t],n},l.clone=function(e,t){if(a(e))return a(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},l.fromArray=l.unpack,l.fromColumnMajorArray=function(e,t){return l.clone(e,t)},l.fromRowMajorArray=function(e,t){return a(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(t,n,i){return n=r(n,e.ZERO),a(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=n.x,i[13]=n.y,i[14]=n.z,i[15]=1,i):new l(t[0],t[3],t[6],n.x,t[1],t[4],t[7],n.y,t[2],t[5],t[8],n.z,0,0,0,1)},l.fromTranslationQuaternionRotationScale=function(e,t,n,r){a(r)||(r=new l);var i=n.x,o=n.y,u=n.z,s=t.x*t.x,c=t.x*t.y,h=t.x*t.z,f=t.x*t.w,d=t.y*t.y,E=t.y*t.z,m=t.y*t.w,p=t.z*t.z,_=t.z*t.w,T=t.w*t.w,y=s-d-p+T,R=2*(c-_),A=2*(h+m),S=2*(c+_),N=-s+d-p+T,M=2*(E-f),I=2*(h-m),g=2*(E+f),v=-s-d+p+T;return r[0]=y*i,r[1]=S*i,r[2]=I*i,r[3]=0,r[4]=R*o,r[5]=N*o,r[6]=g*o,r[7]=0,r[8]=A*u,r[9]=M*u,r[10]=v*u,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r},l.fromTranslationRotationScale=function(e,t){return l.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},l.fromTranslation=function(e,t){return l.fromRotationTranslation(s.IDENTITY,e,t)},l.fromScale=function(e,t){return a(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,t){return a(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var h=new e,f=new e,d=new e;l.fromCamera=function(t,n){var r=t.position,i=t.direction,o=t.up;e.normalize(i,h),e.normalize(e.cross(h,o,f),f),e.normalize(e.cross(f,h,d),d);var u=f.x,s=f.y,c=f.z,E=h.x,m=h.y,p=h.z,_=d.x,T=d.y,y=d.z,R=r.x,A=r.y,S=r.z,N=u*-R+s*-A+c*-S,M=_*-R+T*-A+y*-S,I=E*R+m*A+p*S;return a(n)?(n[0]=u,n[1]=_,n[2]=-E,n[3]=0,n[4]=s,n[5]=T,n[6]=-m,n[7]=0,n[8]=c,n[9]=y,n[10]=-p,n[11]=0,n[12]=N,n[13]=M,n[14]=I,n[15]=1,n):new l(u,s,c,N,_,T,y,M,-E,-m,-p,I,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,t,n,r,a){var i=Math.tan(.5*e),o=1/i,u=o/t,s=(r+n)/(n-r),c=2*r*n/(n-r);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},l.computeOrthographicOffCenter=function(e,t,n,r,a,i,o){var u=1/(t-e),s=1/(r-n),c=1/(i-a),l=-(t+e)*u,h=-(r+n)*s,f=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=h,o[14]=f,o[15]=1,o},l.computePerspectiveOffCenter=function(e,t,n,r,a,i,o){var u=2*a/(t-e),s=2*a/(r-n),c=(t+e)/(t-e),l=(r+n)/(r-n),h=-(i+a)/(i-a),f=-1,d=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=h,o[11]=f,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},l.computeInfinitePerspectiveOffCenter=function(e,t,n,r,a,i){var o=2*a/(t-e),u=2*a/(r-n),s=(t+e)/(t-e),c=(r+n)/(r-n),l=-1,h=-1,f=-2*a;return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=h,i[12]=0,i[13]=0,i[14]=f,i[15]=0,i},l.computeViewportTransformation=function(e,t,n,a){e=r(e,r.EMPTY_OBJECT);var i=r(e.x,0),o=r(e.y,0),u=r(e.width,0),s=r(e.height,0);t=r(t,0),n=r(n,1);var c=.5*u,l=.5*s,h=.5*(n-t),f=c,d=l,E=h,m=i+c,p=o+l,_=t+h,T=1;return a[0]=f,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=d,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=E,a[11]=0,a[12]=m,a[13]=p,a[14]=_,a[15]=T,a},l.computeView=function(t,n,r,a,i){return i[0]=a.x,i[1]=r.x,i[2]=-n.x,i[3]=0,i[4]=a.y,i[5]=r.y,i[6]=-n.y,i[7]=0,i[8]=a.z,i[9]=r.z,i[10]=-n.z,i[11]=0,i[12]=-e.dot(a,t),i[13]=-e.dot(r,t),i[14]=e.dot(n,t),i[15]=1,i},l.toArray=function(e,t){return a(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,t){return 4*e+t},l.getColumn=function(e,t,n){var r=4*t,a=e[r],i=e[r+1],o=e[r+2],u=e[r+3];return n.x=a,n.y=i,n.z=o,n.w=u,n},l.setColumn=function(e,t,n,r){r=l.clone(e,r);var a=4*t;return r[a]=n.x,r[a+1]=n.y,r[a+2]=n.z,r[a+3]=n.w,r},l.setTranslation=function(e,t,n){return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n},l.getRow=function(e,t,n){var r=e[t],a=e[t+4],i=e[t+8],o=e[t+12];return n.x=r,n.y=a,n.z=i,n.w=o,n},l.setRow=function(e,t,n,r){return r=l.clone(e,r),r[t]=n.x,r[t+4]=n.y,r[t+8]=n.z,r[t+12]=n.w,r};var E=new e;l.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],E)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],E)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],E)),n};var m=new e;l.getMaximumScale=function(t){return l.getScale(t,m),e.maximumComponent(m)},l.multiply=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],h=e[8],f=e[9],d=e[10],E=e[11],m=e[12],p=e[13],_=e[14],T=e[15],y=t[0],R=t[1],A=t[2],S=t[3],N=t[4],M=t[5],I=t[6],g=t[7],v=t[8],O=t[9],w=t[10],x=t[11],C=t[12],P=t[13],U=t[14],D=t[15],F=r*y+u*R+h*A+m*S,L=a*y+s*R+f*A+p*S,B=i*y+c*R+d*A+_*S,z=o*y+l*R+E*A+T*S,b=r*N+u*M+h*I+m*g,q=a*N+s*M+f*I+p*g,G=i*N+c*M+d*I+_*g,W=o*N+l*M+E*I+T*g,X=r*v+u*O+h*w+m*x,V=a*v+s*O+f*w+p*x,H=i*v+c*O+d*w+_*x,Y=o*v+l*O+E*w+T*x,k=r*C+u*P+h*U+m*D,Z=a*C+s*P+f*U+p*D,j=i*C+c*P+d*U+_*D,K=o*C+l*P+E*U+T*D;return n[0]=F,n[1]=L,n[2]=B,n[3]=z,n[4]=b,n[5]=q,n[6]=G,n[7]=W,n[8]=X,n[9]=V,n[10]=H,n[11]=Y,n[12]=k,n[13]=Z,n[14]=j,n[15]=K,n},l.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},l.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},l.multiplyTransformation=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],h=e[10],f=e[12],d=e[13],E=e[14],m=t[0],p=t[1],_=t[2],T=t[4],y=t[5],R=t[6],A=t[8],S=t[9],N=t[10],M=t[12],I=t[13],g=t[14],v=r*m+o*p+c*_,O=a*m+u*p+l*_,w=i*m+s*p+h*_,x=r*T+o*y+c*R,C=a*T+u*y+l*R,P=i*T+s*y+h*R,U=r*A+o*S+c*N,D=a*A+u*S+l*N,F=i*A+s*S+h*N,L=r*M+o*I+c*g+f,B=a*M+u*I+l*g+d,z=i*M+s*I+h*g+E;return n[0]=v,n[1]=O,n[2]=w,n[3]=0,n[4]=x,n[5]=C,n[6]=P,n[7]=0,n[8]=U,n[9]=D,n[10]=F,n[11]=0,n[12]=L,n[13]=B,n[14]=z,n[15]=1,n},l.multiplyByMatrix3=function(e,t,n){var r=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],h=e[10],f=t[0],d=t[1],E=t[2],m=t[3],p=t[4],_=t[5],T=t[6],y=t[7],R=t[8],A=r*f+o*d+c*E,S=a*f+u*d+l*E,N=i*f+s*d+h*E,M=r*m+o*p+c*_,I=a*m+u*p+l*_,g=i*m+s*p+h*_,v=r*T+o*y+c*R,O=a*T+u*y+l*R,w=i*T+s*y+h*R;return n[0]=A,n[1]=S,n[2]=N,n[3]=0,n[4]=M,n[5]=I,n[6]=g,n[7]=0,n[8]=v,n[9]=O,n[10]=w,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},l.multiplyByTranslation=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=r*e[0]+a*e[4]+i*e[8]+e[12],u=r*e[1]+a*e[5]+i*e[9]+e[13],s=r*e[2]+a*e[6]+i*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=o,n[13]=u,n[14]=s,n[15]=e[15],n};var p=new e;l.multiplyByUniformScale=function(e,t,n){return p.x=t,p.y=t,p.z=t,l.multiplyByScale(e,p,n)},l.multiplyByScale=function(e,t,n){var r=t.x,a=t.y,i=t.z;return 1===r&&1===a&&1===i?l.clone(e,n):(n[0]=r*e[0],n[1]=r*e[1],n[2]=r*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=i*e[8],n[9]=i*e[9],n[10]=i*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},l.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=t.w,u=e[0]*r+e[4]*a+e[8]*i+e[12]*o,s=e[1]*r+e[5]*a+e[9]*i+e[13]*o,c=e[2]*r+e[6]*a+e[10]*i+e[14]*o,l=e[3]*r+e[7]*a+e[11]*i+e[15]*o;return n.x=u,n.y=s,n.z=c,n.w=l,n},l.multiplyByPointAsVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[4]*a+e[8]*i,u=e[1]*r+e[5]*a+e[9]*i,s=e[2]*r+e[6]*a+e[10]*i;return n.x=o,n.y=u,n.z=s,n},l.multiplyByPoint=function(e,t,n){var r=t.x,a=t.y,i=t.z,o=e[0]*r+e[4]*a+e[8]*i+e[12],u=e[1]*r+e[5]*a+e[9]*i+e[13],s=e[2]*r+e[6]*a+e[10]*i+e[14];return n.x=o,n.y=u,n.z=s,n},l.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},l.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},l.transpose=function(e,t){var n=e[1],r=e[2],a=e[3],i=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=o,t[14]=u,t[15]=e[15],t},l.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},l.equals=function(e,t){return e===t||a(e)&&a(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},l.equalsEpsilon=function(e,t,n){return e===t||a(e)&&a(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},l.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},l.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var _=new s,T=new s,y=new t,R=new t(0,0,0,1);return l.inverse=function(e,n){if(s.equalsEpsilon(l.getRotation(e,_),T,u.EPSILON7)&&t.equals(l.getRow(e,3,y),R))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var r=e[0],a=e[4],i=e[8],o=e[12],h=e[1],f=e[5],d=e[9],E=e[13],m=e[2],p=e[6],A=e[10],S=e[14],N=e[3],M=e[7],I=e[11],g=e[15],v=A*g,O=S*I,w=p*g,x=S*M,C=p*I,P=A*M,U=m*g,D=S*N,F=m*I,L=A*N,B=m*M,z=p*N,b=v*f+x*d+C*E-(O*f+w*d+P*E),q=O*h+U*d+L*E-(v*h+D*d+F*E),G=w*h+D*f+B*E-(x*h+U*f+z*E),W=P*h+F*f+z*d-(C*h+L*f+B*d),X=O*a+w*i+P*o-(v*a+x*i+C*o),V=v*r+D*i+F*o-(O*r+U*i+L*o),H=x*r+U*a+z*o-(w*r+D*a+B*o),Y=C*r+L*a+B*i-(P*r+F*a+z*i);v=i*E,O=o*d,w=a*E,x=o*f,C=a*d,P=i*f,U=r*E,D=o*h,F=r*d,L=i*h,B=r*f,z=a*h;var k=v*M+x*I+C*g-(O*M+w*I+P*g),Z=O*N+U*I+L*g-(v*N+D*I+F*g),j=w*N+D*M+B*g-(x*N+U*M+z*g),K=P*N+F*M+z*I-(C*N+L*M+B*I),Q=w*A+P*S+O*p-(C*S+v*p+x*A),J=F*S+v*m+D*A-(U*A+L*S+O*m),$=U*p+z*S+x*m-(B*S+w*m+D*p),ee=B*A+C*m+L*p-(F*p+z*A+P*m),te=r*b+a*q+i*G+o*W;if(Math.abs(te)<u.EPSILON20)throw new c("matrix is not invertible because its determinate is zero.");return te=1/te,n[0]=b*te,n[1]=q*te,n[2]=G*te,n[3]=W*te,n[4]=X*te,n[5]=V*te,n[6]=H*te,n[7]=Y*te,n[8]=k*te,n[9]=Z*te,n[10]=j*te,n[11]=K*te,n[12]=Q*te,n[13]=J*te,n[14]=$*te,n[15]=ee*te,n},l.inverseTransformation=function(e,t){var n=e[0],r=e[1],a=e[2],i=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],h=e[12],f=e[13],d=e[14],E=-n*h-r*f-a*d,m=-i*h-o*f-u*d,p=-s*h-c*f-l*d;return t[0]=n,t[1]=i,t[2]=s,t[3]=0,t[4]=r,t[5]=o,t[6]=c,t[7]=0,t[8]=a,t[9]=u,t[10]=l,t[11]=0,t[12]=E,t[13]=m,t[14]=p,t[15]=1,t},l.IDENTITY=o(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.ZERO=o(new l(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,i(l.prototype,{length:{get:function(){return l.packedLength}}}),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,n,r,a,i,o,u){"use strict";function s(e,t,r,a){this.west=n(e,0),this.south=n(t,0),this.east=n(r,0),this.north=n(a,0)}a(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,t,r){return r=n(r,0),t[r++]=e.west,t[r++]=e.south,t[r++]=e.east,t[r]=e.north,t},s.unpack=function(e,t,a){return t=n(t,0),r(a)||(a=new s),a.west=e[t++],a.south=e[t++],a.east=e[t++],a.north=e[t],a},s.computeWidth=function(e){var t=e.east,n=e.west;return t<n&&(t+=u.TWO_PI),t-n},s.computeHeight=function(e){return e.north-e.south},s.fromDegrees=function(e,t,a,i,o){return e=u.toRadians(n(e,0)),t=u.toRadians(n(t,0)),a=u.toRadians(n(a,0)),i=u.toRadians(n(i,0)),r(o)?(o.west=e,o.south=t,o.east=a,o.north=i,o):new s(e,t,a,i)},s.fromRadians=function(e,t,a,i,o){return r(o)?(o.west=n(e,0),o.south=n(t,0),o.east=n(a,0),o.north=n(i,0),o):new s(e,t,a,i)},s.fromCartographicArray=function(e,t){for(var n=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,c=Number.MAX_VALUE,l=-Number.MAX_VALUE,h=0,f=e.length;h<f;h++){var d=e[h];n=Math.min(n,d.longitude),a=Math.max(a,d.longitude),c=Math.min(c,d.latitude),l=Math.max(l,d.latitude);var E=d.longitude>=0?d.longitude:d.longitude+u.TWO_PI;i=Math.min(i,E),o=Math.max(o,E)}return a-n>o-i&&(n=i,a=o,a>u.PI&&(a-=u.TWO_PI),n>u.PI&&(n-=u.TWO_PI)),r(t)?(t.west=n,t.south=c,t.east=a,t.north=l,t):new s(n,c,a,l)},s.fromCartesianArray=function(e,t,n){for(var a=Number.MAX_VALUE,i=-Number.MAX_VALUE,o=Number.MAX_VALUE,c=-Number.MAX_VALUE,l=Number.MAX_VALUE,h=-Number.MAX_VALUE,f=0,d=e.length;f<d;f++){var E=t.cartesianToCartographic(e[f]);a=Math.min(a,E.longitude),i=Math.max(i,E.longitude),l=Math.min(l,E.latitude),h=Math.max(h,E.latitude);var m=E.longitude>=0?E.longitude:E.longitude+u.TWO_PI;o=Math.min(o,m),c=Math.max(c,m)}return i-a>c-o&&(a=o,i=c,i>u.PI&&(i-=u.TWO_PI),a>u.PI&&(a-=u.TWO_PI)),r(n)?(n.west=a,n.south=l,n.east=i,n.north=h,n):new s(a,l,i,h)},s.clone=function(e,t){if(r(e))return r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north)},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,t){return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},s.validate=function(e){},s.southwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.south,n.height=0,n):new e(t.west,t.south)},s.northwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.north,n.height=0,n):new e(t.west,t.north)},s.northeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.north,n.height=0,n):new e(t.east,t.north)},s.southeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.south,n.height=0,n):new e(t.east,t.south)},s.center=function(t,n){var a=t.east,i=t.west;a<i&&(a+=u.TWO_PI);var o=u.negativePiToPi(.5*(i+a)),s=.5*(t.south+t.north);return r(n)?(n.longitude=o,n.latitude=s,n.height=0,n):new e(o,s)},s.intersection=function(e,t,n){var a=e.east,i=e.west,o=t.east,c=t.west;a<i&&o>0?a+=u.TWO_PI:o<c&&a>0&&(o+=u.TWO_PI),a<i&&c<0?c+=u.TWO_PI:o<c&&i<0&&(i+=u.TWO_PI);var l=u.negativePiToPi(Math.max(i,c)),h=u.negativePiToPi(Math.min(a,o));if(!((e.west<e.east||t.west<t.east)&&h<=l)){var f=Math.max(e.south,t.south),d=Math.min(e.north,t.north);if(!(f>=d))return r(n)?(n.west=l,n.south=f,n.east=h,n.north=d,n):new s(l,f,h,d)}},s.simpleIntersection=function(e,t,n){var a=Math.max(e.west,t.west),i=Math.max(e.south,t.south),o=Math.min(e.east,t.east),u=Math.min(e.north,t.north);if(!(i>=u||a>=o))return r(n)?(n.west=a,n.south=i,n.east=o,n.north=u,n):new s(a,i,o,u)},s.union=function(e,t,n){r(n)||(n=new s);var a=e.east,i=e.west,o=t.east,c=t.west;a<i&&o>0?a+=u.TWO_PI:o<c&&a>0&&(o+=u.TWO_PI),a<i&&c<0?c+=u.TWO_PI:o<c&&i<0&&(i+=u.TWO_PI);var l=u.convertLongitudeRange(Math.min(i,c)),h=u.convertLongitudeRange(Math.max(a,o));return n.west=l,n.south=Math.min(e.south,t.south),n.east=h,n.north=Math.max(e.north,t.north),n},s.expand=function(e,t,n){return r(n)||(n=new s),n.west=Math.min(e.west,t.longitude),n.south=Math.min(e.south,t.latitude),n.east=Math.max(e.east,t.longitude),n.north=Math.max(e.north,t.latitude),n},s.contains=function(e,t){var n=t.longitude,r=t.latitude,a=e.west,i=e.east;return i<a&&(i+=u.TWO_PI,n<0&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(n<i||u.equalsEpsilon(n,i,u.EPSILON14))&&r>=e.south&&r<=e.north};var c=new e;return s.subsample=function(e,t,a,o){t=n(t,i.WGS84),a=n(a,0),r(o)||(o=[]);var l=0,h=e.north,f=e.south,d=e.east,E=e.west,m=c;m.height=a,m.longitude=E,m.latitude=h,o[l]=t.cartographicToCartesian(m,o[l]),l++,m.longitude=d,o[l]=t.cartographicToCartesian(m,o[l]),l++,m.latitude=f,o[l]=t.cartographicToCartesian(m,o[l]),l++,m.longitude=E,o[l]=t.cartographicToCartesian(m,o[l]),l++,h<0?m.latitude=h:f>0?m.latitude=f:m.latitude=0;for(var p=1;p<8;++p)m.longitude=-Math.PI+p*u.PI_OVER_TWO,s.contains(e,m)&&(o[l]=t.cartographicToCartesian(m,o[l]),l++);return 0===m.latitude&&(m.longitude=E,o[l]=t.cartographicToCartesian(m,o[l]),l++,m.longitude=d,o[l]=t.cartographicToCartesian(m,o[l]),l++),o.length=l,o},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Rectangle"],function(e,t,n,r,a,i,o,u,s,c,l,h){"use strict";function f(t,n){this.center=e.clone(r(t,e.ZERO)),this.radius=r(n,0)}var d=new e,E=new e,m=new e,p=new e,_=new e,T=new e,y=new e,R=new e,A=new e,S=new e,N=new e,M=new e;f.fromPoints=function(t,n){if(a(n)||(n=new f),!a(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;for(var r=e.clone(t[0],y),i=e.clone(r,d),o=e.clone(r,E),u=e.clone(r,m),s=e.clone(r,p),c=e.clone(r,_),l=e.clone(r,T),h=t.length,I=1;I<h;I++){e.clone(t[I],r);var g=r.x,v=r.y,O=r.z;g<i.x&&e.clone(r,i),g>s.x&&e.clone(r,s),v<o.y&&e.clone(r,o),v>c.y&&e.clone(r,c),O<u.z&&e.clone(r,u),O>l.z&&e.clone(r,l)}var w=e.magnitudeSquared(e.subtract(s,i,R)),x=e.magnitudeSquared(e.subtract(c,o,R)),C=e.magnitudeSquared(e.subtract(l,u,R)),P=i,U=s,D=w;x>D&&(D=x,P=o,U=c),C>D&&(D=C,P=u,U=l);var F=A;F.x=.5*(P.x+U.x),F.y=.5*(P.y+U.y),F.z=.5*(P.z+U.z);var L=e.magnitudeSquared(e.subtract(U,F,R)),B=Math.sqrt(L),z=S;z.x=i.x,z.y=o.y,z.z=u.z;var b=N;b.x=s.x,b.y=c.y,b.z=l.z;var q=e.multiplyByScalar(e.add(z,b,R),.5,M),G=0;for(I=0;I<h;I++){e.clone(t[I],r);var W=e.magnitude(e.subtract(r,q,R));W>G&&(G=W);var X=e.magnitudeSquared(e.subtract(r,F,R));if(X>L){var V=Math.sqrt(X);B=.5*(B+V),L=B*B;var H=V-B;F.x=(B*F.x+H*r.x)/V,F.y=(B*F.y+H*r.y)/V,F.z=(B*F.z+H*r.z)/V}}return B<G?(e.clone(F,n.center),n.radius=B):(e.clone(q,n.center),n.radius=G),n};var I=new o,g=new e,v=new e,O=new t,w=new t;f.fromRectangle2D=function(e,t,n){return f.fromRectangleWithHeights2D(e,t,0,0,n)},f.fromRectangleWithHeights2D=function(t,n,i,o,u){if(a(u)||(u=new f),!a(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;n=r(n,I),h.southwest(t,O),O.height=i,h.northeast(t,w),w.height=o;var s=n.project(O,g),c=n.project(w,v),l=c.x-s.x,d=c.y-s.y,E=c.z-s.z;u.radius=.5*Math.sqrt(l*l+d*d+E*E);var m=u.center;return m.x=s.x+.5*l,m.y=s.y+.5*d,m.z=s.z+.5*E,u};var x=[];f.fromRectangle3D=function(e,t,n,o){t=r(t,i.WGS84),n=r(n,0);var u;return a(e)&&(u=h.subsample(e,t,n,x)),f.fromPoints(u,o)},f.fromVertices=function(t,n,i,o){if(a(o)||(o=new f),!a(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;n=r(n,e.ZERO),i=r(i,3);var u=y;u.x=t[0]+n.x,u.y=t[1]+n.y,u.z=t[2]+n.z;for(var s=e.clone(u,d),c=e.clone(u,E),l=e.clone(u,m),h=e.clone(u,p),I=e.clone(u,_),g=e.clone(u,T),v=t.length,O=0;O<v;O+=i){var w=t[O]+n.x,x=t[O+1]+n.y,C=t[O+2]+n.z;u.x=w,u.y=x,u.z=C,w<s.x&&e.clone(u,s),w>h.x&&e.clone(u,h),x<c.y&&e.clone(u,c),x>I.y&&e.clone(u,I),C<l.z&&e.clone(u,l),C>g.z&&e.clone(u,g)}var P=e.magnitudeSquared(e.subtract(h,s,R)),U=e.magnitudeSquared(e.subtract(I,c,R)),D=e.magnitudeSquared(e.subtract(g,l,R)),F=s,L=h,B=P;U>B&&(B=U,F=c,L=I),D>B&&(B=D,F=l,L=g);var z=A;z.x=.5*(F.x+L.x),z.y=.5*(F.y+L.y),z.z=.5*(F.z+L.z);var b=e.magnitudeSquared(e.subtract(L,z,R)),q=Math.sqrt(b),G=S;G.x=s.x,G.y=c.y,G.z=l.z;var W=N;W.x=h.x,W.y=I.y,W.z=g.z;var X=e.multiplyByScalar(e.add(G,W,R),.5,M),V=0;for(O=0;O<v;O+=i){u.x=t[O]+n.x,u.y=t[O+1]+n.y,u.z=t[O+2]+n.z;var H=e.magnitude(e.subtract(u,X,R));H>V&&(V=H);var Y=e.magnitudeSquared(e.subtract(u,z,R));if(Y>b){var k=Math.sqrt(Y);q=.5*(q+k),b=q*q;var Z=k-q;z.x=(q*z.x+Z*u.x)/k,z.y=(q*z.y+Z*u.y)/k,z.z=(q*z.z+Z*u.z)/k}}return q<V?(e.clone(z,o.center),o.radius=q):(e.clone(X,o.center),o.radius=V),o},f.fromEncodedCartesianVertices=function(t,n,r){if(a(r)||(r=new f),!a(t)||!a(n)||t.length!==n.length||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var i=y;i.x=t[0]+n[0],i.y=t[1]+n[1],i.z=t[2]+n[2];for(var o=e.clone(i,d),u=e.clone(i,E),s=e.clone(i,m),c=e.clone(i,p),l=e.clone(i,_),h=e.clone(i,T),I=t.length,g=0;g<I;g+=3){var v=t[g]+n[g],O=t[g+1]+n[g+1],w=t[g+2]+n[g+2];i.x=v,i.y=O,i.z=w,v<o.x&&e.clone(i,o),v>c.x&&e.clone(i,c),O<u.y&&e.clone(i,u),O>l.y&&e.clone(i,l),w<s.z&&e.clone(i,s),w>h.z&&e.clone(i,h)}var x=e.magnitudeSquared(e.subtract(c,o,R)),C=e.magnitudeSquared(e.subtract(l,u,R)),P=e.magnitudeSquared(e.subtract(h,s,R)),U=o,D=c,F=x;C>F&&(F=C,U=u,D=l),P>F&&(F=P,U=s,D=h);var L=A;L.x=.5*(U.x+D.x),L.y=.5*(U.y+D.y),L.z=.5*(U.z+D.z);var B=e.magnitudeSquared(e.subtract(D,L,R)),z=Math.sqrt(B),b=S;b.x=o.x,b.y=u.y,b.z=s.z;var q=N;q.x=c.x,q.y=l.y,q.z=h.z;var G=e.multiplyByScalar(e.add(b,q,R),.5,M),W=0;for(g=0;g<I;g+=3){i.x=t[g]+n[g],i.y=t[g+1]+n[g+1],i.z=t[g+2]+n[g+2];var X=e.magnitude(e.subtract(i,G,R));X>W&&(W=X);var V=e.magnitudeSquared(e.subtract(i,L,R));if(V>B){var H=Math.sqrt(V);z=.5*(z+H),B=z*z;var Y=H-z;L.x=(z*L.x+Y*i.x)/H,L.y=(z*L.y+Y*i.y)/H,L.z=(z*L.z+Y*i.z)/H}}return z<W?(e.clone(L,r.center),r.radius=z):(e.clone(G,r.center),r.radius=W),r},f.fromCornerPoints=function(t,n,r){a(r)||(r=new f);var i=r.center;return e.add(t,n,i),e.multiplyByScalar(i,.5,i),r.radius=e.distance(i,n),r},f.fromEllipsoid=function(t,n){return a(n)||(n=new f),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var C=new e;f.fromBoundingSpheres=function(t,n){if(a(n)||(n=new f),!a(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var r=t.length;if(1===r)return f.clone(t[0],n);if(2===r)return f.union(t[0],t[1],n);for(var i=[],o=0;o<r;o++)i.push(t[o].center);n=f.fromPoints(i,n);var u=n.center,s=n.radius;for(o=0;o<r;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,C)+c.radius)}return n.radius=s,n};var P=new e,U=new e,D=new e;f.fromOrientedBoundingBox=function(t,n){a(n)||(n=new f);var r=t.halfAxes,i=c.getColumn(r,0,P),o=c.getColumn(r,1,U),u=c.getColumn(r,2,D),s=e.magnitude(i),l=e.magnitude(o),h=e.magnitude(u);return n.center=e.clone(t.center,n.center),n.radius=Math.max(s,l,h),n},f.clone=function(t,n){if(a(t))return a(n)?(n.center=e.clone(t.center,n.center),n.radius=t.radius,n):new f(t.center,t.radius)},f.packedLength=4,f.pack=function(e,t,n){n=r(n,0);var a=e.center;return t[n++]=a.x,t[n++]=a.y,t[n++]=a.z,t[n]=e.radius,t},f.unpack=function(e,t,n){t=r(t,0),a(n)||(n=new f);var i=n.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],n.radius=e[t],n};var F=new e,L=new e;f.union=function(t,n,r){a(r)||(r=new f);var i=t.center,o=t.radius,u=n.center,s=n.radius,c=e.subtract(u,i,F),l=e.magnitude(c);if(o>=l+s)return t.clone(r),r;if(s>=l+o)return n.clone(r),r;var h=.5*(o+l+s),d=e.multiplyByScalar(c,(-o+h)/l,L);return e.add(d,i,d),e.clone(d,r.center),r.radius=h,r};var B=new e;f.expand=function(t,n,r){r=f.clone(t,r);var a=e.magnitude(e.subtract(n,r.center,B));return a>r.radius&&(r.radius=a),r},f.intersectPlane=function(t,n){var r=t.center,a=t.radius,i=n.normal,o=e.dot(i,r)+n.distance;return o<-a?u.OUTSIDE:o<a?u.INTERSECTING:u.INSIDE},f.transform=function(e,t,n){return a(n)||(n=new f),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var z=new e;f.distanceSquaredTo=function(t,n){var r=e.subtract(t.center,n,z);return e.magnitudeSquared(r)-t.radius*t.radius},f.transformWithoutScale=function(e,t,n){return a(n)||(n=new f),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var b=new e;f.computePlaneDistances=function(t,n,r,i){a(i)||(i=new s);var o=e.subtract(t.center,n,b),u=e.dot(r,o);return i.start=u-t.radius,i.stop=u+t.radius,i};for(var q=new e,G=new e,W=new e,X=new e,V=new e,H=new t,Y=new Array(8),k=0;k<8;++k)Y[k]=new e;var Z=new o;return f.projectTo2D=function(t,n,a){n=r(n,Z);var i=n.ellipsoid,o=t.center,u=t.radius,s=i.geodeticSurfaceNormal(o,q),c=e.cross(e.UNIT_Z,s,G);
e.normalize(c,c);var l=e.cross(s,c,W);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var h=e.negate(l,V),d=e.negate(c,X),E=Y,m=E[0];e.add(s,l,m),e.add(m,c,m),m=E[1],e.add(s,l,m),e.add(m,d,m),m=E[2],e.add(s,h,m),e.add(m,d,m),m=E[3],e.add(s,h,m),e.add(m,c,m),e.negate(s,s),m=E[4],e.add(s,l,m),e.add(m,c,m),m=E[5],e.add(s,l,m),e.add(m,d,m),m=E[6],e.add(s,h,m),e.add(m,d,m),m=E[7],e.add(s,h,m),e.add(m,c,m);for(var p=E.length,_=0;_<p;++_){var T=E[_];e.add(o,T,T);var y=i.cartesianToCartographic(T,H);n.project(y,T)}a=f.fromPoints(E,a),o=a.center;var R=o.x,A=o.y,S=o.z;return o.x=S,o.y=R,o.z=A,a},f.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},f.equals=function(t,n){return t===n||a(t)&&a(n)&&e.equals(t.center,n.center)&&t.radius===n.radius},f.prototype.intersectPlane=function(e){return f.intersectPlane(this,e)},f.prototype.distanceSquaredTo=function(e){return f.distanceSquaredTo(this,e)},f.prototype.computePlaneDistances=function(e,t,n){return f.computePlaneDistances(this,e,t,n)},f.prototype.isOccluded=function(e){return f.isOccluded(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.clone=function(e){return f.clone(this,e)},f}),define("Core/EllipsoidalOccluder",["./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Rectangle"],function(e,t,n,r,a,i,o){"use strict";function u(e,n){this._ellipsoid=e,this._cameraPosition=new t,this._cameraPositionInScaledSpace=new t,this._distanceToLimbInScaledSpaceSquared=0,r(n)&&(this.cameraPosition=n)}function s(e,n,r){var a=e.transformPositionToScaledSpace(n,E),i=t.magnitudeSquared(a),o=Math.sqrt(i),u=t.divideByScalar(a,o,m);i=Math.max(1,i),o=Math.max(1,o);var s=t.dot(u,r),c=t.magnitude(t.cross(u,r,u)),l=1/o,h=Math.sqrt(i-1)*l;return 1/(s*l-c*h)}function c(e,n,r){if(!(n<=0||n===1/0||n!==n))return t.multiplyByScalar(e,n,r)}function l(e,n){return t.equals(n,t.ZERO)?n:(e.transformPositionToScaledSpace(n,p),t.normalize(p,p))}a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var n=this._ellipsoid,r=n.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),a=t.magnitudeSquared(r)-1;t.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=r,this._distanceToLimbInScaledSpaceSquared=a}}});var h=new t;u.prototype.isPointVisible=function(e){var t=this._ellipsoid,n=t.transformPositionToScaledSpace(e,h);return this.isScaledSpacePointVisible(n)},u.prototype.isScaledSpacePointVisible=function(e){var n=this._cameraPositionInScaledSpace,r=this._distanceToLimbInScaledSpaceSquared,a=t.subtract(e,n,h),i=-t.dot(a,n),o=r<0?i>0:i>r&&i*i/t.magnitudeSquared(a)>r;return!o},u.prototype.computeHorizonCullingPoint=function(e,n,a){r(a)||(a=new t);for(var i=this._ellipsoid,o=l(i,e),u=0,h=0,f=n.length;h<f;++h){var d=n[h],E=s(i,d,o);u=Math.max(u,E)}return c(o,u,a)};var f=new t;u.prototype.computeHorizonCullingPointFromVertices=function(e,a,i,o,u){r(u)||(u=new t),o=n(o,t.ZERO);for(var h=this._ellipsoid,d=l(h,e),E=0,m=0,p=a.length;m<p;m+=i){f.x=a[m]+o.x,f.y=a[m+1]+o.y,f.z=a[m+2]+o.z;var _=s(h,f,d);E=Math.max(E,_)}return c(d,E,u)};var d=[];u.prototype.computeHorizonCullingPointFromRectangle=function(n,r,a){var i=o.subsample(n,r,0,d),u=e.fromPoints(i);if(!(t.magnitude(u.center)<.1*r.minimumRadius))return this.computeHorizonCullingPoint(u.center,i,a)};var E=new t,m=new t,p=new t;return u}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};return e(t)}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,n,r,a){"use strict";var i={UNSIGNED_BYTE:a.UNSIGNED_BYTE,UNSIGNED_SHORT:a.UNSIGNED_SHORT,UNSIGNED_INT:a.UNSIGNED_INT};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(t){return e(t)&&(t===i.UNSIGNED_BYTE||t===i.UNSIGNED_SHORT||t===i.UNSIGNED_INT)},i.createTypedArray=function(e,t){return e>=r.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},i.createTypedArrayFromArrayBuffer=function(e,t,n,a){return e>=r.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,n,a):new Uint16Array(t,n,a)},n(i)}),define("Core/Intersections2D",["./Cartesian3","./defined","./DeveloperError"],function(e,t,n){"use strict";var r={};return r.clipTriangleAtAxisAlignedThreshold=function(e,n,r,a,i,o){t(o)?o.length=0:o=[];var u,s,c;n?(u=r<e,s=a<e,c=i<e):(u=r>e,s=a>e,c=i>e);var l,h,f,d,E,m,p=u+s+c;return 1===p?u?(l=(e-r)/(a-r),h=(e-r)/(i-r),o.push(1),o.push(2),1!==h&&(o.push(-1),o.push(0),o.push(2),o.push(h)),1!==l&&(o.push(-1),o.push(0),o.push(1),o.push(l))):s?(f=(e-a)/(i-a),d=(e-a)/(r-a),o.push(2),o.push(0),1!==d&&(o.push(-1),o.push(1),o.push(0),o.push(d)),1!==f&&(o.push(-1),o.push(1),o.push(2),o.push(f))):c&&(E=(e-i)/(r-i),m=(e-i)/(a-i),o.push(0),o.push(1),1!==m&&(o.push(-1),o.push(2),o.push(1),o.push(m)),1!==E&&(o.push(-1),o.push(2),o.push(0),o.push(E))):2===p?u||r===e?s||a===e?c||i===e||(h=(e-r)/(i-r),f=(e-a)/(i-a),o.push(2),o.push(-1),o.push(0),o.push(2),o.push(h),o.push(-1),o.push(1),o.push(2),o.push(f)):(m=(e-i)/(a-i),l=(e-r)/(a-r),o.push(1),o.push(-1),o.push(2),o.push(1),o.push(m),o.push(-1),o.push(0),o.push(1),o.push(l)):(d=(e-a)/(r-a),E=(e-i)/(r-i),o.push(0),o.push(-1),o.push(1),o.push(0),o.push(d),o.push(-1),o.push(2),o.push(0),o.push(E)):3!==p&&(o.push(0),o.push(1),o.push(2)),o},r.computeBarycentricCoordinates=function(n,r,a,i,o,u,s,c,l){var h=a-s,f=s-o,d=u-c,E=i-c,m=1/(d*h+f*E),p=r-c,_=n-s,T=(d*_+f*p)*m,y=(-E*_+h*p)*m,R=1-T-y;return t(l)?(l.x=T,l.y=y,l.z=R,l):new e(T,y,R)},r}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,t,n,r,a){"use strict";function i(r,a,i){this.minimum=e.clone(t(r,e.ZERO)),this.maximum=e.clone(t(a,e.ZERO)),n(i)?i=e.clone(i):(i=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(i,.5,i)),this.center=i}i.fromPoints=function(t,r){if(n(r)||(r=new i),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var a=t[0].x,o=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,h=t.length,f=1;f<h;f++){var d=t[f],E=d.x,m=d.y,p=d.z;a=Math.min(E,a),s=Math.max(E,s),o=Math.min(m,o),c=Math.max(m,c),u=Math.min(p,u),l=Math.max(p,l)}var _=r.minimum;_.x=a,_.y=o,_.z=u;var T=r.maximum;T.x=s,T.y=c,T.z=l;var y=e.add(_,T,r.center);return e.multiplyByScalar(y,.5,y),r},i.clone=function(t,r){if(n(t))return n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new i(t.minimum,t.maximum)},i.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var o=new e;return i.intersectPlane=function(t,n){o=e.subtract(t.maximum,t.minimum,o);var r=e.multiplyByScalar(o,.5,o),i=n.normal,u=r.x*Math.abs(i.x)+r.y*Math.abs(i.y)+r.z*Math.abs(i.z),s=e.dot(t.center,i)+n.distance;return s-u>0?a.INSIDE:s+u<0?a.OUTSIDE:a.INTERSECTING},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.intersectPlane=function(e){return i.intersectPlane(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function n(e,n,r){var a=e+n;return t.sign(e)!==t.sign(n)&&Math.abs(a/Math.max(Math.abs(e),Math.abs(n)))<r?0:a}var r={};return r.computeDiscriminant=function(e,t,n){var r=t*t-4*e*n;return r},r.computeRealRoots=function(e,r,a){var i;if(0===e)return 0===r?[]:[-a/r];if(0===r){if(0===a)return[0,0];var o=Math.abs(a),u=Math.abs(e);if(o<u&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(i=-a/e,i<0)return[];var s=Math.sqrt(i);return[-s,s]}if(0===a)return i=-r/e,i<0?[i,0]:[0,i];var c=r*r,l=4*e*a,h=n(c,-l,t.EPSILON14);if(h<0)return[];var f=-.5*n(r,t.sign(r)*Math.sqrt(h),t.EPSILON14);return r>0?[f/e,a/f]:[a/f,f/e]},r}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function n(e,t,n,r){var a,i,o=e,u=t/3,s=n/3,c=r,l=o*s,h=u*c,f=u*u,d=s*s,E=o*s-f,m=o*c-u*s,p=u*c-d,_=4*E*p-m*m;if(_<0){var T,y,R;f*h>=l*d?(T=o,y=E,R=-2*u*E+o*m):(T=c,y=p,R=-c*m+2*s*p);var A=R<0?-1:1,S=-A*Math.abs(T)*Math.sqrt(-_);i=-R+S;var N=i/2,M=N<0?-Math.pow(-N,1/3):Math.pow(N,1/3),I=i===S?-M:-y/M;return a=y<=0?M+I:-R/(M*M+I*I+y),f*h>=l*d?[(a-u)/o]:[-c/(a+s)]}var g=E,v=-2*u*E+o*m,O=p,w=-c*m+2*s*p,x=Math.sqrt(_),C=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*x,-v)/3);a=2*Math.sqrt(-g);var U=Math.cos(P);i=a*U;var D=a*(-U/2-C*Math.sin(P)),F=i+D>2*u?i-u:D-u,L=o,B=F/L;P=Math.abs(Math.atan2(c*x,-w)/3),a=2*Math.sqrt(-O),U=Math.cos(P),i=a*U,D=a*(-U/2-C*Math.sin(P));var z=-c,b=i+D<2*s?i+s:D+s,q=z/b,G=L*b,W=-F*b-L*z,X=F*z,V=(s*W-u*X)/(-u*W+s*G);return B<=V?B<=q?V<=q?[B,V,q]:[B,q,V]:[q,B,V]:B<=q?[V,B,q]:V<=q?[V,q,B]:[q,V,B]}var r={};return r.computeDiscriminant=function(e,t,n,r){var a=e*e,i=t*t,o=n*n,u=r*r,s=18*e*t*n*r+i*o-27*a*u-4*(e*o*n+i*t*r);return s},r.computeRealRoots=function(e,r,a,i){var o,u;if(0===e)return t.computeRealRoots(r,a,i);if(0===r){if(0===a){if(0===i)return[0,0,0];u=-i/e;var s=u<0?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(o=t.computeRealRoots(e,0,a),0===o.Length?[0]:[o[0],0,o[1]]):n(e,0,a,i)}return 0===a?0===i?(u=-r/e,u<0?[u,0,0]:[0,0,u]):n(e,r,0,i):0===i?(o=t.computeRealRoots(e,r,a),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):n(e,r,a,i)},r}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,n,r){"use strict";function a(t,a,i,o){var u=t*t,s=a-3*u/8,c=i-a*t/2+u*t/8,l=o-i*t/4+a*u/16-3*u*u/256,h=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(h.length>0){var f=-t/4,d=h[h.length-1];if(Math.abs(d)<n.EPSILON14){var E=r.computeRealRoots(1,s,l);if(2===E.length){var m,p=E[0],_=E[1];if(p>=0&&_>=0){var T=Math.sqrt(p),y=Math.sqrt(_);return[f-y,f-T,f+T,f+y]}if(p>=0&&_<0)return m=Math.sqrt(p),[f-m,f+m];if(p<0&&_>=0)return m=Math.sqrt(_),[f-m,f+m]}return[]}if(d>0){var R=Math.sqrt(d),A=(s+d-c/R)/2,S=(s+d+c/R)/2,N=r.computeRealRoots(1,R,A),M=r.computeRealRoots(1,-R,S);return 0!==N.length?(N[0]+=f,N[1]+=f,0!==M.length?(M[0]+=f,M[1]+=f,N[1]<=M[0]?[N[0],N[1],M[0],M[1]]:M[1]<=N[0]?[M[0],M[1],N[0],N[1]]:N[0]>=M[0]&&N[1]<=M[1]?[M[0],N[0],N[1],M[1]]:M[0]>=N[0]&&M[1]<=N[1]?[N[0],M[0],M[1],N[1]]:N[0]>M[0]&&N[0]<M[1]?[M[0],N[0],M[1],N[1]]:[N[0],M[0],N[1],M[1]]):N):0!==M.length?(M[0]+=f,M[1]+=f,M):[]}}return[]}function i(t,a,i,o){var u=i*i,s=a*a,c=t*t,l=-2*a,h=i*t+s-4*o,f=c*o-i*a*t+u,d=e.computeRealRoots(1,l,h,f);if(d.length>0){var E,m,p=d[0],_=a-p,T=_*_,y=t/2,R=_/2,A=T-4*o,S=T+4*Math.abs(o),N=c-4*p,M=c+4*Math.abs(p);if(p<0||A*M<N*S){var I=Math.sqrt(N);E=I/2,m=0===I?0:(t*R-i)/I}else{var g=Math.sqrt(A);E=0===g?0:(t*R-i)/g,m=g/2}var v,O;0===y&&0===E?(v=0,O=0):n.sign(y)===n.sign(E)?(v=y+E,O=p/v):(O=y-E,v=p/O);var w,x;0===R&&0===m?(w=0,x=0):n.sign(R)===n.sign(m)?(w=R+m,x=o/w):(x=R-m,w=o/x);var C=r.computeRealRoots(1,v,w),P=r.computeRealRoots(1,O,x);if(0!==C.length)return 0!==P.length?C[1]<=P[0]?[C[0],C[1],P[0],P[1]]:P[1]<=C[0]?[P[0],P[1],C[0],C[1]]:C[0]>=P[0]&&C[1]<=P[1]?[P[0],C[0],C[1],P[1]]:P[0]>=C[0]&&P[1]<=C[1]?[C[0],P[0],P[1],C[1]]:C[0]>P[0]&&C[0]<P[1]?[P[0],C[0],P[1],C[1]]:[C[0],P[0],C[1],P[1]]:C;if(0!==P.length)return P}return[]}var o={};return o.computeDiscriminant=function(e,t,n,r,a){var i=e*e,o=i*e,u=t*t,s=u*t,c=n*n,l=c*n,h=r*r,f=h*r,d=a*a,E=d*a,m=u*c*h-4*s*f-4*e*l*h+18*e*t*n*f-27*i*h*h+256*o*E+a*(18*s*n*r-4*u*l+16*e*c*c-80*e*t*c*r-6*e*u*h+144*i*n*h)+d*(144*e*u*n-27*u*u-128*i*c-192*i*t*r);return m},o.computeRealRoots=function(t,r,o,u,s){if(Math.abs(t)<n.EPSILON15)return e.computeRealRoots(r,o,u,s);var c=r/t,l=o/t,h=u/t,f=s/t,d=c<0?1:0;switch(d+=l<0?d+1:d,d+=h<0?d+1:d,d+=f<0?d+1:d){case 0:return a(c,l,h,f);case 1:return i(c,l,h,f);case 2:return i(c,l,h,f);case 3:return a(c,l,h,f);case 4:return a(c,l,h,f);case 5:return i(c,l,h,f);case 6:return a(c,l,h,f);case 7:return a(c,l,h,f);case 8:return i(c,l,h,f);case 9:return a(c,l,h,f);case 10:return a(c,l,h,f);case 11:return i(c,l,h,f);case 12:return a(c,l,h,f);case 13:return a(c,l,h,f);case 14:return a(c,l,h,f);case 15:return a(c,l,h,f);default:return}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";function a(n,r){r=e.clone(t(r,e.ZERO)),e.equals(r,e.ZERO)||e.normalize(r,r),this.origin=e.clone(t(n,e.ZERO)),this.direction=r}return a.getPoint=function(t,r,a){return n(a)||(a=new e),a=e.multiplyByScalar(t.direction,r,a),e.add(t.origin,a,a)},a}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,n,r,a,i,o,u,s,c,l){"use strict";function h(e,t,n,r){var a=t*t-4*e*n;if(!(a<0)){if(a>0){var i=1/(2*e),o=Math.sqrt(a),u=(-t+o)*i,s=(-t-o)*i;return u<s?(r.root0=u,r.root1=s):(r.root0=s,r.root1=u),r}var c=-t/(2*e);if(0!==c)return r.root0=r.root1=c,r}}function f(t,n,a){r(a)||(a=new i);var o=t.origin,u=t.direction,s=n.center,c=n.radius*n.radius,l=e.subtract(o,s,T),f=e.dot(u,u),d=2*e.dot(u,l),E=e.magnitudeSquared(l)-c,m=h(f,d,E,S);if(r(m))return a.start=m.root0,a.stop=m.root1,a}function d(e,t,n){var r=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<n?0:r}function E(t,n,r,a,i){var l,h=a*a,f=i*i,E=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*f,m=i*(a*d(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],o.EPSILON15)+n.y),p=t[u.COLUMN0ROW0]*h+t[u.COLUMN2ROW2]*f+a*n.x+r,_=f*d(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],o.EPSILON15),T=i*(a*d(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+n.z),y=[];if(0===T&&0===_){if(l=s.computeRealRoots(E,m,p),0===l.length)return y;var R=l[0],A=Math.sqrt(Math.max(1-R*R,0));if(y.push(new e(a,i*R,i*-A)),y.push(new e(a,i*R,i*A)),2===l.length){var S=l[1],N=Math.sqrt(Math.max(1-S*S,0));y.push(new e(a,i*S,i*-N)),y.push(new e(a,i*S,i*N))}return y}var M=T*T,I=_*_,g=E*E,v=T*_,O=g+I,w=2*(m*E+v),x=2*p*E+m*m-I+M,C=2*(p*m-v),P=p*p-M;if(0===O&&0===w&&0===x&&0===C)return y;l=c.computeRealRoots(O,w,x,C,P);var U=l.length;if(0===U)return y;for(var D=0;D<U;++D){var F,L=l[D],B=L*L,z=Math.max(1-B,0),b=Math.sqrt(z);F=o.sign(E)===o.sign(p)?d(E*B+p,m*L,o.EPSILON12):o.sign(p)===o.sign(m*L)?d(E*B,m*L+p,o.EPSILON12):d(E*B+m*L,p,o.EPSILON12);var q=d(_*L,T,o.EPSILON15),G=F*q;G<0?y.push(new e(a,i*L,i*b)):G>0?y.push(new e(a,i*L,i*-b)):0!==b?(y.push(new e(a,i*L,i*-b)),y.push(new e(a,i*L,i*b)),++D):y.push(new e(a,i*L,i*b))}return y}var m={};m.rayPlane=function(t,n,a){r(a)||(a=new e);var i=t.origin,u=t.direction,s=n.normal,c=e.dot(s,u);if(!(Math.abs(c)<o.EPSILON15)){var l=(-n.distance-e.dot(s,i))/c;if(!(l<0))return a=e.multiplyByScalar(u,l,a),e.add(i,a,a)}};var p=new e,_=new e,T=new e,y=new e,R=new e;m.rayTriangleParametric=function(t,r,a,i,u){u=n(u,!1);var s,c,l,h,f,d=t.origin,E=t.direction,m=e.subtract(a,r,p),A=e.subtract(i,r,_),S=e.cross(E,A,T),N=e.dot(m,S);if(u){if(N<o.EPSILON6)return;if(s=e.subtract(d,r,y),l=e.dot(s,S),l<0||l>N)return;if(c=e.cross(s,m,R),h=e.dot(E,c),h<0||l+h>N)return;f=e.dot(A,c)/N}else{if(Math.abs(N)<o.EPSILON6)return;var M=1/N;if(s=e.subtract(d,r,y),l=e.dot(s,S)*M,l<0||l>1)return;if(c=e.cross(s,m,R),h=e.dot(E,c)*M,h<0||l+h>1)return;f=e.dot(A,c)*M}return f},m.rayTriangle=function(t,n,a,i,o,u){var s=m.rayTriangleParametric(t,n,a,i,o);if(r(s)&&!(s<0))return r(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var A=new l;m.lineSegmentTriangle=function(t,n,a,i,o,u,s){var c=A;e.clone(t,c.origin),e.subtract(n,t,c.direction),e.normalize(c.direction,c.direction);var l=m.rayTriangleParametric(c,a,i,o,u);if(!(!r(l)||l<0||l>e.distance(t,n)))return r(s)||(s=new e),e.multiplyByScalar(c.direction,l,s),e.add(c.origin,s,s)};var S={root0:0,root1:0};m.raySphere=function(e,t,n){if(n=f(e,t,n),r(n)&&!(n.stop<0))return n.start=Math.max(n.start,0),n};var N=new l;m.lineSegmentSphere=function(t,n,a,i){var o=N;e.clone(t,o.origin);var u=e.subtract(n,t,o.direction),s=e.magnitude(u);if(e.normalize(u,u),i=f(o,a,i),!(!r(i)||i.stop<0||i.start>s))return i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i};var M=new e,I=new e;m.rayEllipsoid=function(t,n){var r,a,o,u,s,c=n.oneOverRadii,l=e.multiplyComponents(c,t.origin,M),h=e.multiplyComponents(c,t.direction,I),f=e.magnitudeSquared(l),d=e.dot(l,h);if(f>1){if(d>=0)return;var E=d*d;if(r=f-1,a=e.magnitudeSquared(h),o=a*r,E<o)return;if(E>o){u=d*d-o,s=-d+Math.sqrt(u);var m=s/a,p=r/s;return m<p?new i(m,p):{start:p,stop:m}}var _=Math.sqrt(r/a);return new i(_,_)}return f<1?(r=f-1,a=e.magnitudeSquared(h),o=a*r,u=d*d-o,s=-d+Math.sqrt(u),new i(0,s/a)):d<0?(a=e.magnitudeSquared(h),new i(0,-d/a)):void 0};var g=new e,v=new e,O=new e,w=new e,x=new e,C=new u,P=new u,U=new u,D=new u,F=new u,L=new u,B=new u,z=new e,b=new e,q=new t;m.grazingAltitudeLocation=function(t,n){var a=t.origin,i=t.direction;if(!e.equals(a,e.ZERO)){var s=n.geodeticSurfaceNormal(a,g);if(e.dot(i,s)>=0)return a}var c=r(this.rayEllipsoid(t,n)),l=n.transformPositionToScaledSpace(i,g),h=e.normalize(l,l),f=e.mostOrthogonalAxis(l,w),d=e.normalize(e.cross(f,h,v),v),m=e.normalize(e.cross(h,d,O),O),p=C;p[0]=h.x,p[1]=h.y,p[2]=h.z,p[3]=d.x,p[4]=d.y,p[5]=d.z,p[6]=m.x,p[7]=m.y,p[8]=m.z;var _=u.transpose(p,P),T=u.fromScale(n.radii,U),y=u.fromScale(n.oneOverRadii,D),R=F;R[0]=0,R[1]=-i.z,R[2]=i.y,R[3]=i.z,R[4]=0,R[5]=-i.x,R[6]=-i.y,R[7]=i.x,R[8]=0;var A,S,N=u.multiply(u.multiply(_,y,L),R,L),M=u.multiply(u.multiply(N,T,B),p,B),I=u.multiplyByVector(N,a,x),G=E(M,e.negate(I,g),0,0,1),W=G.length;if(W>0){for(var X=e.clone(e.ZERO,b),V=Number.NEGATIVE_INFINITY,H=0;H<W;++H){A=u.multiplyByVector(T,u.multiplyByVector(p,G[H],z),z);var Y=e.normalize(e.subtract(A,a,w),w),k=e.dot(Y,i);k>V&&(V=k,X=e.clone(A,X))}var Z=n.cartesianToCartographic(X,q);return V=o.clamp(V,0,1),S=e.magnitude(e.subtract(X,a,w))*Math.sqrt(1-V*V),S=c?-S:S,Z.height=S,n.cartographicToCartesian(Z,new e)}};var G=new e;return m.lineSegmentPlane=function(t,n,a,i){r(i)||(i=new e);var u=e.subtract(n,t,G),s=a.normal,c=e.dot(s,u);if(!(Math.abs(c)<o.EPSILON6)){var l=e.dot(s,t),h=-(a.distance+l)/c;if(!(h<0||h>1))return e.multiplyByScalar(u,h,i),e.add(t,i,i),i}},m.trianglePlaneIntersection=function(t,n,r,a){var i=a.normal,o=a.distance,u=e.dot(i,t)+o<0,s=e.dot(i,n)+o<0,c=e.dot(i,r)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var h,f;if(1!==l&&2!==l||(h=new e,f=new e),1===l){if(u)return m.lineSegmentPlane(t,n,a,h),m.lineSegmentPlane(t,r,a,f),{positions:[t,n,r,h,f],indices:[0,3,4,1,2,4,1,4,3]
};if(s)return m.lineSegmentPlane(n,r,a,h),m.lineSegmentPlane(n,t,a,f),{positions:[t,n,r,h,f],indices:[1,3,4,2,0,4,2,4,3]};if(c)return m.lineSegmentPlane(r,t,a,h),m.lineSegmentPlane(r,n,a,f),{positions:[t,n,r,h,f],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return m.lineSegmentPlane(n,t,a,h),m.lineSegmentPlane(r,t,a,f),{positions:[t,n,r,h,f],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return m.lineSegmentPlane(r,n,a,h),m.lineSegmentPlane(t,n,a,f),{positions:[t,n,r,h,f],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return m.lineSegmentPlane(t,r,a,h),m.lineSegmentPlane(n,r,a,f),{positions:[t,n,r,h,f],indices:[0,1,4,0,4,3,2,3,4]}}},m}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,n,r){"use strict";function a(t,n){this.normal=e.clone(t),this.distance=n}a.fromPointNormal=function(n,r,i){var o=-e.dot(r,n);return t(i)?(e.clone(r,i.normal),i.distance=o,i):new a(r,o)};var i=new e;return a.fromCartesian4=function(n,r){var o=e.fromCartesian4(n,i),u=n.w;return t(r)?(e.clone(o,r.normal),r.distance=u,r):new a(o,u)},a.getPointDistance=function(t,n){return e.dot(t.normal,n)+t.distance},a.ORIGIN_XY_PLANE=r(new a(e.UNIT_Z,0)),a.ORIGIN_YZ_PLANE=r(new a(e.UNIT_X,0)),a.ORIGIN_ZX_PLANE=r(new a(e.UNIT_Y,0)),a}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,n,r,a){return t(e).then(n,r,a)}function t(e){var t,n;return e instanceof r?t=e:u(e)?(n=o(),e.then(function(e){n.resolve(e)},function(e){n.reject(e)},function(e){n.progress(e)}),t=n.promise):t=a(e),t}function n(t){return e(t,i)}function r(e){this.then=e}function a(e){var n=new r(function(n){try{return t(n?n(e):e)}catch(e){return i(e)}});return n}function i(e){var n=new r(function(n,r){try{return r?t(r(e)):i(e)}catch(e){return i(e)}});return n}function o(){function e(e,t,n){return f(e,t,n)}function n(e){return E(e)}function a(e){return E(i(e))}function u(e){return d(e)}var s,c,l,h,f,d,E;return c=new r(e),s={then:e,resolve:n,reject:a,progress:u,promise:c,resolver:{resolve:n,reject:a,progress:u}},l=[],h=[],f=function(e,t,n){var r,a;return r=o(),a="function"==typeof n?function(e){try{r.progress(n(e))}catch(e){r.progress(e)}}:function(e){r.progress(e)},l.push(function(n){n.then(e,t).then(r.resolve,r.reject,a)}),h.push(a),r.promise},d=function(e){return m(h,e),e},E=function(e){return e=t(e),f=e.then,E=t,d=_,m(l,e),h=l=A,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,n,r,a,i){return p(2,arguments),e(t,function(t){function u(e){m(e)}function s(e){E(e)}var c,l,h,f,d,E,m,p,T,y;if(T=t.length>>>0,c=Math.max(0,Math.min(n,T)),h=[],l=T-c+1,f=[],d=o(),c)for(p=d.progress,m=function(e){f.push(e),--l||(E=m=_,d.reject(f))},E=function(e){h.push(e),--c||(E=m=_,d.resolve(h))},y=0;y<T;++y)y in t&&e(t[y],s,u,p);else d.resolve(h);return d.then(r,a,i)})}function c(e,t,n,r){function a(e){return t?t(e[0]):e[0]}return s(e,1,a,n,r)}function l(e,t,n,r){return p(1,arguments),f(e,T).then(t,n,r)}function h(){return f(arguments,T)}function f(t,n){return e(t,function(t){var r,a,i,u,s,c;if(i=a=t.length>>>0,r=[],c=o(),i)for(u=function(t,a){e(t,n).then(function(e){r[a]=e,--i||c.resolve(r)},c.reject)},s=0;s<a;s++)s in t?u(t[s],s):--i;else c.resolve(r);return c.promise})}function d(t,n){var r=R.call(arguments,1);return e(t,function(t){var a;return a=t.length,r[0]=function(t,r,i){return e(t,function(t){return e(r,function(e){return n(t,e,i,a)})})},y.apply(t,r)})}function E(t,n,r){var a=arguments.length>2;return e(t,function(e){return e=a?r:e,n.resolve(e),e},function(e){return n.reject(e),i(e)},n.progress)}function m(e,t){for(var n,r=0;n=e[r++];)n(t)}function p(e,t){for(var n,r=t.length;r>e;)if(n=t[--r],null!=n&&"function"!=typeof n)throw new Error("arg "+r+" must be a function")}function _(){}function T(e){return e}var y,R,A;return e.defer=o,e.resolve=t,e.reject=n,e.join=h,e.all=l,e.map=f,e.reduce=d,e.any=c,e.some=s,e.chain=E,e.isPromise=u,r.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(A,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(A,t)})})}},R=[].slice,y=[].reduce||function(e){var t,n,r,a,i;if(i=0,t=Object(this),a=t.length>>>0,n=arguments,n.length<=1)for(;;){if(i in t){r=t[i++];break}if(++i>=a)throw new TypeError}else r=n[1];for(;i<a;++i)i in t&&(r=e(r,t[i],i,t));return r},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],function(e,t,n){"use strict";function r(n,r){t(a[n])||(a[n]=!0,console.warn(e(r,n)))}var a={};return r.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",r}),define("Core/deprecationWarning",["./defined","./DeveloperError","./oneTimeWarning"],function(e,t,n){"use strict";function r(e,t){n(e,t)}return r}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";function n(e,t,n){for(var r,a,i=0,o=e.length-1;i<=o;)if(r=~~((i+o)/2),a=n(e[r],t),a<0)i=r+1;else{if(!(a>0))return r;o=r-1}return~(o+1)}return n}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,n,r,a){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=n,this.yPoleOffset=r,this.ut1MinusUtc=a}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,n=0,r=t[n++],a=function(e,t,n,r){n||(n=" ");var a=e.length>=t?"":Array(1+t-e.length>>>0).join(n);return r?e+a:a+e},i=function(e,t,n,r,i,o){var u=r-e.length;return u>0&&(e=n||!i?a(e,r,o,n):e.slice(0,t.length)+a("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,n,r,o,u,s){var c=e>>>0;return n=n&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=n+a(c.toString(t),u||0,"0",!1),i(e,n,r,o,s)},u=function(e,t,n,r,a,o){return null!=r&&(e=e.slice(0,r)),i(e,"",t,n,a,o)},s=function(e,r,s,c,l,h,f){var d,E,m,p,_;if("%%"==e)return"%";for(var T=!1,y="",R=!1,A=!1,S=" ",N=s.length,M=0;s&&M<N;M++)switch(s.charAt(M)){case" ":y=" ";break;case"+":y="+";break;case"-":T=!0;break;case"'":S=s.charAt(M+1);break;case"0":R=!0;break;case"#":A=!0}if(c=c?"*"==c?+t[n++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,c<0&&(c=-c,T=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(h=h?"*"==h?+t[n++]:"*"==h.charAt(0)?+t[h.slice(1,-1)]:+h:"fFeE".indexOf(f)>-1?6:"d"==f?0:void 0,_=r?t[r.slice(0,-1)]:t[n++],f){case"s":return u(String(_),T,c,h,R,S);case"c":return u(String.fromCharCode(+_),T,c,h,R);case"b":return o(_,2,A,T,c,h,R);case"o":return o(_,8,A,T,c,h,R);case"x":return o(_,16,A,T,c,h,R);case"X":return o(_,16,A,T,c,h,R).toUpperCase();case"u":return o(_,10,A,T,c,h,R);case"i":case"d":return d=+_||0,d=Math.round(d-d%1),E=d<0?"-":y,_=E+a(String(Math.abs(d)),h,"0",!1),i(_,E,T,c,R);case"e":case"E":case"f":case"F":case"g":case"G":return d=+_,E=d<0?"-":y,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(f.toLowerCase())],p=["toString","toUpperCase"]["eEfFgG".indexOf(f)%2],_=E+Math.abs(d)[m](h),i(_,E,T,c,R)[p]();default:return e}};return r.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,n,r,a,i,o,u){this.year=e,this.month=t,this.day=n,this.hour=r,this.minute=a,this.second=i,this.millisecond=o,this.isLeapSecond=u}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(e){return e%4===0&&e%100!==0||e%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,n,r,a,i,o,u,s,c){"use strict";function l(e,t){return m.compare(e.julianDate,t.julianDate)}function h(e){y.julianDate=e;var n=m.leapSeconds,r=t(n,y,l);r<0&&(r=~r),r>=n.length&&(r=n.length-1);var a=n[r].offset;if(r>0){var i=m.secondsDifference(n[r].julianDate,e);i>a&&(r--,a=n[r].offset)}m.addSeconds(e,a,e)}function f(e,n){y.julianDate=e;var r=m.leapSeconds,a=t(r,y,l);if(a<0&&(a=~a),0===a)return m.addSeconds(e,-r[0].offset,n);if(a>=r.length)return m.addSeconds(e,-r[a-1].offset,n);var i=m.secondsDifference(r[a].julianDate,e);return 0===i?m.addSeconds(e,-r[a].offset,n):i<=1?void 0:m.addSeconds(e,-r[--a].offset,n)}function d(e,t,n){var r=t/s.SECONDS_PER_DAY|0;return e+=r,t-=s.SECONDS_PER_DAY*r,t<0&&(e--,t+=s.SECONDS_PER_DAY),n.dayNumber=e,n.secondsOfDay=t,n}function E(e,t,n,r,a,i,o){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+n-32075;r-=12,r<0&&(r+=24);var h=i+(r*s.SECONDS_PER_HOUR+a*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return h>=43200&&(l-=1),[l,h]}function m(e,t,r){this.dayNumber=void 0,this.secondsOfDay=void 0,e=n(e,0),t=n(t,0),r=n(r,c.UTC);var a=0|e;t+=(e-a)*s.SECONDS_PER_DAY,d(a,t,this),r===c.UTC&&h(this)}var p=new i,_=[31,28,31,30,31,30,31,31,30,31,30,31],T=29,y=new u,R=/^(\d{4})$/,A=/^(\d{4})-(\d{2})$/,S=/^(\d{4})-?(\d{3})$/,N=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,M=/^(\d{4})-?(\d{2})-?(\d{2})$/,I=/([Z+\-])?(\d{2})?:?(\d{2})?$/,g=/^(\d{2})(\.\d+)?/.source+I.source,v=/^(\d{2}):?(\d{2})(\.\d+)?/.source+I.source,O=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+I.source;m.fromDate=function(e,t){var n=E(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return r(t)?(d(n[0],n[1],t),h(t),t):new m(n[0],n[1],c.UTC)},m.fromIso8601=function(e,t){e=e.replace(",",".");var n,a,i,u=e.split("T"),s=1,l=1,f=0,p=0,y=0,I=0,w=u[0],x=u[1];if(u=w.match(M),null!==u)n=+u[1],s=+u[2],l=+u[3];else if(u=w.match(A),null!==u)n=+u[1],s=+u[2];else if(u=w.match(R),null!==u)n=+u[1];else{var C;if(u=w.match(S),null!==u)n=+u[1],C=+u[2],i=o(n);else if(u=w.match(N),null!==u){n=+u[1];var P=+u[2],U=+u[3]||0,D=new Date(Date.UTC(n,0,4));C=7*P+U-D.getUTCDay()-3}a=new Date(Date.UTC(n,0,1)),a.setUTCDate(C),s=a.getUTCMonth()+1,l=a.getUTCDate()}i=o(n);var F;if(r(x)){u=x.match(O),null!==u?(f=+u[1],p=+u[2],y=+u[3],I=1e3*+(u[4]||0),F=5):(u=x.match(v),null!==u?(f=+u[1],p=+u[2],y=60*+(u[3]||0),F=4):(u=x.match(g),null!==u&&(f=+u[1],p=60*+(u[2]||0),F=3)));var L=u[F],B=+u[F+1],z=+(u[F+2]||0);switch(L){case"+":f-=B,p-=z;break;case"-":f+=B,p+=z;break;case"Z":break;default:p+=new Date(Date.UTC(n,s-1,l,f,p)).getTimezoneOffset()}}else p+=new Date(n,s-1,l).getTimezoneOffset();var b=60===y;for(b&&y--;p>=60;)p-=60,f++;for(;f>=24;)f-=24,l++;for(a=i&&2===s?T:_[s-1];l>a;)l-=a,s++,s>12&&(s-=12,n++),a=i&&2===s?T:_[s-1];for(;p<0;)p+=60,f--;for(;f<0;)f+=24,l--;for(;l<1;)s--,s<1&&(s+=12,n--),a=i&&2===s?T:_[s-1],l+=a;var q=E(n,s,l,f,p,y,I);return r(t)?(d(q[0],q[1],t),h(t)):t=new m(q[0],q[1],c.UTC),b&&m.addSeconds(t,1,t),t},m.now=function(e){return m.fromDate(new Date,e)};var w=new m(0,0,c.TAI);return m.toGregorianDate=function(e,t){var n=!1,a=f(e,w);r(a)||(m.addSeconds(e,-1,w),a=f(w,w),n=!0);var o=a.dayNumber,u=a.secondsOfDay;u>=43200&&(o+=1);var c=o+68569|0,l=4*c/146097|0;c=c-((146097*l+3)/4|0)|0;var h=4e3*(c+1)/1461001|0;c=c-(1461*h/4|0)+31|0;var d=80*c/2447|0,E=c-(2447*d/80|0)|0;c=d/11|0;var p=d+2-12*c|0,_=100*(l-49)+h+c|0,T=u/s.SECONDS_PER_HOUR|0,y=u-T*s.SECONDS_PER_HOUR,R=y/s.SECONDS_PER_MINUTE|0;y-=R*s.SECONDS_PER_MINUTE;var A=0|y,S=(y-A)/s.SECONDS_PER_MILLISECOND;return T+=12,T>23&&(T-=24),n&&(A+=1),r(t)?(t.year=_,t.month=p,t.day=E,t.hour=T,t.minute=R,t.second=A,t.millisecond=S,t.isLeapSecond=n,t):new i(_,p,E,T,R,A,S,n)},m.toDate=function(e){var t=m.toGregorianDate(e,p),n=t.second;return t.isLeapSecond&&(n-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,n,t.millisecond))},m.toIso8601=function(t,n){var a,i=m.toGregorianDate(t,i);return r(n)||0===i.millisecond?r(n)&&0!==n?(a=(.01*i.millisecond).toFixed(n).replace(".","").slice(0,n),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",i.year,i.month,i.day,i.hour,i.minute,i.second):(a=(.01*i.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",i.year,i.month,i.day,i.hour,i.minute,i.second,a))},m.clone=function(e,t){if(r(e))return r(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new m(e.dayNumber,e.secondsOfDay,c.TAI)},m.compare=function(e,t){var n=e.dayNumber-t.dayNumber;return 0!==n?n:e.secondsOfDay-t.secondsOfDay},m.equals=function(e,t){return e===t||r(e)&&r(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},m.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(m.secondsDifference(e,t))<=n},m.totalDays=function(e){return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},m.secondsDifference=function(e,t){var n=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return n+(e.secondsOfDay-t.secondsOfDay)},m.daysDifference=function(e,t){var n=e.dayNumber-t.dayNumber,r=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return n+r},m.computeTaiMinusUtc=function(e){y.julianDate=e;var n=m.leapSeconds,r=t(n,y,l);return r<0&&(r=~r,--r,r<0&&(r=0)),n[r].offset},m.addSeconds=function(e,t,n){return d(e.dayNumber,e.secondsOfDay+t,n)},m.addMinutes=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return d(e.dayNumber,r,n)},m.addHours=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return d(e.dayNumber,r,n)},m.addDays=function(e,t,n){var r=e.dayNumber+t;return d(r,e.secondsOfDay,n)},m.lessThan=function(e,t){return m.compare(e,t)<0},m.lessThanOrEquals=function(e,t){return m.compare(e,t)<=0},m.greaterThan=function(e,t){return m.compare(e,t)>0},m.greaterThanOrEquals=function(e,t){return m.compare(e,t)>=0},m.prototype.clone=function(e){return m.clone(this,e)},m.prototype.equals=function(e){return m.equals(this,e)},m.prototype.equalsEpsilon=function(e,t){return m.equalsEpsilon(this,e,t)},m.prototype.toString=function(){return m.toIso8601(this)},m.leapSeconds=[new u(new m(2441317,43210,c.TAI),10),new u(new m(2441499,43211,c.TAI),11),new u(new m(2441683,43212,c.TAI),12),new u(new m(2442048,43213,c.TAI),13),new u(new m(2442413,43214,c.TAI),14),new u(new m(2442778,43215,c.TAI),15),new u(new m(2443144,43216,c.TAI),16),new u(new m(2443509,43217,c.TAI),17),new u(new m(2443874,43218,c.TAI),18),new u(new m(2444239,43219,c.TAI),19),new u(new m(2444786,43220,c.TAI),20),new u(new m(2445151,43221,c.TAI),21),new u(new m(2445516,43222,c.TAI),22),new u(new m(2446247,43223,c.TAI),23),new u(new m(2447161,43224,c.TAI),24),new u(new m(2447892,43225,c.TAI),25),new u(new m(2448257,43226,c.TAI),26),new u(new m(2448804,43227,c.TAI),27),new u(new m(2449169,43228,c.TAI),28),new u(new m(2449534,43229,c.TAI),29),new u(new m(2450083,43230,c.TAI),30),new u(new m(2450630,43231,c.TAI),31),new u(new m(2451179,43232,c.TAI),32),new u(new m(2453736,43233,c.TAI),33),new u(new m(2454832,43234,c.TAI),34),new u(new m(2456109,43235,c.TAI),35),new u(new m(2457204,43236,c.TAI),36),new u(new m(2457754,43237,c.TAI),37)],m}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(n,r){if(null===n||"object"!=typeof n)return n;r=e(r,!1);var a=new n.constructor;for(var i in n)if(n.hasOwnProperty(i)){var o=n[i];r&&(o=t(o,r)),a[i]=o}return a}return t}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var n=e.split("\r\n"),r=0;r<n.length;++r){var a=n[r],i=a.indexOf(": ");if(i>0){var o=a.substring(0,i),u=a.substring(i+2);t[o]=u}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function n(e,n,r){this.statusCode=e,this.response=n,this.responseHeaders=r,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return n.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},n}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var n=r.exec(t);this.scheme=n[1],this.authority=n[2],this.path=n[3],this.query=n[4],this.fragment=n[5]}}function t(e){var t=unescape(e);return i.test(t)?t:e.toUpperCase()}function n(e,t,n,r){return(t||"")+n.toLowerCase()+(r||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var r=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,n).replace(a,t)),this.path&&(this.path=this.path.replace(a,t)),this.query&&(this.query=this.query.replace(a,t)),this.fragment&&(this.fragment=this.fragment.replace(a,t))};var a=/%[0-9a-z]{2}/gi,i=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var n=new e;return this.scheme?(n.scheme=this.scheme,n.authority=this.authority,n.path=this.path,n.query=this.query):(n.scheme=t.scheme,this.authority?(n.authority=this.authority,n.path=this.path,n.query=this.query):(n.authority=t.authority,""==this.path?(n.path=t.path,n.query=this.query||t.query):("/"==this.path.charAt(0)?(n.path=this.path,n.removeDotSegments()):(t.authority&&""==t.path?n.path="/"+this.path:n.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,n.removeDotSegments()),n.query=this.query))),n.fragment=this.fragment,n},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),n=[],r=""==t[0];r&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?n.pop():"."!=e&&n.push(e);"."!=e&&".."!=e||n.push(""),r&&n.unshift(""),this.path=n.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,n){"use strict";function r(n){var r=new e(n);r.normalize();var a=r.getAuthority();if(t(a)){if(a.indexOf("@")!==-1){var i=a.split("@");a=i[1]}if(a.indexOf(":")===-1){var o=r.getScheme();if(t(o)||(o=window.location.protocol,o=o.substring(0,o.length-1)),"http"===o)a+=":80";else{if("https"!==o)return;a+=":443"}}return a}}var a={},i={};return a.add=function(e,n){var r=e.toLowerCase()+":"+n;t(i[r])||(i[r]=!0)},a.remove=function(e,n){var r=e.toLowerCase()+":"+n;t(i[r])&&delete i[r]},a.contains=function(e){var n=r(e);return!(!t(n)||!t(i[n]))},a.clear=function(){i={}},a}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError","./TrustedServers"],function(e,t,n,r,a,i,o){"use strict";function u(n){n=t(n,t.EMPTY_OBJECT);var r=n.responseType,a=t(n.method,"GET"),i=n.data,o=n.headers,s=n.overrideMimeType;return e(n.url,function(t){var n=e.defer();return u.load(t,r,a,i,o,n,s),n.promise})}function s(e,t){var n=decodeURIComponent(t);return e?atob(n):n}function c(e,t){for(var n=s(e,t),r=new ArrayBuffer(n.length),a=new Uint8Array(r),i=0;i<n.length;i++)a[i]=n.charCodeAt(i);return r}function l(e,n){n=t(n,"");var r=e[1],a=!!e[2],i=e[3];switch(n){case"":case"text":return s(a,i);case"arraybuffer":return c(a,i);case"blob":var o=c(a,i);return new Blob([o],{type:r});case"document":var u=new DOMParser;return u.parseFromString(s(a,i),r);case"json":return JSON.parse(s(a,i))}}var h=/^data:(.*?)(;base64)?,(.*)$/;return u.load=function(e,t,r,u,s,c,f){var d=h.exec(e);if(null!==d)return void c.resolve(l(d,t));var E=new XMLHttpRequest;if(o.contains(e)&&(E.withCredentials=!0),n(f)&&n(E.overrideMimeType)&&E.overrideMimeType(f),E.open(r,e,!0),n(s))for(var m in s)s.hasOwnProperty(m)&&E.setRequestHeader(m,s[m]);n(t)&&(E.responseType=t),E.onload=function(){if(E.status<200||E.status>=300)return void c.reject(new a(E.status,E.response,E.getAllResponseHeaders()));var e=E.response,r=E.responseType;if(!n(e)||n(t)&&r!==t)if("json"===t&&"string"==typeof e)try{c.resolve(JSON.parse(e))}catch(e){c.reject(e)}else(""===r||"document"===r)&&n(E.responseXML)&&E.responseXML.hasChildNodes()?c.resolve(E.responseXML):""!==r&&"text"!==r||!n(E.responseText)?c.reject(new i("Invalid XMLHttpRequest response type.")):c.resolve(E.responseText);else c.resolve(e)},E.onerror=function(e){c.reject(new a)},E.send(u)},u.defaultLoad=u.load,u}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";function t(t,n){return e({url:t,headers:n})}return t}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,n,r){"use strict";function a(n,a){return t(a)?t(a.Accept)||(a=e(a),a.Accept=i.Accept):a=i,r(n,a).then(function(e){return JSON.parse(e)})}var i={Accept:"application/json,*/*;q=0.01"};return a}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,n,r,a,i,o,u,s,c,l,h){"use strict";function f(t){if(t=n(t,n.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=n(t.addNewLeapSeconds,!0),r(t.data))E(this,t.data);else if(r(t.url)){var a=this;this._downloadPromise=e(s(t.url),function(e){E(a,e)},function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else E(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function d(e,t){return o.compare(e.julianDate,t)}function E(e,n){if(!r(n.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!r(n.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var a=n.columnNames.indexOf("modifiedJulianDateUtc"),i=n.columnNames.indexOf("xPoleWanderRadians"),s=n.columnNames.indexOf("yPoleWanderRadians"),c=n.columnNames.indexOf("ut1MinusUtcSeconds"),f=n.columnNames.indexOf("xCelestialPoleOffsetRadians"),E=n.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=n.columnNames.indexOf("taiMinusUtcSeconds");if(a<0||i<0||s<0||c<0||f<0||E<0||m<0)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var p=e._samples=n.samples,_=e._dates=[];e._dateColumn=a,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=f,e._yCelestialPoleOffsetRadiansColumn=E,e._taiMinusUtcSecondsColumn=m,e._columnCount=n.columnNames.length,e._lastIndex=void 0;for(var T,y=e._addNewLeapSeconds,R=0,A=p.length;R<A;R+=e._columnCount){var S=p[R+a],N=p[R+m],M=S+l.MODIFIED_JULIAN_DATE_DIFFERENCE,I=new o(M,N,h.TAI);if(_.push(I),y){if(N!==T&&r(T)){var g=o.leapSeconds,v=t(g,I,d);if(v<0){var O=new u(I,N);g.splice(~v,0,O)}}T=N}}}function m(e,t,n,r,a){var i=n*r;a.xPoleWander=t[i+e._xPoleWanderRadiansColumn],a.yPoleWander=t[i+e._yPoleWanderRadiansColumn],a.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],a.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],a.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function p(e,t,n){return t+e*(n-t)}function _(e,t,n,r,a,i,u){var s=e._columnCount;if(i>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[a],l=t[i];if(c.equals(l)||r.equals(c))return m(e,n,a,s,u),u;if(r.equals(l))return m(e,n,i,s,u),u;var h=o.secondsDifference(r,c)/o.secondsDifference(l,c),f=a*s,d=i*s,E=n[f+e._ut1MinusUtcSecondsColumn],_=n[d+e._ut1MinusUtcSecondsColumn],T=_-E;if(T>.5||T<-.5){var y=n[f+e._taiMinusUtcSecondsColumn],R=n[d+e._taiMinusUtcSecondsColumn];y!==R&&(l.equals(r)?E=_:_-=R-y)}return u.xPoleWander=p(h,n[f+e._xPoleWanderRadiansColumn],n[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=p(h,n[f+e._yPoleWanderRadiansColumn],n[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=p(h,n[f+e._xCelestialPoleOffsetRadiansColumn],n[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=p(h,n[f+e._yCelestialPoleOffsetRadiansColumn],n[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=p(h,E,_),u}return f.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return r(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new a(0,0,0,0,0),t}}),f.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},f.prototype.compute=function(e,n){if(r(this._samples)){if(r(n)||(n=new a(0,0,0,0,0)),0===this._samples.length)return n.xPoleWander=0,n.yPoleWander=0,n.xPoleOffset=0,n.yPoleOffset=0,n.ut1MinusUtc=0,n;var i=this._dates,u=this._lastIndex,s=0,l=0;if(r(u)){var h=i[u],f=i[u+1],d=o.lessThanOrEquals(h,e),E=!r(f),m=E||o.greaterThanOrEquals(f,e);if(d&&m)return s=u,!E&&f.equals(e)&&++s,l=s+1,_(this,i,this._samples,e,s,l,n),n}var p=t(i,e,o.compare,this._dateColumn);return p>=0?(p<i.length-1&&i[p+1].equals(e)&&++p,s=p,l=p):(l=~p,s=l-1,s<0&&(s=0)),this._lastIndex=s,_(this,i,this._samples,e,s,l,n),n}if(r(this._dataError))throw new c(this._dataError)},f}),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";function a(n,r){r=t(r,document.location.href);var a=new e(r),i=new e(n);return i.resolve(a).toString()}return a}),define("Core/joinUrls",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";function a(r,a,i){i=t(i,!0),r instanceof e||(r=new e(r)),a instanceof e||(a=new e(a)),n(a.authority)&&!n(a.scheme)&&("undefined"!=typeof document&&n(document.location)&&n(document.location.href)?a.scheme=new e(document.location.href).scheme:a.scheme=r.scheme);var o=r;a.isAbsolute()&&(o=a);var u="";n(o.scheme)&&(u+=o.scheme+":"),n(o.authority)&&(u+="//"+o.authority,""!==o.path&&"/"!==o.path&&(u=u.replace(/\/?$/,"/"),o.path=o.path.replace(/^\/?/g,""))),u+=o===r?i?r.path.replace(/\/?$/,"/")+a.path.replace(/^\/?/g,""):r.path+a.path:a.path;var s=n(r.query),c=n(a.query);s&&c?u+="?"+r.query+"&"+a.query:s&&!c?u+="?"+r.query:!s&&c&&(u+="?"+a.query);var l=n(a.fragment);return n(r.fragment)&&!l?u+="#"+r.fragment:l&&(u+="#"+a.fragment),u}return a}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","./getAbsoluteUri","./joinUrls","require"],function(e,t,n,r,a,i){"use strict";function o(){for(var e=document.getElementsByTagName("script"),t=0,n=e.length;t<n;++t){var r=e[t].getAttribute("src"),a=E.exec(r);if(null!==a)return a[1]}}function u(){if(t(h))return h;var n;return n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:o(),h=new e(r(n))}function s(e){return i.toUrl("../"+e)}function c(e){return a(u(),e)}function l(e){t(f)||(f=t(i.toUrl)?s:c),t(d)||(d=document.createElement("a"));var n=f(e);return d.href=n,d.href=d.href,d.href}var h,f,d,E=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return l._cesiumScriptRegex=E,l.setBaseUrl=function(t){h=new e(t).resolve(new e(document.location.href))},l}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,n){this.x=e,this.y=t,this.s=n}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,n,r,a,i,o,u){"use strict";function s(e){e=n(e,n.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=n(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=n(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=n(e.stepSizeDays,1),this._samplesPerXysFile=n(e.samplesPerXysFile,1e3),this._totalSamples=n(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,r=this._denominators=new Array(t+1),a=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t),s=0;s<=t;++s){r[s]=o,a[s]=s*this._stepSizeDays;for(var c=0;c<=t;++c)c!==s&&(r[s]*=s-c);r[s]=1/r[s]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,n){var r=h;return r.dayNumber=t,r.secondsOfDay=n,i.daysDifference(r,e._sampleZeroDateTT)}function l(n,a){if(n._chunkDownloadsInProgress[a])return n._chunkDownloadsInProgress[a];var i=e.defer();n._chunkDownloadsInProgress[a]=i;var u,s=n._xysFileUrlTemplate;return u=r(s)?s.replace("{0}",a):t("Assets/IAU2006_XYS/IAU2006_XYS_"+a+".json"),e(o(u),function(e){n._chunkDownloadsInProgress[a]=!1;for(var t=n._samples,r=e.samples,o=a*n._samplesPerXysFile*3,u=0,s=r.length;u<s;++u)t[o+u]=r[u];i.resolve()}),i.promise}var h=new i(0,0,u.TAI);return s.prototype.preload=function(t,n,r,a){var i=c(this,t,n),o=c(this,r,a),u=i/this._stepSizeDays-this._interpolationOrder/2|0;u<0&&(u=0);var s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var h=u/this._samplesPerXysFile|0,f=s/this._samplesPerXysFile|0,d=[],E=h;E<=f;++E)d.push(l(this,E));return e.all(d)},s.prototype.computeXysRadians=function(e,t,n){var i=c(this,e,t);if(!(i<0)){var o=i/this._stepSizeDays|0;if(!(o>=this._totalSamples)){var u=this._interpolationOrder,s=o-(u/2|0);s<0&&(s=0);var h=s+u;h>=this._totalSamples&&(h=this._totalSamples-1,s=h-u,s<0&&(s=0));var f=!1,d=this._samples;if(r(d[3*s])||(l(this,s/this._samplesPerXysFile|0),f=!0),r(d[3*h])||(l(this,h/this._samplesPerXysFile|0),f=!0),!f){r(n)?(n.x=0,n.y=0,n.s=0):n=new a(0,0,0);var E,m,p=i-s*this._stepSizeDays,_=this._work,T=this._denominators,y=this._coef,R=this._xTable;for(E=0;E<=u;++E)_[E]=p-R[E];for(E=0;E<=u;++E){for(y[E]=1,m=0;m<=u;++m)m!==E&&(y[E]*=_[m]);y[E]*=T[E];var A=3*(s+E);n.x+=y[E]*d[A++],n.y+=y[E]*d[A++],n.s+=y[E]*d[A]}return n}}}},s}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){if(a.supportsFullscreen())return document[r.fullscreenElement]}},changeEventName:{get:function(){if(a.supportsFullscreen())return r.fullscreenchange}},errorEventName:{get:function(){
if(a.supportsFullscreen())return r.fullscreenerror}},enabled:{get:function(){if(a.supportsFullscreen())return document[r.fullscreenEnabled]}},fullscreen:{get:function(){if(a.supportsFullscreen())return null!==a.element}}}),a.supportsFullscreen=function(){if(e(n))return n;n=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;o<u;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof t[a]?(r.requestFullscreen=a,n=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(r.requestFullscreen=a,n=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?r.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(r.exitFullscreen=a)),a=s+"FullscreenEnabled",void 0!==document[a]?r.fullscreenEnabled=a:(a=s+"FullScreenEnabled",void 0!==document[a]&&(r.fullscreenEnabled=a)),a=s+"FullscreenElement",void 0!==document[a]?r.fullscreenElement=a:(a=s+"FullScreenElement",void 0!==document[a]&&(r.fullscreenElement=a)),a=s+"fullscreenchange",void 0!==document["on"+a]&&("ms"===s&&(a="MSFullscreenChange"),r.fullscreenchange=a),a=s+"fullscreenerror",void 0!==document["on"+a]&&("ms"===s&&(a="MSFullscreenError"),r.fullscreenerror=a)}return n},a.requestFullscreen=function(e,t){a.supportsFullscreen()&&e[r.requestFullscreen]({vrDisplay:t})},a.exitFullscreen=function(){a.supportsFullscreen()&&document[r.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,n){"use strict";function r(e){for(var t=e.split("."),n=0,r=t.length;n<r;++n)t[n]=parseInt(t[n],10);return t}function a(){if(!t(A)&&(A=!1,!f())){var e=/ Chrome\/([\.0-9]+)/.exec(R.userAgent);null!==e&&(A=!0,S=r(e[1]))}return A}function i(){return a()&&S}function o(){if(!t(N)&&(N=!1,!a()&&!f()&&/ Safari\/[\.0-9]+/.test(R.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(R.userAgent);null!==e&&(N=!0,M=r(e[1]))}return N}function u(){return o()&&M}function s(){if(!t(I)){I=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(R.userAgent);null!==e&&(I=!0,g=r(e[1]),g.isNightly=!!e[2])}return I}function c(){return s()&&g}function l(){if(!t(v)){v=!1;var e;"Microsoft Internet Explorer"===R.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(R.userAgent),null!==e&&(v=!0,O=r(e[1]))):"Netscape"===R.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(R.userAgent),null!==e&&(v=!0,O=r(e[1])))}return v}function h(){return l()&&O}function f(){if(!t(w)){w=!1;var e=/ Edge\/([\.0-9]+)/.exec(R.userAgent);null!==e&&(w=!0,x=r(e[1]))}return w}function d(){return f()&&x}function E(){if(!t(C)){C=!1;var e=/Firefox\/([\.0-9]+)/.exec(R.userAgent);null!==e&&(C=!0,P=r(e[1]))}return C}function m(){return t(U)||(U=/Windows/i.test(R.appVersion)),U}function p(){return E()&&P}function _(){return t(D)||(D="undefined"!=typeof PointerEvent&&(!t(R.pointerEnabled)||R.pointerEnabled)),D}function T(){if(!t(L)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var n=e.style.imageRendering;L=t(n)&&""!==n,L&&(F=n)}return L}function y(){return T()?F:void 0}var R;R="undefined"!=typeof navigator?navigator:{};var A,S,N,M,I,g,v,O,w,x,C,P,U,D,F,L,B={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:h,isEdge:f,edgeVersion:d,isFirefox:E,firefoxVersion:p,isWindows:m,hardwareConcurrency:e(R.hardwareConcurrency,3),supportsPointerEvents:_,supportsImageRenderingPixelated:T,imageRenderingValue:y};return B.supportsFullscreen=function(){return n.supportsFullscreen()},B.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},B.supportsWebWorkers=function(){return"undefined"!=typeof Worker},B}),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,n,r){"use strict";function a(t,n,r){this.heading=e(t,0),this.pitch=e(n,0),this.roll=e(r,0)}return a.fromQuaternion=function(e,n){t(n)||(n=new a);var r=2*(e.w*e.y-e.z*e.x),i=1-2*(e.x*e.x+e.y*e.y),o=2*(e.w*e.x+e.y*e.z),u=1-2*(e.y*e.y+e.z*e.z),s=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(s,u),n.roll=Math.atan2(o,i),n.pitch=-Math.asin(r),n},a.fromDegrees=function(e,n,i,o){return t(o)||(o=new a),o.heading=e*r.RADIANS_PER_DEGREE,o.pitch=n*r.RADIANS_PER_DEGREE,o.roll=i*r.RADIANS_PER_DEGREE,o},a.clone=function(e,n){if(t(e))return t(n)?(n.heading=e.heading,n.pitch=e.pitch,n.roll=e.roll,n):new a(e.heading,e.pitch,e.roll)},a.equals=function(e,n){return e===n||t(e)&&t(n)&&e.heading===n.heading&&e.pitch===n.pitch&&e.roll===n.roll},a.equalsEpsilon=function(e,n,a,i){return e===n||t(e)&&t(n)&&r.equalsEpsilon(e.heading,n.heading,a,i)&&r.equalsEpsilon(e.pitch,n.pitch,a,i)&&r.equalsEpsilon(e.roll,n.roll,a,i)},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,n){return a.equalsEpsilon(this,e,t,n)},a.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},a}),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./deprecationWarning","./FeatureDetection","./freezeObject","./HeadingPitchRoll","./Math","./Matrix3"],function(e,t,n,r,a,i,o,u,s,c){"use strict";function l(e,t,r,a){this.x=n(e,0),this.y=n(t,0),this.z=n(r,0),this.w=n(a,0)}var h=new e;l.fromAxisAngle=function(t,n,a){var i=n/2,o=Math.sin(i);h=e.normalize(t,h);var u=h.x*o,s=h.y*o,c=h.z*o,f=Math.cos(i);return r(a)?(a.x=u,a.y=s,a.z=c,a.w=f,a):new l(u,s,c,f)};var f=[1,2,0],d=new Array(3);l.fromRotationMatrix=function(e,t){var n,a,i,o,u,s=e[c.COLUMN0ROW0],h=e[c.COLUMN1ROW1],E=e[c.COLUMN2ROW2],m=s+h+E;if(m>0)n=Math.sqrt(m+1),u=.5*n,n=.5/n,a=(e[c.COLUMN1ROW2]-e[c.COLUMN2ROW1])*n,i=(e[c.COLUMN2ROW0]-e[c.COLUMN0ROW2])*n,o=(e[c.COLUMN0ROW1]-e[c.COLUMN1ROW0])*n;else{var p=f,_=0;h>s&&(_=1),E>s&&E>h&&(_=2);var T=p[_],y=p[T];n=Math.sqrt(e[c.getElementIndex(_,_)]-e[c.getElementIndex(T,T)]-e[c.getElementIndex(y,y)]+1);var R=d;R[_]=.5*n,n=.5/n,u=(e[c.getElementIndex(y,T)]-e[c.getElementIndex(T,y)])*n,R[T]=(e[c.getElementIndex(T,_)]+e[c.getElementIndex(_,T)])*n,R[y]=(e[c.getElementIndex(y,_)]+e[c.getElementIndex(_,y)])*n,a=-R[0],i=-R[1],o=-R[2]}return r(t)?(t.x=a,t.y=i,t.z=o,t.w=u,t):new l(a,i,o,u)};var E=new l,m=new l,p=new l,_=new l;l.fromHeadingPitchRoll=function(t,n,r,i){var o;return t instanceof u?(o=t,i=n):(a("Quaternion.fromHeadingPitchRoll(heading, pitch, roll,result)","The method was deprecated in Cesium 1.32 and will be removed in version 1.33. Use Quaternion.fromHeadingPitchRoll(hpr,result) where hpr is a HeadingPitchRoll"),o=new u(t,n,r)),_=l.fromAxisAngle(e.UNIT_X,o.roll,E),p=l.fromAxisAngle(e.UNIT_Y,-o.pitch,i),i=l.multiply(p,_,p),m=l.fromAxisAngle(e.UNIT_Z,-o.heading,E),l.multiply(m,i,i)};var T=new e,y=new e,R=new l,A=new l,S=new l;l.packedLength=4,l.pack=function(e,t,r){return r=n(r,0),t[r++]=e.x,t[r++]=e.y,t[r++]=e.z,t[r]=e.w,t},l.unpack=function(e,t,a){return t=n(t,0),r(a)||(a=new l),a.x=e[t],a.y=e[t+1],a.z=e[t+2],a.w=e[t+3],a},l.packedInterpolationLength=3,l.convertPackedArrayForInterpolation=function(e,t,n,r){l.unpack(e,4*n,S),l.conjugate(S,S);for(var a=0,i=n-t+1;a<i;a++){var o=3*a;l.unpack(e,4*(t+a),R),l.multiply(R,S,R),R.w<0&&l.negate(R,R),l.computeAxis(R,T);var u=l.computeAngle(R);r[o]=T.x*u,r[o+1]=T.y*u,r[o+2]=T.z*u}},l.unpackInterpolationResult=function(t,n,a,i,o){r(o)||(o=new l),e.fromArray(t,0,y);var u=e.magnitude(y);return l.unpack(n,4*i,A),0===u?l.clone(l.IDENTITY,R):l.fromAxisAngle(y,u,R),l.multiply(R,A,o)},l.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new l(e.x,e.y,e.z,e.w)},l.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},l.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},l.magnitude=function(e){return Math.sqrt(l.magnitudeSquared(e))},l.normalize=function(e,t){var n=1/l.magnitude(e),r=e.x*n,a=e.y*n,i=e.z*n,o=e.w*n;return t.x=r,t.y=a,t.z=i,t.w=o,t},l.inverse=function(e,t){var n=l.magnitudeSquared(e);return t=l.conjugate(e,t),l.multiplyByScalar(t,1/n,t)},l.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},l.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},l.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},l.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},l.multiply=function(e,t,n){var r=e.x,a=e.y,i=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,h=o*u+r*l+a*c-i*s,f=o*s-r*c+a*l+i*u,d=o*c+r*s-a*u+i*l,E=o*l-r*u-a*s-i*c;return n.x=h,n.y=f,n.z=d,n.w=E,n},l.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},l.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},l.computeAxis=function(e,t){var n=e.w;if(Math.abs(n-1)<s.EPSILON6)return t.x=t.y=t.z=0,t;var r=1/Math.sqrt(1-n*n);return t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t},l.computeAngle=function(e){return Math.abs(e.w-1)<s.EPSILON6?0:2*Math.acos(e.w)};var N=new l;l.lerp=function(e,t,n,r){return N=l.multiplyByScalar(t,n,N),r=l.multiplyByScalar(e,1-n,r),l.add(N,r,r)};var M=new l,I=new l,g=new l;l.slerp=function(e,t,n,r){var a=l.dot(e,t),i=t;if(a<0&&(a=-a,i=M=l.negate(t,M)),1-a<s.EPSILON6)return l.lerp(e,i,n,r);var o=Math.acos(a);return I=l.multiplyByScalar(e,Math.sin((1-n)*o),I),g=l.multiplyByScalar(i,Math.sin(n*o),g),r=l.add(I,g,r),l.multiplyByScalar(r,1/Math.sin(o),r)},l.log=function(t,n){var r=s.acosClamped(t.w),a=0;return 0!==r&&(a=r/Math.sin(r)),e.multiplyByScalar(t,a,n)},l.exp=function(t,n){var r=e.magnitude(t),a=0;return 0!==r&&(a=Math.sin(r)/r),n.x=t.x*a,n.y=t.y*a,n.z=t.z*a,n.w=Math.cos(r),n};var v=new e,O=new e,w=new l,x=new l;l.computeInnerQuadrangle=function(t,n,r,a){var i=l.conjugate(n,w);l.multiply(i,r,x);var o=l.log(x,v);l.multiply(i,t,x);var u=l.log(x,O);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),l.exp(o,w),l.multiply(n,w,a)},l.squad=function(e,t,n,r,a,i){var o=l.slerp(e,t,a,w),u=l.slerp(n,r,a,x);return l.slerp(o,u,2*a*(1-a),i)};for(var C=new l,P=1.9011074535173003,U=i.supportsTypedArrays()?new Float32Array(8):[],D=i.supportsTypedArrays()?new Float32Array(8):[],F=i.supportsTypedArrays()?new Float32Array(8):[],L=i.supportsTypedArrays()?new Float32Array(8):[],B=0;B<7;++B){var z=B+1,b=2*z+1;U[B]=1/(z*b),D[B]=z/b}return U[7]=P/136,D[7]=8*P/17,l.fastSlerp=function(e,t,n,r){var a,i=l.dot(e,t);i>=0?a=1:(a=-1,i=-i);for(var o=i-1,u=1-n,s=n*n,c=u*u,h=7;h>=0;--h)F[h]=(U[h]*s-D[h])*o,L[h]=(U[h]*c-D[h])*o;var f=a*n*(1+F[0]*(1+F[1]*(1+F[2]*(1+F[3]*(1+F[4]*(1+F[5]*(1+F[6]*(1+F[7])))))))),d=u*(1+L[0]*(1+L[1]*(1+L[2]*(1+L[3]*(1+L[4]*(1+L[5]*(1+L[6]*(1+L[7])))))))),E=l.multiplyByScalar(e,d,C);return l.multiplyByScalar(t,f,r),l.add(E,r,r)},l.fastSquad=function(e,t,n,r,a,i){var o=l.fastSlerp(e,t,a,w),u=l.fastSlerp(n,r,a,x);return l.fastSlerp(o,u,2*a*(1-a),i)},l.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},l.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},l.ZERO=o(new l(0,0,0,0)),l.IDENTITY=o(new l(0,0,0,1)),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},l}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,n,r,a,i,o,u,s,c,l,h,f,d,E,m,p,_,T,y,R){"use strict";var A={},S={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},N={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},M={},I={east:new n,north:new n,up:new n,west:new n,south:new n,down:new n},g=new n,v=new n,O=new n;A.localFrameToFixedFrameGenerator=function(e,t){if(!S.hasOwnProperty(e)||!S[e].hasOwnProperty(t))throw new c("firstAxis and secondAxis must be east, north, up, west, south or down.");var r,a=S[e][t],i=e+t;return u(M[i])?r=M[i]:(r=function(r,i,s){if(u(s)||(s=new T),p.equalsEpsilon(r.x,0,p.EPSILON14)&&p.equalsEpsilon(r.y,0,p.EPSILON14)){var c=p.sign(r.z);n.unpack(N[e],0,g),"east"!==e&&"west"!==e&&n.multiplyByScalar(g,c,g),n.unpack(N[t],0,v),"east"!==t&&"west"!==t&&n.multiplyByScalar(v,c,v),n.unpack(N[a],0,O),"east"!==a&&"west"!==a&&n.multiplyByScalar(O,c,O)}else{i=o(i,f.WGS84),i.geodeticSurfaceNormal(r,I.up);var l=I.up,h=I.east;h.x=-r.y,h.y=r.x,h.z=0,n.normalize(h,I.east),n.cross(l,h,I.north),n.multiplyByScalar(I.up,-1,I.down),n.multiplyByScalar(I.east,-1,I.west),n.multiplyByScalar(I.north,-1,I.south),g=I[e],v=I[t],O=I[a]}return s[0]=g.x,s[1]=g.y,s[2]=g.z,s[3]=0,s[4]=v.x,s[5]=v.y,s[6]=v.z,s[7]=0,s[8]=O.x,s[9]=O.y,s[10]=O.z,s[11]=0,s[12]=r.x,s[13]=r.y,s[14]=r.z,s[15]=1,s},M[i]=r),r},A.eastNorthUpToFixedFrame=A.localFrameToFixedFrameGenerator("east","north"),A.northEastDownToFixedFrame=A.localFrameToFixedFrameGenerator("north","east"),A.northUpEastToFixedFrame=A.localFrameToFixedFrameGenerator("north","up"),A.northWestUpToFixedFrame=A.localFrameToFixedFrameGenerator("north","west");var w=new y,x=new n(1,1,1),C=new T;A.headingPitchRollToFixedFrame=function(e,t,r,a,i){a instanceof T&&(i=a,a=void 0,s("Transforms.headingPitchRollToFixedFrame(origin, headingPitchRoll, ellipsoid, result)","The method was deprecated in Cesium 1.31 and will be removed in version 1.33. Transforms.headingPitchRollToFixedFrame(origin, headingPitchRoll, ellipsoid, fixedFrameTransform, result) where fixedFrameTransform is a a 4x4 transformation matrix (see Transforms.localFrameToFixedFrameGenerator)")),a=o(a,A.eastNorthUpToFixedFrame);var u=y.fromHeadingPitchRoll(t,w),c=T.fromTranslationQuaternionRotationScale(n.ZERO,u,x,C);return i=a(e,r,i),T.multiply(i,c,i)};var P=new T,U=new _;A.headingPitchRollQuaternion=function(e,t,n,r,a){r instanceof y&&(a=r,r=void 0,s("Transforms.headingPitchRollQuaternion(origin, headingPitchRoll, ellipsoid, result)","The method was deprecated in Cesium 1.31 and will be removed in version 1.33. Transforms.headingPitchRollQuaternion(origin, headingPitchRoll, ellipsoid, fixedFrameTransform, result) where fixedFrameTransform is a a 4x4 transformation matrix (see Transforms.localFrameToFixedFrameGenerator)"));var i=A.headingPitchRollToFixedFrame(e,t,n,r,P),o=T.getRotation(i,U);return y.fromRotationMatrix(o,a)};var D=24110.54841,F=8640184.812866,L=.093104,B=-62e-7,z=1.1772758384668e-19,b=72921158553e-15,q=p.TWO_PI/86400,G=new m;A.computeTemeToPseudoFixedMatrix=function(e,t){G=m.addSeconds(e,-m.computeTaiMinusUtc(e),G);var n,r=G.dayNumber,a=G.secondsOfDay,i=r-2451545;n=a>=43200?(i+.5)/R.DAYS_PER_JULIAN_CENTURY:(i-.5)/R.DAYS_PER_JULIAN_CENTURY;var o=D+n*(F+n*(L+n*B)),s=o*q%p.TWO_PI,c=b+z*(r-2451545.5),l=(a+.5*R.SECONDS_PER_DAY)%R.SECONDS_PER_DAY,h=s+c*l,f=Math.cos(h),d=Math.sin(h);return u(t)?(t[0]=f,t[1]=-d,t[2]=0,t[3]=d,t[4]=f,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new _(f,d,0,-d,f,0,0,0,1)},A.iau2006XysData=new d,A.earthOrientationParameters=l.NONE;var W=32.184,X=2451545;A.preloadIcrfFixed=function(t){var n=t.start.dayNumber,r=t.start.secondsOfDay+W,a=t.stop.dayNumber,i=t.stop.secondsOfDay+W,o=A.iau2006XysData.preload(n,r,a,i),u=A.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},A.computeIcrfToFixedMatrix=function(e,t){u(t)||(t=new _);var n=A.computeFixedToIcrfMatrix(e,t);if(u(n))return _.transpose(n,t)};var V=new E(0,0,0),H=new h(0,0,0,0,0,0),Y=new _,k=new _;A.computeFixedToIcrfMatrix=function(e,t){u(t)||(t=new _);var n=A.earthOrientationParameters.compute(e,H);if(u(n)){var r=e.dayNumber,a=e.secondsOfDay+W,i=A.iau2006XysData.computeXysRadians(r,a,V);if(u(i)){var o=i.x+n.xPoleOffset,s=i.y+n.yPoleOffset,c=1/(1+Math.sqrt(1-o*o-s*s)),l=Y;l[0]=1-c*o*o,l[3]=-c*o*s,l[6]=o,l[1]=-c*o*s,l[4]=1-c*s*s,l[7]=s,l[2]=-o,l[5]=-s,l[8]=1-c*(o*o+s*s);var h=_.fromRotationZ(-i.s,k),f=_.multiply(l,h,Y),d=e.dayNumber,E=e.secondsOfDay-m.computeTaiMinusUtc(e)+n.ut1MinusUtc,T=d-2451545,y=E/R.SECONDS_PER_DAY,S=.779057273264+y+.00273781191135448*(T+y);S=S%1*p.TWO_PI;var N=_.fromRotationZ(S,k),M=_.multiply(f,N,Y),I=Math.cos(n.xPoleWander),g=Math.cos(n.yPoleWander),v=Math.sin(n.xPoleWander),O=Math.sin(n.yPoleWander),w=r-X+a/R.SECONDS_PER_DAY;w/=36525;var x=-47e-6*w*p.RADIANS_PER_DEGREE/3600,C=Math.cos(x),P=Math.sin(x),U=k;return U[0]=I*C,U[1]=I*P,U[2]=v,U[3]=-g*P+O*v*C,U[4]=g*C+O*v*P,U[5]=-O*I,U[6]=-O*P-g*v*C,U[7]=O*C-g*v*P,U[8]=g*I,_.multiply(M,U,t)}}};var Z=new r;A.pointToWindowCoordinates=function(e,t,n,r){return r=A.pointToGLWindowCoordinates(e,t,n,r),r.y=2*t[5]-r.y,r},A.pointToGLWindowCoordinates=function(e,n,a,i){u(i)||(i=new t);var o=Z;return T.multiplyByVector(e,r.fromElements(a.x,a.y,a.z,1,o),o),r.multiplyByScalar(o,1/o.w,o),T.multiplyByVector(n,o,o),t.fromCartesian4(o,i)};var j=new n,K=new n,Q=new n;A.rotationMatrixFromPositionVelocity=function(e,t,r,a){var i=o(r,f.WGS84).geodeticSurfaceNormal(e,j),s=n.cross(t,i,K);n.equalsEpsilon(s,n.ZERO,p.EPSILON6)&&(s=n.clone(n.UNIT_X,s));var c=n.cross(s,t,Q);return n.cross(t,c,s),n.negate(s,s),u(a)||(a=new _),a[0]=t.x,a[1]=t.y,a[2]=t.z,a[3]=s.x,a[4]=s.y,a[5]=s.z,a[6]=c.x,a[7]=c.y,a[8]=c.z,a};var J=new a,$=new n,ee=new n,te=new r,ne=new r,re=new r,ae=new r,ie=new r,oe=new T,ue=new T;A.basisTo2D=function(e,t,a){var i=e.ellipsoid,o=T.getColumn(t,3,te),u=i.cartesianToCartographic(o,J),s=A.eastNorthUpToFixedFrame(o,i,oe),c=T.inverseTransformation(s,ue),l=e.project(u,$),h=ne;h.x=l.z,h.y=l.x,h.z=l.y,h.w=1;var f=T.getColumn(t,0,ee),d=n.magnitude(f),E=T.multiplyByVector(c,f,re);r.fromElements(E.z,E.x,E.y,0,E);var m=T.getColumn(t,1,ee),p=n.magnitude(m),_=T.multiplyByVector(c,m,ae);r.fromElements(_.z,_.x,_.y,0,_);var y=T.getColumn(t,2,ee),R=n.magnitude(y),S=ie;return n.cross(E,_,S),n.normalize(S,S),n.cross(_,S,E),n.normalize(E,E),n.cross(S,E,_),n.normalize(_,_),n.multiplyByScalar(E,d,E),n.multiplyByScalar(_,p,_),n.multiplyByScalar(S,R,S),T.setColumn(a,0,E,a),T.setColumn(a,1,_,a),T.setColumn(a,2,S,a),T.setColumn(a,3,h,a),a};var se=new T(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1);return A.wgs84To2DModelMatrix=function(e,t,n){var r=e.ellipsoid,a=A.eastNorthUpToFixedFrame(t,r,oe),i=T.inverseTransformation(a,ue),o=r.cartesianToCartographic(t,J),u=e.project(o,$),s=ne;s.x=u.z,s.y=u.x,s.z=u.y,s.w=1;var c=T.fromTranslation(s,oe);return T.multiply(se,i,n),T.multiply(c,n,n),n},A}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,n,r,a,i,o,u,s,c,l,h,f,d){"use strict";function E(e,t){t=a(t,s.WGS84),e=t.scaleToGeodeticSurface(e);var r=d.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=n.fromCartesian4(l.getColumn(r,0,m)),this._yAxis=n.fromCartesian4(l.getColumn(r,1,m));var i=n.fromCartesian4(l.getColumn(r,2,m));this._plane=h.fromPointNormal(e,i)}var m=new r;o(E.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var p=new e;E.fromPoints=function(t,n){var r=e.fromPoints(t,p);return new E(r.center,n)};var _=new f,T=new n;E.prototype.projectPointOntoPlane=function(e,r){var a=_;a.origin=e,n.normalize(e,a.direction);var o=c.rayPlane(a,this._plane,T);if(i(o)||(n.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,T)),i(o)){var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return i(r)?(r.x=s,r.y=l,r):new t(s,l)}},E.prototype.projectPointsOntoPlane=function(e,t){i(t)||(t=[]);for(var n=0,r=e.length,a=0;a<r;a++){var o=this.projectPointOntoPlane(e[a],t[n]);i(o)&&(t[n]=o,n++)}return t.length=n,t},E.prototype.projectPointToNearestOnPlane=function(e,r){i(r)||(r=new t);var a=_;a.origin=e,n.clone(this._plane.normal,a.direction);var o=c.rayPlane(a,this._plane,T);i(o)||(n.negate(a.direction,a.direction),o=c.rayPlane(a,this._plane,T));var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return r.x=s,r.y=l,r},E.prototype.projectPointsToNearestOnPlane=function(e,t){i(t)||(t=[]);var n=e.length;t.length=n;for(var r=0;r<n;r++)t[r]=this.projectPointToNearestOnPlane(e[r],t[r]);return t};var y=new n;return E.prototype.projectPointsOntoEllipsoid=function(e,t){var r=e.length;i(t)?t.length=r:t=new Array(r);for(var a=this._ellipsoid,o=this._origin,u=this._xAxis,s=this._yAxis,c=y,l=0;l<r;++l){var h=e[l];n.multiplyByScalar(u,h.x,c),i(t[l])||(t[l]=new n);var f=n.add(o,c,t[l]);n.multiplyByScalar(s,h.y,c),n.add(f,c,f),a.scaleToGeocentricSurface(f,f)}return t},E}),define("Core/OrientedBoundingBox",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Intersect","./Interval","./Math","./Matrix3","./Plane","./Rectangle"],function(e,t,n,r,a,i,o,u,s,c,l,h,f,d,E){"use strict";function m(e,t){this.center=n.clone(a(e,n.ZERO)),this.halfAxes=f.clone(a(t,f.ZERO))}function p(e,t,r,a,o,u,s,c){i(c)||(c=new m);var l=c.halfAxes;f.setColumn(l,0,e.xAxis,l),f.setColumn(l,1,e.yAxis,l),f.setColumn(l,2,e.zAxis,l);var h=I;h.x=(t+r)/2,h.y=(a+o)/2,h.z=(u+s)/2;var d=g;d.x=(r-t)/2,d.y=(o-a)/2,d.z=(s-u)/2;var E=c.center;return h=f.multiplyByVector(l,h,h),n.add(e.origin,h,E),f.multiplyByScale(l,d,l),c}var _=new n,T=new n,y=new n,R=new n,A=new n,S=new n,N=new f,M={unitary:new f,diagonal:new f};m.fromPoints=function(e,t){if(i(t)||(t=new m),!i(e)||0===e.length)return t.halfAxes=f.ZERO,t.center=n.ZERO,t;var r,a=e.length,o=n.clone(e[0],_);for(r=1;r<a;r++)n.add(o,e[r],o);var u=1/a;n.multiplyByScalar(o,u,o);var s,c=0,l=0,h=0,d=0,E=0,p=0;for(r=0;r<a;r++)s=n.subtract(e[r],o,T),c+=s.x*s.x,l+=s.x*s.y,h+=s.x*s.z,d+=s.y*s.y,E+=s.y*s.z,p+=s.z*s.z;c*=u,l*=u,h*=u,d*=u,E*=u,p*=u;var I=N;I[0]=c,I[1]=l,I[2]=h,I[3]=l,I[4]=d,I[5]=E,I[6]=h,I[7]=E,I[8]=p;var g=f.computeEigenDecomposition(I,M),v=f.clone(g.unitary,t.halfAxes),O=f.getColumn(v,0,R),w=f.getColumn(v,1,A),x=f.getColumn(v,2,S),C=-Number.MAX_VALUE,P=-Number.MAX_VALUE,U=-Number.MAX_VALUE,D=Number.MAX_VALUE,F=Number.MAX_VALUE,L=Number.MAX_VALUE;for(r=0;r<a;r++)s=e[r],C=Math.max(n.dot(O,s),C),P=Math.max(n.dot(w,s),P),U=Math.max(n.dot(x,s),U),D=Math.min(n.dot(O,s),D),F=Math.min(n.dot(w,s),F),L=Math.min(n.dot(x,s),L);O=n.multiplyByScalar(O,.5*(D+C),O),w=n.multiplyByScalar(w,.5*(F+P),w),x=n.multiplyByScalar(x,.5*(L+U),x);var B=n.add(O,w,t.center);B=n.add(B,x,B);var z=y;return z.x=C-D,z.y=P-F,z.z=U-L,n.multiplyByScalar(z,.5,z),f.multiplyByScale(t.halfAxes,z,t.halfAxes),t};var I=new n,g=new n,v=new r,O=new n,w=[new r,new r,new r,new r,new r,new r,new r,new r],x=[new n,new n,new n,new n,new n,new n,new n,new n],C=[new t,new t,new t,new t,new t,new t,new t,new t];m.fromRectangle=function(e,t,n,r,i){t=a(t,0),n=a(n,0),r=a(r,u.WGS84);var o=E.center(e,v),c=r.cartographicToCartesian(o,O),l=new s(c,r),h=l.plane,f=w[0],m=w[1],_=w[2],T=w[3],y=w[4],R=w[5],A=w[6],S=w[7],N=o.longitude,M=e.south<0&&e.north>0?0:o.latitude;A.latitude=R.latitude=y.latitude=e.south,S.latitude=T.latitude=M,f.latitude=m.latitude=_.latitude=e.north,A.longitude=S.longitude=f.longitude=e.west,R.longitude=m.longitude=N,y.longitude=T.longitude=_.longitude=e.east,_.height=m.height=f.height=S.height=A.height=R.height=y.height=T.height=n,r.cartographicArrayToCartesianArray(w,x),l.projectPointsToNearestOnPlane(x,C);var I=Math.min(C[6].x,C[7].x,C[0].x),g=Math.max(C[2].x,C[3].x,C[4].x),P=Math.min(C[4].y,C[5].y,C[6].y),U=Math.max(C[0].y,C[1].y,C[2].y);_.height=f.height=y.height=A.height=t,r.cartographicArrayToCartesianArray(w,x);var D=Math.min(d.getPointDistance(h,x[0]),d.getPointDistance(h,x[2]),d.getPointDistance(h,x[4]),d.getPointDistance(h,x[6])),F=n;return p(l,I,g,P,U,D,F,i)},m.clone=function(e,t){if(i(e))return i(t)?(n.clone(e.center,t.center),f.clone(e.halfAxes,t.halfAxes),t):new m(e.center,e.halfAxes)},m.intersectPlane=function(e,t){var r=e.center,a=t.normal,i=e.halfAxes,o=a.x,u=a.y,s=a.z,l=Math.abs(o*i[f.COLUMN0ROW0]+u*i[f.COLUMN0ROW1]+s*i[f.COLUMN0ROW2])+Math.abs(o*i[f.COLUMN1ROW0]+u*i[f.COLUMN1ROW1]+s*i[f.COLUMN1ROW2])+Math.abs(o*i[f.COLUMN2ROW0]+u*i[f.COLUMN2ROW1]+s*i[f.COLUMN2ROW2]),h=n.dot(a,r)+t.distance;return h<=-l?c.OUTSIDE:h>=l?c.INSIDE:c.INTERSECTING};var P=new n,U=new n,D=new n,F=new n;m.distanceSquaredTo=function(e,t){var r=n.subtract(t,e.center,I),a=e.halfAxes,i=f.getColumn(a,0,P),o=f.getColumn(a,1,U),u=f.getColumn(a,2,D),s=n.magnitude(i),c=n.magnitude(o),l=n.magnitude(u);n.normalize(i,i),n.normalize(o,o),n.normalize(u,u);var h=F;h.x=n.dot(r,i),h.y=n.dot(r,o),h.z=n.dot(r,u);var d,E=0;return h.x<-s?(d=h.x+s,E+=d*d):h.x>s&&(d=h.x-s,E+=d*d),h.y<-c?(d=h.y+c,E+=d*d):h.y>c&&(d=h.y-c,E+=d*d),h.z<-l?(d=h.z+l,E+=d*d):h.z>l&&(d=h.z-l,E+=d*d),E};var L=new n,B=new n;m.computePlaneDistances=function(e,t,r,a){i(a)||(a=new l);var o=Number.POSITIVE_INFINITY,u=Number.NEGATIVE_INFINITY,s=e.center,c=e.halfAxes,h=f.getColumn(c,0,P),d=f.getColumn(c,1,U),E=f.getColumn(c,2,D),m=n.add(h,d,L);n.add(m,E,m),n.add(m,s,m);var p=n.subtract(m,t,B),_=n.dot(r,p);return o=Math.min(_,o),u=Math.max(_,u),n.add(s,h,m),n.add(m,d,m),n.subtract(m,E,m),n.subtract(m,t,p),_=n.dot(r,p),o=Math.min(_,o),u=Math.max(_,u),n.add(s,h,m),n.subtract(m,d,m),n.add(m,E,m),n.subtract(m,t,p),_=n.dot(r,p),o=Math.min(_,o),u=Math.max(_,u),n.add(s,h,m),n.subtract(m,d,m),n.subtract(m,E,m),n.subtract(m,t,p),_=n.dot(r,p),o=Math.min(_,o),u=Math.max(_,u),n.subtract(s,h,m),n.add(m,d,m),n.add(m,E,m),n.subtract(m,t,p),_=n.dot(r,p),o=Math.min(_,o),u=Math.max(_,u),n.subtract(s,h,m),n.add(m,d,m),n.subtract(m,E,m),n.subtract(m,t,p),_=n.dot(r,p),o=Math.min(_,o),u=Math.max(_,u),n.subtract(s,h,m),n.subtract(m,d,m),n.add(m,E,m),n.subtract(m,t,p),_=n.dot(r,p),o=Math.min(_,o),u=Math.max(_,u),n.subtract(s,h,m),n.subtract(m,d,m),n.subtract(m,E,m),n.subtract(m,t,p),_=n.dot(r,p),o=Math.min(_,o),u=Math.max(_,u),a.start=o,a.stop=u,a};var z=new e;return m.isOccluded=function(t,n){var r=e.fromOrientedBoundingBox(t,z);return!n.isBoundingSphereVisible(r)},m.prototype.intersectPlane=function(e){return m.intersectPlane(this,e)},m.prototype.distanceSquaredTo=function(e){return m.distanceSquaredTo(this,e)},m.prototype.computePlaneDistances=function(e,t,n){return m.computePlaneDistances(this,e,t,n)},m.prototype.isOccluded=function(e){return m.isOccluded(this,e)},m.equals=function(e,t){return e===t||i(e)&&i(t)&&n.equals(e.center,t.center)&&f.equals(e.halfAxes,t.halfAxes)},m.prototype.clone=function(e){return m.clone(this,e)},m.prototype.equals=function(e){return m.equals(this,e)},m}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,n,r,a,i){"use strict";if(!r.supportsTypedArrays())return{};var o={BYTE:i.BYTE,UNSIGNED_BYTE:i.UNSIGNED_BYTE,SHORT:i.SHORT,UNSIGNED_SHORT:i.UNSIGNED_SHORT,INT:i.INT,UNSIGNED_INT:i.UNSIGNED_INT,FLOAT:i.FLOAT,DOUBLE:i.DOUBLE};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Int32Array?o.INT:e instanceof Uint32Array?o.UNSIGNED_INT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.INT||e===o.UNSIGNED_INT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.INT:return new Int32Array(t);case o.UNSIGNED_INT:return new Uint32Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t)}},o.createArrayBufferView=function(t,n,r,a){switch(r=e(r,0),a=e(a,(n.byteLength-r)/o.getSizeInBytes(t)),t){case o.BYTE:return new Int8Array(n,r,a);case o.UNSIGNED_BYTE:return new Uint8Array(n,r,a);case o.SHORT:return new Int16Array(n,r,a);case o.UNSIGNED_SHORT:return new Uint16Array(n,r,a);case o.INT:return new Int32Array(n,r,a);case o.UNSIGNED_INT:return new Uint32Array(n,r,a);case o.FLOAT:return new Float32Array(n,r,a);case o.DOUBLE:return new Float64Array(n,r,a)}},o.fromName=function(e){switch(e){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE}},a(o)}),define("Core/TerrainQuantization",["./freezeObject"],function(e){"use strict";var t={NONE:0,BITS12:1};return e(t)}),define("Core/TerrainEncoding",["./AttributeCompression","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./Math","./Matrix4","./TerrainQuantization"],function(e,t,n,r,a,i,o,u,s){"use strict";function c(e,t,r,o,c,f){var p,_,T,y;if(i(e)&&i(t)&&i(r)&&i(o)){var R=e.minimum,A=e.maximum,S=n.subtract(A,R,h),N=r-t,M=Math.max(n.maximumComponent(S),N);p=M<m-1?s.BITS12:s.NONE,_=e.center,T=u.inverseTransformation(o,new u);var I=n.negate(R,l);u.multiply(u.fromTranslation(I,d),T,T);var g=l;g.x=1/S.x,g.y=1/S.y,g.z=1/S.z,u.multiply(u.fromScale(g,d),T,T),y=u.clone(o),u.setTranslation(y,n.ZERO,y),o=u.clone(o,new u);var v=u.fromTranslation(R,d),O=u.fromScale(S,E),w=u.multiply(v,O,d);u.multiply(o,w,o),u.multiply(y,w,y)}this.quantization=p,this.minimumHeight=t,this.maximumHeight=r,this.center=_,this.toScaledENU=T,this.fromScaledENU=o,this.matrix=y,this.hasVertexNormals=c,this.hasWebMercatorT=a(f,!1)}var l=new n,h=new n,f=new t,d=new u,E=new u,m=Math.pow(2,12);c.prototype.encode=function(r,a,i,c,h,d,E){var m=c.x,p=c.y;if(this.quantization===s.BITS12){i=u.multiplyByPoint(this.toScaledENU,i,l),i.x=o.clamp(i.x,0,1),i.y=o.clamp(i.y,0,1),i.z=o.clamp(i.z,0,1);var _=this.maximumHeight-this.minimumHeight,T=o.clamp((h-this.minimumHeight)/_,0,1);t.fromElements(i.x,i.y,f);var y=e.compressTextureCoordinates(f);t.fromElements(i.z,T,f);var R=e.compressTextureCoordinates(f);t.fromElements(m,p,f);var A=e.compressTextureCoordinates(f);if(r[a++]=y,r[a++]=R,r[a++]=A,this.hasWebMercatorT){t.fromElements(E,0,f);var S=e.compressTextureCoordinates(f);r[a++]=S}}else n.subtract(i,this.center,l),r[a++]=l.x,r[a++]=l.y,r[a++]=l.z,r[a++]=h,r[a++]=m,r[a++]=p,this.hasWebMercatorT&&(r[a++]=E);return this.hasVertexNormals&&(r[a++]=e.octPackFloat(d)),a},c.prototype.decodePosition=function(t,r,a){if(i(a)||(a=new n),r*=this.getStride(),this.quantization===s.BITS12){var o=e.decompressTextureCoordinates(t[r],f);a.x=o.x,a.y=o.y;var c=e.decompressTextureCoordinates(t[r+1],f);return a.z=c.x,
u.multiplyByPoint(this.fromScaledENU,a,a)}return a.x=t[r],a.y=t[r+1],a.z=t[r+2],n.add(a,this.center,a)},c.prototype.decodeTextureCoordinates=function(n,r,a){return i(a)||(a=new t),r*=this.getStride(),this.quantization===s.BITS12?e.decompressTextureCoordinates(n[r+2],a):t.fromElements(n[r+4],n[r+5],a)},c.prototype.decodeHeight=function(t,n){if(n*=this.getStride(),this.quantization===s.BITS12){var r=e.decompressTextureCoordinates(t[n+1],f);return r.y*(this.maximumHeight-this.minimumHeight)+this.minimumHeight}return t[n+3]},c.prototype.getOctEncodedNormal=function(e,n,r){var a=this.getStride();n=(n+1)*a-1;var i=e[n]/256,o=Math.floor(i),u=256*(i-o);return t.fromElements(o,u,r)},c.prototype.getStride=function(){var e;switch(this.quantization){case s.BITS12:e=3;break;default:e=6}return this.hasWebMercatorT&&++e,this.hasVertexNormals&&++e,e};var p={position3DAndHeight:0,textureCoordAndEncodedNormals:1},_={compressed0:0,compressed1:1};return c.prototype.getAttributes=function(e){var t,n=r.FLOAT,a=r.getSizeInBytes(n);if(this.quantization===s.NONE){var i=4,o=2;return this.hasWebMercatorT&&++o,this.hasVertexNormals&&++o,t=(i+o)*a,[{index:p.position3DAndHeight,vertexBuffer:e,componentDatatype:n,componentsPerAttribute:i,offsetInBytes:0,strideInBytes:t},{index:p.textureCoordAndEncodedNormals,vertexBuffer:e,componentDatatype:n,componentsPerAttribute:o,offsetInBytes:i*a,strideInBytes:t}]}var u=3,c=0;return(this.hasWebMercatorT||this.hasVertexNormals)&&++u,this.hasWebMercatorT&&this.hasVertexNormals?(++c,t=(u+c)*a,[{index:_.compressed0,vertexBuffer:e,componentDatatype:n,componentsPerAttribute:u,offsetInBytes:0,strideInBytes:t},{index:_.compressed1,vertexBuffer:e,componentDatatype:n,componentsPerAttribute:c,offsetInBytes:u*a,strideInBytes:t}]):[{index:_.compressed0,vertexBuffer:e,componentDatatype:n,componentsPerAttribute:u}]},c.prototype.getAttributeLocations=function(){return this.quantization===s.NONE?p:_},c.clone=function(e,t){return i(t)||(t=new c),t.quantization=e.quantization,t.minimumHeight=e.minimumHeight,t.maximumHeight=e.maximumHeight,t.center=n.clone(e.center),t.toScaledENU=u.clone(e.toScaledENU),t.fromScaledENU=u.clone(e.fromScaledENU),t.matrix=u.clone(e.matrix),t.hasVertexNormals=e.hasVertexNormals,t.hasWebMercatorT=e.hasWebMercatorT,t},c}),define("Core/formatError",["./defined"],function(e){"use strict";function t(t){var n,r=t.name,a=t.message;n=e(r)&&e(a)?r+": "+a:t.toString();var i=t.stack;return e(i)&&(n+="\n"+i),n}return t}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,n){"use strict";function r(r){var a,i=[],o={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;i.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=r(s.parameters,i)}catch(e){e instanceof Error?o.error={name:e.name,message:e.message,stack:e.stack}:o.error=e}t(a)||(a=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(i.length=0);try{a(o,i)}catch(e){o.result=void 0,o.error="postMessage failed with error: "+n(e)+"\n  with responseMessage: "+JSON.stringify(o),a(o)}}}return r}),define("Workers/upsampleQuantizedTerrainMesh",["../Core/AttributeCompression","../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartographic","../Core/defined","../Core/Ellipsoid","../Core/EllipsoidalOccluder","../Core/IndexDatatype","../Core/Intersections2D","../Core/Math","../Core/OrientedBoundingBox","../Core/TerrainEncoding","./createTaskProcessorWorker"],function(e,t,n,r,a,i,o,u,s,c,l,h,f,d){"use strict";function E(e,n){var a=e.isEastChild,i=e.isNorthChild,d=a?y:0,E=a?T:y,p=i?y:0,F=i?T:y,L=I,B=g,z=v,b=w;L.length=0,B.length=0,z.length=0,b.length=0;var q=O;q.length=0;var G={},W=e.vertices,X=e.indices;X=X.subarray(0,e.skirtIndex);var V,H,Y,k=f.clone(e.encoding),Z=k.hasVertexNormals,j=e.exaggeration,K=0,Q=e.vertexCountWithoutSkirts,J=e.minimumHeight,$=e.maximumHeight,ee=new Array(Q),te=new Array(Q),ne=new Array(Q),re=Z?new Array(2*Q):void 0,ae=20;for(H=0,Y=0;H<Q;++H,Y+=2){var ie=k.decodeTextureCoordinates(W,H,U);if(V=k.decodeHeight(W,H)/j,ee[H]=l.clamp(ie.x*T|0,0,T),te[H]=l.clamp(ie.y*T|0,0,T),ne[H]=l.clamp((V-J)/($-J)*T|0,0,T),ee[H]<ae&&(ee[H]=0),te[H]<ae&&(te[H]=0),T-ee[H]<ae&&(ee[H]=T),T-te[H]<ae&&(te[H]=T),Z){var oe=k.getOctEncodedNormal(W,H,D);re[Y]=oe.x,re[Y+1]=oe.y}}var ue,se;for(H=0,Y=0;H<Q;++H,Y+=2)ue=ee[H],se=te[H],(a&&ue>=y||!a&&ue<=y)&&(i&&se>=y||!i&&se<=y)&&(G[H]=K,L.push(ue),B.push(se),z.push(ne[H]),Z&&(b.push(re[Y]),b.push(re[Y+1])),++K);var ce=[];ce.push(new m),ce.push(new m),ce.push(new m);var le=[];le.push(new m),le.push(new m),le.push(new m);var he,fe;for(H=0;H<X.length;H+=3){var de=X[H],Ee=X[H+1],me=X[H+2],pe=ee[de],_e=ee[Ee],Te=ee[me];ce[0].initializeIndexed(ee,te,ne,re,de),ce[1].initializeIndexed(ee,te,ne,re,Ee),ce[2].initializeIndexed(ee,te,ne,re,me);var ye=c.clipTriangleAtAxisAlignedThreshold(y,a,pe,_e,Te,R);he=0,he>=ye.length||(he=le[0].initializeFromClipResult(ye,he,ce),he>=ye.length||(he=le[1].initializeFromClipResult(ye,he,ce),he>=ye.length||(he=le[2].initializeFromClipResult(ye,he,ce),fe=c.clipTriangleAtAxisAlignedThreshold(y,i,le[0].getV(),le[1].getV(),le[2].getV(),A),_(L,B,z,b,q,G,fe,le,Z),he<ye.length&&(le[2].clone(le[1]),le[2].initializeFromClipResult(ye,he,ce),fe=c.clipTriangleAtAxisAlignedThreshold(y,i,le[0].getV(),le[1].getV(),le[2].getV(),A),_(L,B,z,b,q,G,fe,le,Z)))))}var Re=a?-T:0,Ae=i?-T:0,Se=[],Ne=[],Me=[],Ie=[],ge=Number.MAX_VALUE,ve=-ge,Oe=S;Oe.length=0;var we=o.clone(e.ellipsoid),xe=e.childRectangle,Ce=xe.north,Pe=xe.south,Ue=xe.east,De=xe.west;for(Ue<De&&(Ue+=l.TWO_PI),H=0;H<L.length;++H)ue=Math.round(L[H]),ue<=d?(Se.push(H),ue=0):ue>=E?(Me.push(H),ue=T):ue=2*ue+Re,L[H]=ue,se=Math.round(B[H]),se<=p?(Ne.push(H),se=0):se>=F?(Ie.push(H),se=T):se=2*se+Ae,B[H]=se,V=l.lerp(J,$,z[H]/T),V<ge&&(ge=V),V>ve&&(ve=V),z[H]=V,N.longitude=l.lerp(De,Ue,ue/T),N.latitude=l.lerp(Pe,Ce,se/T),N.height=V,we.cartographicToCartesian(N,M),Oe.push(M.x),Oe.push(M.y),Oe.push(M.z);var Fe=t.fromVertices(Oe,r.ZERO,3,C),Le=h.fromRectangle(xe,ge,ve,we,P),Be=new u(we),ze=Be.computeHorizonCullingPointFromVertices(Fe.center,Oe,3,Fe.center,x),be=ve-ge,qe=new Uint16Array(L.length+B.length+z.length);for(H=0;H<L.length;++H)qe[H]=L[H];var Ge=L.length;for(H=0;H<B.length;++H)qe[Ge+H]=B[H];for(Ge+=B.length,H=0;H<z.length;++H)qe[Ge+H]=T*(z[H]-ge)/be;var We,Xe=s.createTypedArray(L.length,q);if(Z){var Ve=new Uint8Array(b);n.push(qe.buffer,Xe.buffer,Ve.buffer),We=Ve.buffer}else n.push(qe.buffer,Xe.buffer);return{vertices:qe.buffer,encodedNormals:We,indices:Xe.buffer,minimumHeight:ge,maximumHeight:ve,westIndices:Se,southIndices:Ne,eastIndices:Me,northIndices:Ie,boundingSphere:Fe,orientedBoundingBox:Le,horizonOcclusionPoint:ze}}function m(){this.vertexBuffer=void 0,this.index=void 0,this.first=void 0,this.second=void 0,this.ratio=void 0}function p(t,n){++L;var a=B[L],i=z[L];return a=e.octDecode(t.first.getNormalX(),t.first.getNormalY(),a),i=e.octDecode(t.second.getNormalX(),t.second.getNormalY(),i),M=r.lerp(a,i,t.ratio,M),r.normalize(M,M),e.octEncode(M,n),--L,n}function _(e,t,n,r,a,o,u,s,c){if(0!==u.length){for(var l=0,h=0;h<u.length;)h=b[l++].initializeFromClipResult(u,h,s);for(var f=0;f<l;++f){var d=b[f];if(d.isIndexed())d.newIndex=o[d.index],d.uBuffer=e,d.vBuffer=t,d.heightBuffer=n,c&&(d.normalBuffer=r);else{var E=d.getKey();if(i(o[E]))d.newIndex=o[E];else{var m=e.length;e.push(d.getU()),t.push(d.getV()),n.push(d.getH()),c&&(r.push(d.getNormalX()),r.push(d.getNormalY())),d.newIndex=m,o[E]=m}}}3===l?(a.push(b[0].newIndex),a.push(b[1].newIndex),a.push(b[2].newIndex)):4===l&&(a.push(b[0].newIndex),a.push(b[1].newIndex),a.push(b[2].newIndex),a.push(b[0].newIndex),a.push(b[2].newIndex),a.push(b[3].newIndex))}}var T=32767,y=T/2|0,R=[],A=[],S=[],N=new a,M=new r,I=[],g=[],v=[],O=[],w=[],x=new r,C=new t,P=new h,U=new n,D=new r;m.prototype.clone=function(e){return i(e)||(e=new m),e.uBuffer=this.uBuffer,e.vBuffer=this.vBuffer,e.heightBuffer=this.heightBuffer,e.normalBuffer=this.normalBuffer,e.index=this.index,e.first=this.first,e.second=this.second,e.ratio=this.ratio,e},m.prototype.initializeIndexed=function(e,t,n,r,a){this.uBuffer=e,this.vBuffer=t,this.heightBuffer=n,this.normalBuffer=r,this.index=a,this.first=void 0,this.second=void 0,this.ratio=void 0},m.prototype.initializeFromClipResult=function(e,t,n){var r=t+1;return e[t]!==-1?n[e[t]].clone(this):(this.vertexBuffer=void 0,this.index=void 0,this.first=n[e[r]],++r,this.second=n[e[r]],++r,this.ratio=e[r],++r),r},m.prototype.getKey=function(){return this.isIndexed()?this.index:JSON.stringify({first:this.first.getKey(),second:this.second.getKey(),ratio:this.ratio})},m.prototype.isIndexed=function(){return i(this.index)},m.prototype.getH=function(){return i(this.index)?this.heightBuffer[this.index]:l.lerp(this.first.getH(),this.second.getH(),this.ratio)},m.prototype.getU=function(){return i(this.index)?this.uBuffer[this.index]:l.lerp(this.first.getU(),this.second.getU(),this.ratio)},m.prototype.getV=function(){return i(this.index)?this.vBuffer[this.index]:l.lerp(this.first.getV(),this.second.getV(),this.ratio)};var F=new n,L=-1,B=[new r,new r],z=[new r,new r];m.prototype.getNormalX=function(){return i(this.index)?this.normalBuffer[2*this.index]:(F=p(this,F),F.x)},m.prototype.getNormalY=function(){return i(this.index)?this.normalBuffer[2*this.index+1]:(F=p(this,F),F.y)};var b=[];return b.push(new m),b.push(new m),b.push(new m),b.push(new m),d(E)})}();