/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;

@Deprecated
public class CenteredScaleOperator
extends AbstractAdaptableOperator {
    private Parameter parameter = null;
    public double scaleFactor = 0.5;

    public CenteredScaleOperator(Parameter parameter) {
        super(AdaptationMode.DEFAULT);
        this.parameter = parameter;
    }

    public CenteredScaleOperator(Parameter parameter, double d, double d2, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.parameter = parameter;
        this.scaleFactor = d;
        this.setWeight(d2);
    }

    @Override
    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public final double doOperation() {
        double d = 0.0;
        for (int i = 0; i < this.parameter.getDimension(); ++i) {
            d += this.parameter.getParameterValue(i);
        }
        double d2 = d / (double)this.parameter.getDimension();
        double d3 = this.getRandomScaleFactor();
        double d4 = (double)this.parameter.getDimension() * Math.log(1.0 / d3);
        for (int i = 0; i < this.parameter.getDimension(); ++i) {
            double d5 = (this.parameter.getParameterValue(i) - d2) * d3 + d2;
            if (d5 < this.parameter.getBounds().getLowerLimit(i) || d5 > this.parameter.getBounds().getUpperLimit(i)) {
                return Double.NEGATIVE_INFINITY;
            }
            this.parameter.setParameterValue(i, d5);
        }
        return d4;
    }

    public final double getRandomScaleFactor() {
        return this.scaleFactor + MathUtils.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
    }

    @Override
    public final String getOperatorName() {
        return this.parameter.getParameterName();
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(1.0 / this.scaleFactor - 1.0);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = 1.0 / (Math.exp(d) + 1.0);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }

    public String toString() {
        return this.getOperatorName() + "(scaleFactor=" + this.scaleFactor + ")";
    }
}

