## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----example------------------------------------------------------------------
library(cosCorr)

# Simple example with 4 variables (p=4)
x <- c(0, 2, 3, 4)
rho <- cosCorr(x)
print(rho)

## ----examples-----------------------------------------------------------------
# Example with 5 variables
x2 <- c(0, 1, 2, 3, 4)
rho2 <- cosCorr(x2)
print(rho2)

# Example with NA values removed
x3 <- c(0, 2, NA, 4, 5)
rho3 <- cosCorr(x3, na.rm = TRUE)
print(rho3)

