## ----knitr-setup, include = FALSE-----------------------------------------------------------------
unloadNamespace("dplyr")
require(container)
has = container::has
has_name = container::has_name


knitr::opts_chunk$set(
  comment = "#",
  prompt = FALSE,
  tidy = FALSE,
  cache = FALSE,
  collapse = TRUE
)

old <- options(width = 100L)

## -------------------------------------------------------------------------------------------------
library(container)
co <- cont(a = 1, b = 1:10)  # same as co = container(a = 1, b = 1:10)

## -------------------------------------------------------------------------------------------------
print(co)

## -------------------------------------------------------------------------------------------------
as.list(co)

## -------------------------------------------------------------------------------------------------
str(co)

## -------------------------------------------------------------------------------------------------
length(co)

names(co)

names(co)[1] <- "A"

co

## -------------------------------------------------------------------------------------------------
l <- list(x = (1:2)^1, y = (1:2)^2)
co2 <- as.container(l)

co2

## -------------------------------------------------------------------------------------------------
c(co, c = 3, d = 4)

c(co, co2)

## -------------------------------------------------------------------------------------------------
co[["c"]] <- 3

co

## -------------------------------------------------------------------------------------------------
co[["co2"]] <- co2

co

## ----error = TRUE---------------------------------------------------------------------------------
try({
co[[5]] <- 5
})

## -------------------------------------------------------------------------------------------------
co[[3]] <- 0
co[1:2] <- 0

co

## -------------------------------------------------------------------------------------------------
co[["A"]] <- NULL

co


## -------------------------------------------------------------------------------------------------
co[list("A", 2, "c")] <- list(1, 2, "three")

co

## -------------------------------------------------------------------------------------------------
co[[{"three"}]] <- 3

co

## -------------------------------------------------------------------------------------------------
co[[{co2}]] <- 4

co

## -------------------------------------------------------------------------------------------------
co <- container(a = 1, b = "b", c = 3, d = "d")
co[["a"]]

co[[1]]

co[1:3]

## -------------------------------------------------------------------------------------------------
co[-1]

co[-(1:3)]

## -------------------------------------------------------------------------------------------------
co$a

li <- as.list(co)
li$a

## -------------------------------------------------------------------------------------------------
co[1, 3, 4]

co[TRUE, FALSE]

co["c", "b", "a"]

## -------------------------------------------------------------------------------------------------
co[list(1, "b", 4)]

co[1, "b", 4]

## -------------------------------------------------------------------------------------------------
co[a:c]

co[2:d]

co[-(b:c)]

co[-c("a", "d")]

## -------------------------------------------------------------------------------------------------
# Replace by NSE name range
co[a:c] <- 0
co

# Replace complement via negative NSE range
co[-(a:b)] <- 5:6
co

## -------------------------------------------------------------------------------------------------
co <- container(a = 1, b = "b", c = 3, d = "d")

co[0:10]

co[1, "foo", "c", "bar"]

## -------------------------------------------------------------------------------------------------
co[0:10, .default = 0]

co[1, "foo", "c", "bar", .default = NA]

co[1, "foo", "c", "bar", .default = "ups"]

co[1, "foo", "c", "bar", .default = 1:3]

## -------------------------------------------------------------------------------------------------
co <- container(a = 1, b = "foo", c = 1, d = "foo")
count(co, 1)

count(co, "foo")

## ----include = FALSE----------------------------------------------------------
options(old)

