## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  eval = TRUE,
  echo = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(forcis)

## ----'download-db', eval=FALSE------------------------------------------------
# # Create a data/ folder ----
# dir.create("data")
# 
# # Download latest version of the database ----
# download_forcis_db(path = "data", version = NULL)

## ----'load-data', echo=FALSE--------------------------------------------------
file_name <- system.file(
  file.path("extdata", "FORCIS_net_sample.csv"),
  package = "forcis"
)
net_data <- read.csv(file_name)

## ----'load-data-user', eval=FALSE---------------------------------------------
# # Import net data ----
# net_data <- read_plankton_nets_data(path = "data")

## ----'select-taxo'------------------------------------------------------------
# Select taxonomy ----
net_data_vt <- net_data |>
  select_taxonomy(taxonomy = "VT")

## ----'compute-abundance'------------------------------------------------------
# Convert species counts in raw abundance ----
net_data_vt_raw_ab <- net_data_vt |>
  compute_abundances(aggregate = TRUE)

## ----'exploration'------------------------------------------------------------
# Format ----
dim(net_data_vt)
dim(net_data_vt_raw_ab)

# Header ----
net_data_vt_raw_ab |>
  as.data.frame() |>
  head()

## ----'compute-concetration'---------------------------------------------------
# Convert species counts in number concentration ----
net_data_vt_n_conc <- net_data_vt |>
  compute_concentrations(aggregate = TRUE)

## ----'compute-frequency'------------------------------------------------------
# Convert species counts in relative abundance ----
net_data_rel_ab <- net_data_vt |>
  compute_frequencies(aggregate = TRUE)

