/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils.reader;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.apache.axis2.util.ArrayStack;

public class ADBNamespaceContext
implements NamespaceContext {
    private NamespaceContext parentNsContext;
    private ArrayStack prefixStack = new ArrayStack();
    private ArrayStack uriStack = new ArrayStack();

    public NamespaceContext getParentNsContext() {
        return this.parentNsContext;
    }

    public void setParentNsContext(NamespaceContext parentNsContext) {
        this.parentNsContext = parentNsContext;
    }

    public void pushNamespace(String prefix, String uri) {
        this.prefixStack.push((Object)prefix);
        this.uriStack.push((Object)uri);
    }

    public void popNamespace() {
        this.prefixStack.pop();
        this.uriStack.pop();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.prefixStack.contains((Object)prefix)) {
            int index = this.prefixStack.indexOf((Object)prefix);
            return (String)this.uriStack.get(index);
        }
        if (this.parentNsContext != null) {
            return this.parentNsContext.getPrefix(prefix);
        }
        return null;
    }

    @Override
    public String getPrefix(String uri) {
        int index = this.uriStack.indexOf((Object)uri);
        if (index != -1) {
            return (String)this.prefixStack.get(index);
        }
        if (this.parentNsContext != null) {
            return this.parentNsContext.getPrefix(uri);
        }
        return null;
    }

    public Iterator getPrefixes(String uri) {
        String[] uris = (String[])this.uriStack.toArray((Object[])new String[this.uriStack.size()]);
        ArrayList<Object> tempList = new ArrayList<Object>();
        for (int i = 0; i < uris.length; ++i) {
            if (!uris[i].equals(uri)) continue;
            tempList.add(this.prefixStack.get(i));
        }
        return new WrappingIterator(tempList.iterator());
    }

    private class WrappingIterator
    implements Iterator {
        private Iterator containedIterator = null;

        public WrappingIterator(Iterator containedIterator) {
            this.containedIterator = containedIterator;
        }

        public Iterator getContainedIterator() {
            return this.containedIterator;
        }

        public void setContainedIterator(Iterator containedIterator) {
            this.containedIterator = containedIterator;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.containedIterator.hasNext();
        }

        public Object next() {
            return this.containedIterator.next();
        }
    }
}

