/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.network.bind;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.DynamicGroup;
import org.apache.brooklyn.entity.network.bind.BindDnsServerImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.net.Cidr;

@Catalog(name="BIND", description="BIND is an Internet Domain Name Server.", iconUrl="classpath:///isc-logo.png")
@ImplementedBy(value=BindDnsServerImpl.class)
public interface BindDnsServer
extends SoftwareProcess {
    @SetFromFlag(value="filter")
    public static final ConfigKey<Predicate<? super Entity>> ENTITY_FILTER = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Predicate<? super Entity>>(){}, (String)"bind.entity.filter", (String)"Filter for entities which will use the BIND DNS service for name resolution.Default is all instances of SoftwareProcess in the application.", (Object)Predicates.instanceOf(SoftwareProcess.class));
    @SetFromFlag(value="domainName")
    public static final ConfigKey<String> DOMAIN_NAME = ConfigKeys.newStringConfigKey((String)"bind.domain.name", (String)"The DNS domain name to serve", (String)"brooklyn.local");
    @SetFromFlag(value="reverseLookupNetwork")
    public static final ConfigKey<String> REVERSE_LOOKUP_NETWORK = ConfigKeys.newStringConfigKey((String)"bind.reverse-lookup.address", (String)"Network address for reverse lookup zone");
    @SetFromFlag(value="subnet")
    public static final ConfigKey<String> MANAGEMENT_CIDR = ConfigKeys.newStringConfigKey((String)"bind.access.cidr", (String)"Subnet CIDR or ACL allowed to access DNS", (String)"0.0.0.0/0");
    @SetFromFlag(value="hostnameSensor")
    public static final ConfigKey<AttributeSensor<String>> HOSTNAME_SENSOR = ConfigKeys.newConfigKey((TypeToken)new TypeToken<AttributeSensor<String>>(){}, (String)"bind.sensor.hostname", (String)"Sensor on managed entities that reports the basename for the hostname");
    @SetFromFlag(value="addressSensor")
    public static final ConfigKey<AttributeSensor<String>> ADDRESS_SENSOR = ConfigKeys.newConfigKey((TypeToken)new TypeToken<AttributeSensor<String>>(){}, (String)"bind.sensor.address", (String)"Sensor on managed entities that reports the address to register; host.address or host.subnet.address are common choices; blank (deprecated default behaviour) will inspect machines attached to entities but for legacy compatibility only; blueprints should set this");
    public static final PortAttributeSensorAndConfigKey DNS_PORT = new PortAttributeSensorAndConfigKey("bind.port", "BIND DNS port for TCP and UDP", (Object)PortRanges.fromString((String)"53"));
    @SetFromFlag(value="zoneFileTemplate")
    public static final ConfigKey<String> DOMAIN_ZONE_FILE_TEMPLATE = ConfigKeys.newStringConfigKey((String)"bind.template.domain-zone", (String)"The BIND domain zone file to serve (as FreeMarker template)", (String)"classpath://org/apache/brooklyn/entity/network/bind/domain.zone");
    @SetFromFlag(value="reverseZoneFileTemplate")
    public static final ConfigKey<String> REVERSE_ZONE_FILE_TEMPLATE = ConfigKeys.newStringConfigKey((String)"bind.template.reverse-zone", (String)"The BIND reverse lookup zone file to serve (as FreeMarker template)", (String)"classpath://org/apache/brooklyn/entity/network/bind/reverse.zone");
    @SetFromFlag(value="namedConfTemplate")
    public static final ConfigKey<String> NAMED_CONF_TEMPLATE = ConfigKeys.newStringConfigKey((String)"bind.template.named-conf", (String)"The BIND named configuration file (as FreeMarker template)", (String)"classpath://org/apache/brooklyn/entity/network/bind/named.conf");
    @SetFromFlag(value="updateRootZonesFile")
    public static final ConfigKey<Boolean> UPDATE_ROOT_ZONES_FILE = ConfigKeys.newBooleanConfigKey((String)"bind.updateRootZones", (String)"Instructs the entity to fetch the latest root zones file from ftp.rs.internic.net.", (Boolean)Boolean.FALSE);
    public static final AttributeSensor<Cidr> REVERSE_LOOKUP_CIDR = Sensors.newSensor(Cidr.class, (String)"bind.reverse-lookup.cidr", (String)"The network CIDR that hosts must have for reverse lookup entries to be added (default uses server address /24)");
    public static final AttributeSensor<String> REVERSE_LOOKUP_DOMAIN = Sensors.newStringSensor((String)"bind.reverse-lookup.domain", (String)"The in-addr.arpa reverse lookup domain name");
    @SetFromFlag(value="replaceResolvConf")
    public static final ConfigKey<Boolean> REPLACE_RESOLV_CONF = ConfigKeys.newBooleanConfigKey((String)"bind.resolv-conf.replce", (String)"Set to replace resolv.conf with the template (default is to use eth0 script)", (Boolean)Boolean.FALSE);
    @SetFromFlag(value="interfaceConfigTemplate")
    public static final ConfigKey<String> INTERFACE_CONFIG_TEMPLATE = ConfigKeys.newStringConfigKey((String)"bind.template.interface-cfg", (String)"The network interface configuration file for clients (as FreeMarker template)", (String)"classpath://org/apache/brooklyn/entity/network/bind/ifcfg");
    @SetFromFlag(value="interfaceConfigTemplate")
    public static final ConfigKey<String> RESOLV_CONF_TEMPLATE = ConfigKeys.newStringConfigKey((String)"bind.template.resolv-conf", (String)"The resolver configuration file for clients (as FreeMarker template)", (String)"classpath://org/apache/brooklyn/entity/network/bind/resolv.conf");
    public static final AttributeSensor<DynamicGroup> ENTITIES = Sensors.newSensor(DynamicGroup.class, (String)"bind.entities", (String)"The entities being managed by this server");
    public static final AttributeSensor<Multimap<String, String>> ADDRESS_MAPPINGS = Sensors.newSensor((TypeToken)new TypeToken<Multimap<String, String>>(){}, (String)"bind.mappings", (String)"All address mappings maintained by the server, in form address -> [names]");
    public static final AttributeSensor<Map<String, String>> A_RECORDS = Sensors.newSensor((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"bind.records.a", (String)"All A records for the server, in form name -> address");
    public static final AttributeSensor<Multimap<String, String>> CNAME_RECORDS = Sensors.newSensor((TypeToken)new TypeToken<Multimap<String, String>>(){}, (String)"bind.records.cname", (String)"All CNAME records for the server, in form name -> [names]");
    public static final AttributeSensor<Map<String, String>> PTR_RECORDS = Sensors.newSensor((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"bind.records.ptr", (String)"All PTR records for the server, in form address -> name. Entries will be in REVERSE_LOOKUP_CIDR. Entries are guaranteed to have an inverse mapping in A_RECORDS.");
    public static final AttributeSensor<Long> SERIAL = Sensors.newLongSensor((String)"bind.serial", (String)"A serial number guaranteed to be valid for use in a modified domain.zone or reverse.zone file");

    public Multimap<String, String> getAddressMappings();

    @Deprecated
    @Effector(description="Gets the IP to hostname mappings stored in this DNS server's conf file")
    public Map<String, String> getReverseMappings();

    public Predicate<? super Entity> getEntityFilter();
}

