/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jclouds.openstack.swift.v1.features.AccountApi;

public class TemporaryUrlSigner {
    private final Supplier<String> keySupplier;

    public static TemporaryUrlSigner checkApiEvery(AccountApi api, long seconds) {
        Supplier keySupplier = Suppliers.memoizeWithExpiration((Supplier)new TemporaryUrlKeyFromAccount(api), (long)seconds, (TimeUnit)TimeUnit.SECONDS);
        return new TemporaryUrlSigner((Supplier<String>)keySupplier);
    }

    TemporaryUrlSigner(Supplier<String> keySupplier) {
        this.keySupplier = keySupplier;
    }

    public String sign(String method, String path, long expirationTimestampSeconds) {
        Preconditions.checkNotNull((Object)method, (Object)"method");
        Preconditions.checkNotNull((Object)path, (Object)"path");
        Preconditions.checkArgument((expirationTimestampSeconds > 0L ? 1 : 0) != 0, (Object)"expirationTimestamp must be a unix epoch timestamp");
        String hmacBody = String.format("%s\n%s\n%s", method, expirationTimestampSeconds, path);
        return BaseEncoding.base16().lowerCase().encode(this.hmacSHA1(hmacBody));
    }

    byte[] hmacSHA1(String data) {
        try {
            String key = (String)this.keySupplier.get();
            Preconditions.checkState((key != null ? 1 : 0) != 0, (String)"%s returned a null temporaryUrlKey!", (Object[])new Object[]{this.keySupplier});
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(key.getBytes(Charsets.UTF_8), "HmacSHA1"));
            return mac.doFinal(data.getBytes(Charsets.UTF_8));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static class TemporaryUrlKeyFromAccount
    implements Supplier<String> {
        private final AccountApi api;

        private TemporaryUrlKeyFromAccount(AccountApi api) {
            this.api = (AccountApi)Preconditions.checkNotNull((Object)api, (Object)"accountApi");
        }

        public String get() {
            return (String)this.api.get().getTemporaryUrlKey().orNull();
        }

        public String toString() {
            return String.format("get().getTemporaryUrlKey() using %s", this.api);
        }
    }
}

