/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.ConstraintViolationException;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.objs.BrooklynObjectPredicate;
import org.apache.brooklyn.core.objs.ConstraintSerialization;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.StringEscapes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigConstraints<T extends BrooklynObject> {
    public static final Logger LOG = LoggerFactory.getLogger(ConfigConstraints.class);
    private final T brooklynObject;

    public static void assertValid(Entity entity) {
        Iterable<ConfigKey<?>> violations = new EntityConfigConstraints(entity).getViolations();
        if (!Iterables.isEmpty(violations)) {
            throw new ConstraintViolationException(ConfigConstraints.errorMessage((BrooklynObject)entity, violations));
        }
    }

    public static void assertValid(EntityAdjunct adjunct) {
        Iterable<ConfigKey<?>> violations = new EntityAdjunctConstraints(adjunct).getViolations();
        if (!Iterables.isEmpty(violations)) {
            throw new ConstraintViolationException(ConfigConstraints.errorMessage((BrooklynObject)adjunct, violations));
        }
    }

    public static <T> void assertValid(Entity entity, ConfigKey<T> key, T value) {
        ConfigConstraints.assertValid(new EntityConfigConstraints(entity), entity, key, value);
    }

    public static <T> void assertValid(Location location, ConfigKey<T> key, T value) {
        ConfigConstraints.assertValid(new LocationConfigConstraints(location), location, key, value);
    }

    private static <T> void assertValid(ConfigConstraints<?> constrants, Object context, ConfigKey<T> key, T value) {
        ReferenceWithError<Predicate<?>> validity = constrants.validateValue(key, value);
        if (validity.hasError()) {
            throw new ConstraintViolationException("Invalid value for " + key + " on " + context + " (" + value + "); it should satisfy " + validity.getWithoutError());
        }
    }

    private static String errorMessage(BrooklynObject object, Iterable<ConfigKey<?>> violations) {
        StringBuilder message = new StringBuilder("Error configuring ").append(object.getDisplayName()).append(": [");
        Iterator<ConfigKey<?>> it = violations.iterator();
        while (it.hasNext()) {
            ConfigKey<?> config = it.next();
            message.append(config.getName()).append(":").append(config.getConstraint());
            if (!it.hasNext()) continue;
            message.append(", ");
        }
        return message.append("]").toString();
    }

    public ConfigConstraints(T brooklynObject) {
        this.brooklynObject = brooklynObject;
    }

    abstract Iterable<ConfigKey<?>> getBrooklynObjectTypeConfigKeys();

    public Iterable<ConfigKey<?>> getViolations() {
        ExecutionContext exec;
        Object object = this.getBrooklynObject() instanceof EntityInternal ? ((EntityInternal)this.getBrooklynObject()).getExecutionContext() : (exec = this.getBrooklynObject() instanceof AbstractEntityAdjunct ? ((AbstractEntityAdjunct)this.getBrooklynObject()).getExecutionContext() : null);
        if (exec != null) {
            return (Iterable)exec.get(Tasks.builder().dynamic(false).displayName("Validating config").body(() -> this.validateAll()).build());
        }
        return this.validateAll();
    }

    protected Iterable<ConfigKey<?>> validateAll() {
        LinkedList violating = Lists.newLinkedList();
        Iterable<ConfigKey<?>> configKeys = this.getBrooklynObjectTypeConfigKeys();
        LOG.trace("Checking config keys on {}: {}", this.getBrooklynObject(), configKeys);
        for (ConfigKey<?> configKey : configKeys) {
            ConfigKey<?> ck;
            BrooklynObjectInternal.ConfigurationSupportInternal configInternal = this.getConfigurationSupportInternal();
            Maybe<?> maybeValue = configInternal.getNonBlocking(configKey);
            if (!maybeValue.isPresent() || this.isValueValid(ck = configKey, maybeValue.get())) continue;
            violating.add(configKey);
        }
        return violating;
    }

    <V> boolean isValueValid(ConfigKey<V> configKey, V value) {
        return !this.validateValue(configKey, value).hasError();
    }

    <V> ReferenceWithError<Predicate<?>> validateValue(ConfigKey<V> configKey, V value) {
        try {
            Predicate po = configKey.getConstraint();
            boolean valid = po instanceof BrooklynObjectPredicate ? ((BrooklynObjectPredicate)BrooklynObjectPredicate.class.cast(po)).apply(value, (BrooklynObject)this.brooklynObject) : po.apply(value);
            if (!valid) {
                return ReferenceWithError.newInstanceThrowingError((Object)po, (Throwable)new IllegalStateException("Invalid value for " + configKey.getName() + ": " + value));
            }
        }
        catch (Exception e) {
            LOG.debug("Error checking constraint on " + configKey.getName(), (Throwable)e);
        }
        return ReferenceWithError.newInstanceWithoutError(null);
    }

    private BrooklynObjectInternal.ConfigurationSupportInternal getConfigurationSupportInternal() {
        return ((BrooklynObjectInternal)this.brooklynObject).config();
    }

    protected T getBrooklynObject() {
        return this.brooklynObject;
    }

    public static ConstraintSerialization serialization() {
        return ConstraintSerialization.INSTANCE;
    }

    public static <T> Predicate<T> required() {
        return new RequiredPredicate();
    }

    public static Predicate<Object> forbiddenIf(String otherKeyName) {
        return new ForbiddenIfPredicate(otherKeyName);
    }

    public static Predicate<Object> forbiddenUnless(String otherKeyName) {
        return new ForbiddenUnlessPredicate(otherKeyName);
    }

    public static Predicate<Object> requiredIf(String otherKeyName) {
        return new RequiredIfPredicate(otherKeyName);
    }

    public static Predicate<Object> requiredUnless(String otherKeyName) {
        return new RequiredUnlessPredicate(otherKeyName);
    }

    public static Predicate<Object> forbiddenUnlessAnyOf(List<String> otherKeyNames) {
        return new ForbiddenUnlessAnyOfPredicate(otherKeyNames);
    }

    public static Predicate<Object> requiredUnlessAnyOf(List<String> otherKeyNames) {
        return new RequiredUnlessAnyOfPredicate(otherKeyNames);
    }

    protected static class RequiredUnlessAnyOfPredicate
    extends OtherKeysPredicate {
        public RequiredUnlessAnyOfPredicate(List<String> otherKeyNames) {
            super(otherKeyNames);
        }

        @Override
        public String predicateName() {
            return "requiredUnlessAnyOf";
        }

        @Override
        public boolean test(Object thisValue, List<Object> otherValue) {
            return thisValue != null || otherValue != null && Iterables.tryFind(otherValue, (Predicate)Predicates.notNull()).isPresent();
        }
    }

    protected static class ForbiddenUnlessAnyOfPredicate
    extends OtherKeysPredicate {
        public ForbiddenUnlessAnyOfPredicate(List<String> otherKeyNames) {
            super(otherKeyNames);
        }

        @Override
        public String predicateName() {
            return "forbiddenUnlessAnyOf";
        }

        @Override
        public boolean test(Object thisValue, List<Object> otherValue) {
            return thisValue == null || otherValue != null && Iterables.tryFind(otherValue, (Predicate)Predicates.notNull()).isPresent();
        }
    }

    protected static class RequiredUnlessPredicate
    extends OtherKeyPredicate {
        public RequiredUnlessPredicate(String otherKeyName) {
            super(otherKeyName);
        }

        @Override
        public String predicateName() {
            return "requiredUnless";
        }

        @Override
        public boolean test(Object thisValue, Object otherValue) {
            return thisValue != null || otherValue != null;
        }
    }

    protected static class RequiredIfPredicate
    extends OtherKeyPredicate {
        public RequiredIfPredicate(String otherKeyName) {
            super(otherKeyName);
        }

        @Override
        public String predicateName() {
            return "requiredIf";
        }

        @Override
        public boolean test(Object thisValue, Object otherValue) {
            return thisValue != null || otherValue == null;
        }
    }

    protected static class ForbiddenUnlessPredicate
    extends OtherKeyPredicate {
        public ForbiddenUnlessPredicate(String otherKeyName) {
            super(otherKeyName);
        }

        @Override
        public String predicateName() {
            return "forbiddenUnless";
        }

        @Override
        public boolean test(Object thisValue, Object otherValue) {
            return thisValue == null || otherValue != null;
        }
    }

    protected static class ForbiddenIfPredicate
    extends OtherKeyPredicate {
        public ForbiddenIfPredicate(String otherKeyName) {
            super(otherKeyName);
        }

        @Override
        public String predicateName() {
            return "forbiddenIf";
        }

        @Override
        public boolean test(Object thisValue, Object otherValue) {
            return thisValue == null || otherValue == null;
        }
    }

    private static abstract class OtherKeysPredicate
    implements BrooklynObjectPredicate<Object> {
        private final List<String> otherKeyNames;

        public OtherKeysPredicate(List<String> otherKeyNames) {
            this.otherKeyNames = otherKeyNames;
        }

        public abstract String predicateName();

        public String toString() {
            String params = this.otherKeyNames.stream().map(k -> StringEscapes.JavaStringEscapes.wrapJavaString((String)k)).collect(Collectors.joining(", "));
            return this.predicateName() + "(" + params + ")";
        }

        public boolean apply(Object input) {
            return this.apply(input, (BrooklynObject)BrooklynTaskTags.getContextEntity(Tasks.current()));
        }

        @Override
        public boolean apply(Object input, BrooklynObject context) {
            if (context == null) {
                return true;
            }
            ArrayList<Object> vals = new ArrayList<Object>();
            for (String otherKeyName : this.otherKeyNames) {
                ConfigKey<Object> otherKey = ConfigKeys.newConfigKey(Object.class, otherKeyName);
                BrooklynObjectInternal.ConfigurationSupportInternal configInternal = ((BrooklynObjectInternal)context).config();
                Maybe<Object> maybeValue = configInternal.getNonBlocking(otherKey);
                if (maybeValue.isPresent()) {
                    vals.add(maybeValue.get());
                    continue;
                }
                return true;
            }
            return this.test(input, vals);
        }

        public abstract boolean test(Object var1, List<Object> var2);
    }

    private static abstract class OtherKeyPredicate
    extends OtherKeysPredicate {
        public OtherKeyPredicate(String otherKeyName) {
            super((List<String>)ImmutableList.of((Object)otherKeyName));
        }

        @Override
        public boolean test(Object thisValue, List<Object> otherValues) {
            return this.test(thisValue, Iterables.getOnlyElement(otherValues));
        }

        public abstract boolean test(Object var1, Object var2);
    }

    public static class RequiredPredicate<T>
    implements Predicate<T> {
        public boolean apply(T input) {
            if (input == null) {
                return false;
            }
            return !(input instanceof CharSequence) || ((CharSequence)input).length() != 0;
        }

        public String toString() {
            return "required()";
        }

        public boolean equals(Object obj) {
            return obj instanceof RequiredPredicate && obj.getClass().equals(this.getClass());
        }

        public int hashCode() {
            return Objects.hash(this.toString());
        }
    }

    private static class LocationConfigConstraints
    extends ConfigConstraints<Location> {
        public LocationConfigConstraints(Location brooklynObject) {
            super(brooklynObject);
        }

        @Override
        Iterable<ConfigKey<?>> getBrooklynObjectTypeConfigKeys() {
            return Collections.emptyList();
        }
    }

    private static class EntityAdjunctConstraints
    extends ConfigConstraints<EntityAdjunct> {
        public EntityAdjunctConstraints(EntityAdjunct brooklynObject) {
            super(brooklynObject);
        }

        @Override
        Iterable<ConfigKey<?>> getBrooklynObjectTypeConfigKeys() {
            return ((AbstractEntityAdjunct)this.getBrooklynObject()).getAdjunctType().getConfigKeys();
        }
    }

    private static class EntityConfigConstraints
    extends ConfigConstraints<Entity> {
        public EntityConfigConstraints(Entity brooklynObject) {
            super(brooklynObject);
        }

        @Override
        Iterable<ConfigKey<?>> getBrooklynObjectTypeConfigKeys() {
            return ((Entity)this.getBrooklynObject()).getEntityType().getConfigKeys();
        }
    }
}

