/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector.ssh;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.ConfigPredicates;
import org.apache.brooklyn.core.config.ConfigUtils;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.SshFetchTaskFactory;
import org.apache.brooklyn.util.core.task.ssh.SshFetchTaskWrapper;
import org.apache.brooklyn.util.core.task.ssh.SshPutTaskFactory;
import org.apache.brooklyn.util.core.task.ssh.SshPutTaskWrapper;
import org.apache.brooklyn.util.core.task.ssh.internal.AbstractSshExecTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskStub;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SshEffectorTasks {
    private static final Logger log = LoggerFactory.getLogger(SshEffectorTasks.class);
    public static final ConfigKey<Boolean> IGNORE_ENTITY_SSH_FLAGS = ConfigKeys.newBooleanConfigKey("ignoreEntitySshFlags", "Whether to ignore any ssh flags (behaviour constraints) set on the entity or location where this is running, using only flags explicitly specified", false);

    public static SshEffectorTaskFactory<Integer> ssh(SshMachineLocation machine, String ... commands) {
        return new SshEffectorTaskFactory<Integer>(machine, commands);
    }

    public static SshEffectorTaskFactory<Integer> ssh(String ... commands) {
        return new SshEffectorTaskFactory<Integer>(commands);
    }

    public static SshEffectorTaskFactory<Integer> ssh(List<String> commands) {
        return SshEffectorTasks.ssh(commands.toArray(new String[commands.size()]));
    }

    public static SshPutTaskFactory put(String remoteFile) {
        return new SshPutEffectorTaskFactory(remoteFile);
    }

    public static SshFetchEffectorTaskFactory fetch(String remoteFile) {
        return new SshFetchEffectorTaskFactory(remoteFile);
    }

    public static SshEffectorTaskFactory<Integer> codePidRunning(Integer pid) {
        return (SshEffectorTaskFactory)((SshEffectorTaskFactory)SshEffectorTasks.ssh("ps -p " + pid).summary("PID " + pid + " is-running check (exit code)")).allowingNonZeroExitCode();
    }

    public static SshEffectorTaskFactory<?> requirePidRunning(Integer pid) {
        return (SshEffectorTaskFactory)((SshEffectorTaskFactory)SshEffectorTasks.codePidRunning(pid).summary("PID " + pid + " is-running check (required)")).requiringExitCodeZero("Process with PID " + pid + " is required to be running");
    }

    public static SshEffectorTaskFactory<Boolean> isPidRunning(Integer pid) {
        return ((SshEffectorTaskFactory)SshEffectorTasks.codePidRunning(pid).summary("PID " + pid + " is-running check (boolean)")).returning(new Function<ProcessTaskWrapper<?>, Boolean>(){

            public Boolean apply(@Nullable ProcessTaskWrapper<?> input) {
                return Integer.valueOf(0).equals(input.getExitCode());
            }
        });
    }

    public static SshEffectorTaskFactory<Integer> codePidFromFileRunning(final String pidFile) {
        return (SshEffectorTaskFactory)((SshEffectorTaskFactory)((SshEffectorTaskFactory)SshEffectorTasks.ssh(BashCommands.chain((String[])new String[]{BashCommands.requireTest((String)("-f " + pidFile), (String)("The PID file " + pidFile + " does not exist.")), BashCommands.requireTest((String)("`ls " + pidFile + " | wc -w` -eq 1"), (String)"ERROR: there are multiple matching PID files"), BashCommands.require((String)("cat " + pidFile), (String)("ERROR: the PID file " + pidFile + " cannot be read (permissions?).")), "ps -p `cat " + pidFile + "`"})).summary("PID file " + pidFile + " is-running check (exit code)")).allowingNonZeroExitCode()).addCompletionListener(new Function<ProcessTaskWrapper<?>, Void>(){

            public Void apply(ProcessTaskWrapper<?> input) {
                if (input.getStderr().contains("ERROR:")) {
                    throw new IllegalStateException("Invalid or inaccessible PID filespec: " + pidFile);
                }
                return null;
            }
        });
    }

    public static SshEffectorTaskFactory<?> requirePidFromFileRunning(String pidFile) {
        return (SshEffectorTaskFactory)((SshEffectorTaskFactory)SshEffectorTasks.codePidFromFileRunning(pidFile).summary("PID file " + pidFile + " is-running check (required)")).requiringExitCodeZero("Process with PID from file " + pidFile + " is required to be running");
    }

    public static SshEffectorTaskFactory<Boolean> isPidFromFileRunning(String pidFile) {
        return ((SshEffectorTaskFactory)SshEffectorTasks.codePidFromFileRunning(pidFile).summary("PID file " + pidFile + " is-running check (boolean)")).returning(new Function<ProcessTaskWrapper<?>, Boolean>(){

            public Boolean apply(@Nullable ProcessTaskWrapper<?> input) {
                return Integer.valueOf(0).equals(input.getExitCode());
            }
        });
    }

    @Beta
    public static Map<String, Object> getSshFlags(Entity entity, Location optionalLocation) {
        MutableSet sshConfig = MutableSet.of();
        sshConfig.addAll(((EntityInternal)entity).config().findKeysPresent(ConfigPredicates.nameStartsWith("brooklyn.ssh.config.")));
        if (optionalLocation != null) {
            sshConfig.addAll(optionalLocation.config().findKeysPresent(ConfigPredicates.nameStartsWith("brooklyn.ssh.config.")));
        }
        StringConfigMap globalConfig = ((EntityInternal)entity).getManagementContext().getConfig();
        sshConfig.addAll(globalConfig.findKeysDeclared(ConfigPredicates.nameStartsWith("brooklyn.ssh.config.")));
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (ConfigKey key : sshConfig) {
            Maybe<Object> mv = ((EntityInternal)entity).config().getRaw(key);
            Object v = null;
            if (v == null && mv.isPresent()) {
                v = entity.config().get(key);
            }
            if (mv.isAbsent() && optionalLocation != null) {
                mv = ((LocationInternal)optionalLocation).config().getRaw(key);
            }
            if (v == null && mv.isPresent()) {
                v = optionalLocation.config().get(key);
            }
            if (mv.isAbsent()) {
                v = globalConfig.getConfig(key);
            }
            result.put(ConfigUtils.unprefixedKey("brooklyn.ssh.config.", key).getName(), v);
        }
        return result;
    }

    private static void applySshFlags(ConfigBag config, Entity entity, Location machine) {
        if (entity != null && !config.get(IGNORE_ENTITY_SSH_FLAGS).booleanValue()) {
            config.putIfAbsent(SshEffectorTasks.getSshFlags(entity, machine));
        }
    }

    public static class SshFetchEffectorTaskFactory
    extends SshFetchTaskFactory
    implements EffectorTasks.EffectorTaskFactory<String> {
        public SshFetchEffectorTaskFactory(String remoteFile) {
            super(remoteFile);
        }

        public SshFetchEffectorTaskFactory(SshMachineLocation machine, String remoteFile) {
            super(machine, remoteFile);
        }

        public SshFetchTaskWrapper newTask(Entity entity, Effector<String> effector, ConfigBag parameters) {
            this.machine(EffectorTasks.getSshMachine(entity));
            SshEffectorTasks.applySshFlags(this.getConfig(), entity, this.getMachine());
            return super.newTask();
        }

        @Override
        public SshFetchTaskWrapper newTask() {
            Entity entity = BrooklynTaskTags.getTargetOrContextEntity(Tasks.current());
            if (this.machine == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Using an ssh fetch task not in an effector without any machine; will attempt to infer the machine: " + this);
                }
                if (entity != null) {
                    this.machine(EffectorTasks.getSshMachine(entity));
                }
            }
            SshEffectorTasks.applySshFlags(this.getConfig(), entity, this.getMachine());
            return super.newTask();
        }
    }

    public static class SshPutEffectorTaskFactory
    extends SshPutTaskFactory
    implements EffectorTasks.EffectorTaskFactory<Void> {
        public SshPutEffectorTaskFactory(String remoteFile) {
            super(remoteFile);
        }

        public SshPutEffectorTaskFactory(SshMachineLocation machine, String remoteFile) {
            super(machine, remoteFile);
        }

        public SshPutTaskWrapper newTask(Entity entity, Effector<Void> effector, ConfigBag parameters) {
            this.machine(EffectorTasks.getSshMachine(entity));
            SshEffectorTasks.applySshFlags(this.getConfig(), entity, this.getMachine());
            return super.newTask();
        }

        @Override
        public SshPutTaskWrapper newTask() {
            Entity entity = BrooklynTaskTags.getTargetOrContextEntity(Tasks.current());
            if (this.machine == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Using an ssh put task not in an effector without any machine; will attempt to infer the machine: " + this);
                }
                if (entity != null) {
                    this.machine(EffectorTasks.getSshMachine(entity));
                }
            }
            SshEffectorTasks.applySshFlags(this.getConfig(), entity, this.getMachine());
            return super.newTask();
        }
    }

    public static class SshEffectorTaskFactory<RET>
    extends AbstractSshExecTaskFactory<SshEffectorTaskFactory<RET>, RET>
    implements EffectorTasks.EffectorTaskFactory<RET> {
        public SshEffectorTaskFactory(String ... commands) {
            super(commands);
        }

        public SshEffectorTaskFactory(SshMachineLocation machine, String ... commands) {
            super(machine, commands);
        }

        @Override
        public ProcessTaskWrapper<RET> newTask(Entity entity, Effector<RET> effector, ConfigBag parameters) {
            this.markDirty();
            if (this.summary == null) {
                this.summary(effector.getName() + " (ssh)");
            }
            this.machine(EffectorTasks.getSshMachine(entity));
            return this.newTask();
        }

        @Override
        public synchronized ProcessTaskWrapper<RET> newTask() {
            Entity entity = BrooklynTaskTags.getTargetOrContextEntity(Tasks.current());
            if (this.machine == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Using an ssh task not in an effector without any machine; will attempt to infer the machine: " + this);
                }
                if (entity != null) {
                    this.machine(EffectorTasks.getSshMachine(entity));
                }
            }
            SshEffectorTasks.applySshFlags(this.getConfig(), entity, this.getMachine());
            return super.newTask();
        }

        @Override
        public <T2> SshEffectorTaskFactory<T2> returning(ProcessTaskStub.ScriptReturnType type) {
            return (SshEffectorTaskFactory)super.returning(type);
        }

        public SshEffectorTaskFactory<Boolean> returningIsExitCodeZero() {
            return (SshEffectorTaskFactory)super.returningIsExitCodeZero();
        }

        public SshEffectorTaskFactory<String> requiringZeroAndReturningStdout() {
            return (SshEffectorTaskFactory)super.requiringZeroAndReturningStdout();
        }

        @Override
        public <RET2> SshEffectorTaskFactory<RET2> returning(Function<ProcessTaskWrapper<?>, RET2> resultTransformation) {
            return (SshEffectorTaskFactory)super.returning(resultTransformation);
        }
    }

    public static abstract class SshEffectorBody<T>
    extends EffectorBody<T> {
        public SshMachineLocation machine() {
            return EffectorTasks.getSshMachine((Entity)this.entity());
        }

        public ProcessTaskFactory<Integer> ssh(String ... commands) {
            return new SshEffectorTaskFactory(commands).machine(this.machine());
        }
    }
}

