/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity.trait;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartableMethods {
    public static final Logger log = LoggerFactory.getLogger(StartableMethods.class);

    private StartableMethods() {
    }

    public static void start(Entity e, Collection<? extends Location> locations) {
        log.debug("Starting entity " + e + " at " + locations);
        DynamicTasks.get(StartableMethods.startingChildren(e, locations), e);
    }

    public static void stop(Entity e) {
        log.debug("Stopping entity " + e);
        DynamicTasks.get(StartableMethods.stoppingChildren(e), e);
        if (log.isDebugEnabled()) {
            log.debug("Stopped entity " + e);
        }
    }

    public static void restart(Entity e) {
        log.debug("Restarting entity " + e);
        DynamicTasks.get(StartableMethods.restartingChildren(e), e);
        if (log.isDebugEnabled()) {
            log.debug("Restarted entity " + e);
        }
    }

    private static <T extends Entity> Iterable<T> filterStartableManagedEntities(Iterable<T> contenders) {
        return Iterables.filter(contenders, (Predicate)Predicates.and((Predicate)Predicates.instanceOf(Startable.class), EntityPredicates.isManaged()));
    }

    public static void stopSequentially(Iterable<? extends Startable> entities) {
        ArrayList exceptions = Lists.newArrayList();
        ArrayList failedEntities = Lists.newArrayList();
        for (Startable startable : entities) {
            if (!Entities.isManaged((Entity)startable)) {
                log.debug("Not stopping {} because it is not managed; continuing", (Object)startable);
                continue;
            }
            try {
                TaskAdaptable<Void> task = TaskTags.markInessential(Effectors.invocation((Entity)startable, Startable.STOP, Collections.emptyMap()));
                DynamicTasks.submit(task, (Entity)startable).getUnchecked();
            }
            catch (Exception e) {
                log.warn("Error stopping " + startable + "; continuing with shutdown", (Throwable)e);
                exceptions.add(e);
                failedEntities.add(startable);
            }
        }
        if (exceptions.size() > 0) {
            throw new CompoundRuntimeException("Error stopping " + (failedEntities.size() > 1 ? "entities" : "entity") + ": " + failedEntities, (Iterable)exceptions);
        }
    }

    public static TaskAdaptable<?> startingChildren(Entity entity) {
        return StartableMethods.startingChildren(entity, entity.getLocations());
    }

    public static TaskAdaptable<?> startingChildren(Entity entity, Location location) {
        return StartableMethods.startingChildren(entity, Collections.singleton(location));
    }

    public static TaskAdaptable<?> startingChildren(Entity entity, Iterable<? extends Location> locations) {
        return Effectors.invocation(Startable.START, MutableMap.of((Object)"locations", locations), StartableMethods.filterStartableManagedEntities(entity.getChildren()));
    }

    public static TaskAdaptable<?> stoppingChildren(Entity entity) {
        return Effectors.invocation(Startable.STOP, Collections.emptyMap(), StartableMethods.filterStartableManagedEntities(entity.getChildren()));
    }

    public static TaskAdaptable<?> restartingChildren(Entity entity, ConfigBag parameters) {
        return Effectors.invocation(Startable.RESTART, parameters.getAllConfig(), StartableMethods.filterStartableManagedEntities(entity.getChildren()));
    }

    public static TaskAdaptable<?> restartingChildren(Entity entity) {
        return StartableMethods.restartingChildren(entity, ConfigBag.EMPTY);
    }
}

