/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateIPForwardingRuleOptions;
import org.jclouds.cloudstack.options.ListIPForwardingRulesOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface NATApi {
    @Named(value="listIpForwardingRules")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listIpForwardingRules", "true"})
    @SelectJson(value={"ipforwardingrule"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<IPForwardingRule> listIPForwardingRules(ListIPForwardingRulesOptions ... var1);

    @Named(value="listIpForwardingRules")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listIpForwardingRules", "true"})
    @SelectJson(value={"ipforwardingrule"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public IPForwardingRule getIPForwardingRule(@QueryParam(value="id") String var1);

    @Named(value="listIpForwardingRules")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listIpForwardingRules", "true"})
    @SelectJson(value={"ipforwardingrule"})
    @Consumes(value={"application/json"})
    public Set<IPForwardingRule> getIPForwardingRulesForIPAddress(@QueryParam(value="ipaddressid") String var1);

    @Named(value="listIpForwardingRules")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listIpForwardingRules", "true"})
    @SelectJson(value={"ipforwardingrule"})
    @Consumes(value={"application/json"})
    public Set<IPForwardingRule> getIPForwardingRulesForVirtualMachine(@QueryParam(value="virtualmachineid") String var1);

    @Named(value="createIpForwardingRule")
    @GET
    @QueryParams(keys={"command"}, values={"createIpForwardingRule"})
    @Unwrap
    @Consumes(value={"application/json"})
    public AsyncCreateResponse createIPForwardingRule(@QueryParam(value="ipaddressid") String var1, @QueryParam(value="protocol") String var2, @QueryParam(value="startport") int var3, CreateIPForwardingRuleOptions ... var4);

    @Named(value="enableStaticNat")
    @GET
    @QueryParams(keys={"command"}, values={"enableStaticNat"})
    @Consumes(value={"application/json"})
    public void enableStaticNATForVirtualMachine(@QueryParam(value="virtualmachineid") String var1, @QueryParam(value="ipaddressid") String var2);

    @Named(value="deleteIpForwardingRule")
    @GET
    @QueryParams(keys={"command"}, values={"deleteIpForwardingRule"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public String deleteIPForwardingRule(@QueryParam(value="id") String var1);

    @Named(value="disableStaticNat")
    @GET
    @QueryParams(keys={"command"}, values={"disableStaticNat"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public String disableStaticNATOnPublicIP(@QueryParam(value="ipaddressid") String var1);
}

