/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.archive;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.xbean.finder.archive.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveIterator
implements Iterator<Archive.Entry> {
    private final Iterator<String> classes;
    private final Archive archive;

    public ArchiveIterator(Archive archive, Iterator<String> classes) {
        this.archive = archive;
        this.classes = classes;
    }

    @Override
    public boolean hasNext() {
        return this.classes.hasNext();
    }

    @Override
    public Archive.Entry next() {
        final String name = this.classes.next();
        return new Archive.Entry(){

            public String getName() {
                return name;
            }

            public InputStream getBytecode() throws IOException {
                try {
                    return ArchiveIterator.this.archive.getBytecode(name);
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    @Override
    public void remove() {
        this.classes.remove();
    }
}

