/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.binders.DiskCreationBinder;
import org.jclouds.googlecomputeengine.domain.Disk;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.internal.BaseCallerArg0ToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.DiskCreationOptions;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/disks")
@Consumes(value={"application/json"})
public interface DiskApi {
    @Named(value="Disks:get")
    @GET
    @Path(value="/{disk}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Disk get(@PathParam(value="disk") String var1);

    @Named(value="Disks:insert")
    @POST
    @Produces(value={"application/json"})
    @MapBinder(value=DiskCreationBinder.class)
    public Operation create(@PayloadParam(value="name") String var1, @PayloadParam(value="options") DiskCreationOptions var2);

    @Named(value="Disks:insert")
    @POST
    @Produces(value={"application/json"})
    @MapBinder(value=DiskCreationBinder.class)
    public Operation create(@PayloadParam(value="name") String var1, @QueryParam(value="sourceImage") String var2, @PayloadParam(value="options") DiskCreationOptions var3);

    @Named(value="Disks:delete")
    @DELETE
    @Path(value="/{disk}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation delete(@PathParam(value="disk") String var1);

    @Named(value="Disks:createSnapshot")
    @POST
    @Path(value="/{disk}/createSnapshot")
    @MapBinder(value=BindToJsonPayload.class)
    public Operation createSnapshot(@PathParam(value="disk") String var1, @PayloadParam(value="name") String var2);

    @Named(value="Disks:createSnapshot")
    @POST
    @Path(value="/{disk}/createSnapshot")
    @MapBinder(value=BindToJsonPayload.class)
    public Operation createSnapshot(@PathParam(value="disk") String var1, @PayloadParam(value="name") String var2, @PayloadParam(value="description") String var3);

    @Named(value="Disks:list")
    @GET
    public ListPage<Disk> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Disks:list")
    @GET
    @Transform(value=DiskPages.class)
    public Iterator<ListPage<Disk>> list();

    @Named(value="Disks:list")
    @GET
    @Transform(value=DiskPages.class)
    public Iterator<ListPage<Disk>> list(ListOptions var1);

    public static final class DiskPages
    extends BaseCallerArg0ToIteratorOfListPage<Disk, DiskPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        DiskPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<Disk>> fetchNextPage(final String zoneName, final ListOptions options) {
            return new Function<String, ListPage<Disk>>(){

                public ListPage<Disk> apply(String pageToken) {
                    return DiskPages.this.api.disksInZone(zoneName).listPage(pageToken, options);
                }
            };
        }
    }
}

