/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.inject.ImplementedBy;
import javax.inject.Inject;
import org.jclouds.docker.compute.functions.CustomLoginPortFromImage;
import org.jclouds.docker.compute.functions.PublicPortForContainerPort;
import org.jclouds.docker.domain.Container;

@ImplementedBy(value=LoginPortLookupChain.class)
@Beta
public interface LoginPortForContainer
extends Function<Container, Optional<Integer>> {

    @Beta
    public static final class LoginPortLookupChain
    implements LoginPortForContainer {
        private final PublicPortForContainerPort publicPortForContainerPort = new PublicPortForContainerPort(22);
        private final CustomLoginPortFromImage customLoginPortFromImage;

        @Inject
        LoginPortLookupChain(CustomLoginPortFromImage customLoginPortFromImage) {
            this.customLoginPortFromImage = customLoginPortFromImage;
        }

        public Optional<Integer> apply(Container input) {
            Optional<Integer> loginPort = this.publicPortForContainerPort.apply(input);
            return loginPort.isPresent() ? loginPort : this.customLoginPortFromImage.apply(input);
        }
    }
}

