/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.features;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.packet.PacketApi;
import org.jclouds.packet.domain.Href;
import org.jclouds.packet.domain.Project;
import org.jclouds.packet.domain.internal.PaginatedCollection;
import org.jclouds.packet.domain.options.ListOptions;
import org.jclouds.packet.filters.AddApiVersionToRequest;
import org.jclouds.packet.filters.AddXAuthTokenToRequest;
import org.jclouds.packet.functions.BaseToPagedIterable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;

@Path(value="/projects")
@Consumes(value={"application/json"})
@RequestFilters(value={AddXAuthTokenToRequest.class, AddApiVersionToRequest.class})
public interface ProjectApi {
    @Named(value="project:list")
    @GET
    @ResponseParser(value=ParseProjects.class)
    @Transform(value=ParseProjects.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Project> list();

    @Named(value="project:list")
    @GET
    @ResponseParser(value=ParseProjects.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Project> list(ListOptions var1);

    public static final class ParseProjects
    extends ParseJson<Projects> {
        @Inject
        ParseProjects(Json json) {
            super(json, TypeLiteral.get(Projects.class));
        }

        private static class ToPagedIterable
        extends BaseToPagedIterable<Project, ListOptions> {
            @Inject
            ToPagedIterable(PacketApi api, Function<Href, ListOptions> hrefToOptions) {
                super(api, hrefToOptions);
            }

            @Override
            protected IterableWithMarker<Project> fetchPageUsingOptions(ListOptions options, Optional<Object> arg0) {
                return this.api.projectApi().list(options);
            }
        }

        private static class Projects
        extends PaginatedCollection<Project> {
            @ConstructorProperties(value={"projects", "meta"})
            public Projects(List<Project> items, PaginatedCollection.Meta meta) {
                super(items, meta);
            }
        }
    }
}

