/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.generator.bean.field;

import com.sun.tools.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.xjc.generator.bean.field.FieldRenderer;
import com.sun.tools.xjc.generator.bean.field.FieldRendererFactory;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.outline.FieldOutline;
import java.io.Serializable;
import java.util.ArrayList;

final class DefaultFieldRenderer
implements FieldRenderer {
    private final FieldRendererFactory frf;
    private FieldRenderer defaultCollectionFieldRenderer;

    DefaultFieldRenderer(FieldRendererFactory frf) {
        this.frf = frf;
    }

    public DefaultFieldRenderer(FieldRendererFactory frf, FieldRenderer defaultCollectionFieldRenderer) {
        this.frf = frf;
        this.defaultCollectionFieldRenderer = defaultCollectionFieldRenderer;
    }

    @Override
    public FieldOutline generate(ClassOutlineImpl outline, CPropertyInfo prop) {
        return this.decideRenderer(outline, prop).generate(outline, prop);
    }

    private FieldRenderer decideRenderer(ClassOutlineImpl outline, CPropertyInfo prop) {
        if (prop instanceof CReferencePropertyInfo) {
            CReferencePropertyInfo p = (CReferencePropertyInfo)prop;
            if (p.isDummy()) {
                return this.frf.getDummyList(outline.parent().getCodeModel().ref(ArrayList.class));
            }
            if (p.isContent() && p.isMixedExtendedCust()) {
                return this.frf.getContentList(outline.parent().getCodeModel().ref(ArrayList.class).narrow(Serializable.class));
            }
        }
        if (!prop.isCollection()) {
            if (prop.isUnboxable()) {
                return this.frf.getRequiredUnboxed();
            }
            return this.frf.getSingle();
        }
        if (this.defaultCollectionFieldRenderer == null) {
            return this.frf.getList(outline.parent().getCodeModel().ref(ArrayList.class));
        }
        return this.defaultCollectionFieldRenderer;
    }
}

