/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.snapshot;

import java.util.Date;
import org.jclouds.date.DateService;
import org.jclouds.profitbricks.domain.Location;
import org.jclouds.profitbricks.domain.OsType;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.domain.Snapshot;
import org.jclouds.profitbricks.http.parser.BaseProfitBricksResponseHandler;

public abstract class BaseSnapshotResponseHandler<T>
extends BaseProfitBricksResponseHandler<T> {
    protected Snapshot.Builder builder;
    protected final DateService dateService;

    BaseSnapshotResponseHandler(DateService dateService) {
        this.dateService = dateService;
        this.builder = Snapshot.builder();
    }

    protected final Date textToIso8601Date() {
        return this.dateService.iso8601DateOrSecondsDateParse(this.textToStringValue());
    }

    @Override
    protected void setPropertyOnEndTag(String qName) {
        if ("snapshotId".equals(qName)) {
            this.builder.id(this.textToStringValue());
        } else if ("snapshotName".equals(qName)) {
            this.builder.name(this.textToStringValue());
        } else if ("snapshotSize".equals(qName)) {
            this.builder.size(this.textToFloatValue());
        } else if ("osType".equals(qName)) {
            this.builder.osType(OsType.fromValue(this.textToStringValue()));
        } else if ("location".equals(qName)) {
            this.builder.location(Location.fromId(this.textToStringValue()));
        } else if ("description".equals(qName)) {
            this.builder.description(qName);
        } else if ("bootable".equals(qName)) {
            this.builder.isBootable(this.textToBooleanValue());
        } else if ("cpuHotPlug".equals(qName)) {
            this.builder.isCpuHotPlug(this.textToBooleanValue());
        } else if ("cpuHotUnPlug".equals(qName)) {
            this.builder.isCpuHotUnPlug(this.textToBooleanValue());
        } else if ("ramHotPlug".equals(qName)) {
            this.builder.isRamHotPlug(this.textToBooleanValue());
        } else if ("ramHotUnPlug".equals(qName)) {
            this.builder.isRamHotUnPlug(this.textToBooleanValue());
        } else if ("nicHotPlug".equals(qName)) {
            this.builder.isNicHotPlug(this.textToBooleanValue());
        } else if ("nicHotUnPlug".equals(qName)) {
            this.builder.isNicHotUnPlug(this.textToBooleanValue());
        } else if ("discVirtioHotPlug".equals(qName)) {
            this.builder.isDiscVirtioHotPlug(this.textToBooleanValue());
        } else if ("discVirtioHotUnPlug".equals(qName)) {
            this.builder.isDiscVirtioHotUnPlug(this.textToBooleanValue());
        } else if ("provisioningState".equals(qName)) {
            this.builder.state(ProvisioningState.fromValue(this.textToStringValue()));
        } else if ("creationTimestamp".equals(qName)) {
            this.builder.creationTime(this.textToIso8601Date());
        } else if ("modificationTimestamp".equals(qName)) {
            this.builder.lastModificationTime(this.textToIso8601Date());
        }
    }
}

