/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.enricher;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.rebind.RebindSupport;
import org.apache.brooklyn.api.mgmt.rebind.mementos.EnricherMemento;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherType;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.EnricherDynamicType;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.rebind.BasicEnricherRebindSupport;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.Maybe;

public abstract class AbstractEnricher
extends AbstractEntityAdjunct
implements Enricher {
    public static final ConfigKey<Boolean> SUPPRESS_DUPLICATES = ConfigKeys.newBooleanConfigKey("enricher.suppressDuplicates", "Whether duplicate values published by this enricher should be suppressed");
    private final EnricherDynamicType enricherType = new EnricherDynamicType(this);
    protected Boolean suppressDuplicates;

    public AbstractEnricher() {
        this(Maps.newLinkedHashMap());
    }

    public AbstractEnricher(Map<?, ?> flags) {
        super((Map)flags);
        if (this.isLegacyConstruction() && !this.isLegacyNoConstructionInit()) {
            this.init();
        }
    }

    public RebindSupport<EnricherMemento> getRebindSupport() {
        return new BasicEnricherRebindSupport(this);
    }

    @Override
    public BrooklynObjectInternal.RelationSupportInternal<Enricher> relations() {
        return super.relations();
    }

    public EnricherType getEnricherType() {
        return this.enricherType.getSnapshot();
    }

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        Boolean suppressDuplicates = this.getConfig(SUPPRESS_DUPLICATES);
        if (suppressDuplicates != null) {
            this.suppressDuplicates = suppressDuplicates;
        }
    }

    @Override
    protected void onChanged() {
        this.requestPersist();
    }

    protected <T> void emit(Sensor<T> sensor, Object val) {
        Preconditions.checkState((this.entity != null ? 1 : 0) != 0, (Object)"entity must first be set");
        if (val == Entities.UNCHANGED) {
            return;
        }
        if (val == Entities.REMOVE) {
            ((EntityInternal)this.entity).sensors().remove((AttributeSensor)sensor);
            return;
        }
        Object newVal = TypeCoercions.coerce(val, sensor.getTypeToken());
        Maybe published = Maybe.of(newVal);
        if (sensor instanceof AttributeSensor) {
            AttributeSensor attribute = (AttributeSensor)sensor;
            if (Boolean.TRUE.equals(this.suppressDuplicates)) {
                DeduplicatingAttributeModifier modifier = DeduplicatingAttributeModifier.create(newVal);
                this.entity.sensors().modify(attribute, modifier);
                published = modifier.getLastValue();
            } else {
                this.entity.sensors().set(attribute, newVal);
            }
        } else {
            this.entity.sensors().emit(sensor, newVal);
        }
        if (published != null && published.isPresent()) {
            this.highlightActionPublishSensor(sensor, published.get());
        }
    }

    private static class DeduplicatingAttributeModifier<T>
    implements Function<T, Maybe<T>> {
        private T newValue;
        private Maybe<T> lastValue;

        public static <T> DeduplicatingAttributeModifier<T> create(T newVal) {
            return new DeduplicatingAttributeModifier<T>(newVal);
        }

        private DeduplicatingAttributeModifier(T newVal) {
            this.newValue = newVal;
        }

        public Maybe<T> apply(T oldValue) {
            if (Objects.equal(oldValue, this.newValue)) {
                this.lastValue = Maybe.absent((String)"Skipping update, values equal");
                return this.lastValue;
            }
            this.lastValue = Maybe.of(this.newValue);
            return this.lastValue;
        }

        public Maybe<T> getLastValue() {
            return this.lastValue;
        }
    }
}

