/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity.drivers.downloads;

import com.google.common.base.Function;
import java.util.Map;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolverManager;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.entity.drivers.downloads.BasicDownloadTargets;
import org.apache.brooklyn.core.entity.drivers.downloads.DownloadSubstituters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadProducerFromLocalRepo
implements Function<DownloadResolverManager.DownloadRequirement, DownloadResolverManager.DownloadTargets> {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadProducerFromLocalRepo.class);
    public static final ConfigKey<String> LOCAL_REPO_PATH = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)BasicConfigKey.builder(String.class).name("brooklyn.downloads.repo.local.path")).description("Fully qualified path of the local repo")).defaultValue((String)"$HOME/.brooklyn/repository")).build();
    public static final ConfigKey<Boolean> LOCAL_REPO_ENABLED = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)BasicConfigKey.builder(Boolean.class).name("brooklyn.downloads.repo.local.enabled")).description("Whether to use the local repo for downloading entities, during installs")).defaultValue(true)).build();
    public static final String LOCAL_REPO_URL_PATTERN = "file://%s/${simpletype}/${version}/<#if filename??>${filename}<#else><#if addon??>${simpletype?lower_case}-${addon?lower_case}-${addonversion?lower_case}.${fileSuffix!\"tar.gz\"}<#else>${simpletype?lower_case}-${version?lower_case}.${fileSuffix!\"tar.gz\"}</#if></#if>";
    private final StringConfigMap config;

    public DownloadProducerFromLocalRepo(StringConfigMap config) {
        this.config = config;
    }

    public DownloadResolverManager.DownloadTargets apply(DownloadResolverManager.DownloadRequirement req) {
        Boolean enabled = (Boolean)this.config.getConfig(LOCAL_REPO_ENABLED);
        String path = (String)this.config.getConfig(LOCAL_REPO_PATH);
        String url = String.format(LOCAL_REPO_URL_PATTERN, path);
        if (enabled.booleanValue()) {
            Map<String, Object> subs = DownloadSubstituters.getBasicSubstitutions(req);
            String result = DownloadSubstituters.substitute(url, subs);
            return BasicDownloadTargets.builder().addPrimary(result).build();
        }
        return BasicDownloadTargets.empty();
    }
}

