/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Set;

public enum Region {
    CENTRAL_US("Central US", "US-IA"),
    EAST_US("East US", "US-VA"),
    EAST_US_2("East US 2", "US-VA"),
    US_GOV_IOWA("US Gov Iowa", "US-IA"),
    US_GOV_VIRGINIA("US Gov Virginia", "US-VA"),
    NORTH_CENTRAL_US("North Central US", "US-IL"),
    SOUTH_CENTRAL_US("South Central US", "US-TX"),
    WEST_CENTRAL_US("West Central US", "US-WY"),
    WEST_US("West US", "US-CA"),
    WEST_US_2("West US 2", "US-WA"),
    NORTH_EUROPE("North Europe", "IE"),
    UK_SOUTH("UK South", "GB-LND"),
    UK_WEST("UK West", "GB-CRF"),
    WEST_EUROPE("West Europe", "NL"),
    EAST_ASIA("East Asia", "HK"),
    SOUTH_EAST_ASIA("Southeast Asia", "SG"),
    KOREA_CENTRAL("Korea Central", "KR-11"),
    KOREA_SOUTH("Korea South", "KR-26"),
    JAPAN_EAST("Japan East", "JP-11"),
    JAPAN_WEST("Japan West", "JP-27"),
    BRAZIL_SOUTH("Brazil South", "BR"),
    AUSTRALIA_EAST("Australia East", "AU-NSW"),
    AUSTRALIA_SOUTH_EAST("Australia Southeast", "AU-VIC"),
    AUSTRALIA_CENTRAL("Australia Central", "AU-ACT"),
    AUSTRALIA_CENTRAL_2("Australia Central 2", "AU-ACT"),
    CENTRAL_INDIA("Central India", "IN-GA"),
    SOUTH_INDIA("South India", "IN-TN"),
    WEST_INDIA("West India", "IN-MH"),
    CHINA_EAST("China East", "CN-SH"),
    CHINA_EAST_2("China East 2", "CN-SH"),
    CHINA_NORTH("China North", "CN-BJ"),
    CHINA_NORTH_2("China North 2", "CN-BJ"),
    CANADA_CENTRAL("Canada Central", "CA-ON"),
    CANADA_EAST("Canada East", "CA-QC"),
    FRANCE_CENTRAL("France Central", "FR-IDF"),
    FRANCE_SOUTH("France South", "FR-PAC");

    private final String name;
    private final String iso3166Code;

    private Region(String name, String iso3166Code) {
        this.name = name;
        this.iso3166Code = iso3166Code;
    }

    public String getName() {
        return this.name;
    }

    public String iso3166Code() {
        return this.iso3166Code;
    }

    public static Region byName(String name) {
        Preconditions.checkNotNull((Object)name);
        for (Region region : Region.values()) {
            if (!name.equals(region.name)) continue;
            return region;
        }
        return null;
    }

    public static Set<String> iso3166Codes() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(Arrays.asList(Region.values()), (Function)new Function<Region, String>(){

            public String apply(Region region) {
                return region.iso3166Code;
            }
        }));
    }
}

