/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.all.JustProvider;
import org.jclouds.packet.domain.Facility;

@Singleton
public class FacilityToLocation
implements Function<Facility, Location> {
    private final JustProvider justProvider;

    @Inject
    FacilityToLocation(JustProvider justProvider) {
        this.justProvider = justProvider;
    }

    public Location apply(Facility facility) {
        LocationBuilder builder = new LocationBuilder();
        builder.id(facility.code());
        builder.description(facility.name());
        builder.parent((Location)Iterables.getOnlyElement((Iterable)this.justProvider.get()));
        builder.scope(LocationScope.REGION);
        return builder.build();
    }
}

