/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.CSIVolumeSource;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CSIVolumeSourceFluent<A extends CSIVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private String driver;
    private String fsType;
    private LocalObjectReferenceBuilder nodePublishSecretRef;
    private Boolean readOnly;
    private Map<String, String> volumeAttributes;
    private Map<String, Object> additionalProperties;

    public CSIVolumeSourceFluent() {
    }

    public CSIVolumeSourceFluent(CSIVolumeSource instance) {
        CSIVolumeSource cSIVolumeSource = instance = instance != null ? instance : new CSIVolumeSource();
        if (instance != null) {
            this.withDriver(instance.getDriver());
            this.withFsType(instance.getFsType());
            this.withNodePublishSecretRef(instance.getNodePublishSecretRef());
            this.withReadOnly(instance.getReadOnly());
            this.withVolumeAttributes(instance.getVolumeAttributes());
            this.withDriver(instance.getDriver());
            this.withFsType(instance.getFsType());
            this.withNodePublishSecretRef(instance.getNodePublishSecretRef());
            this.withReadOnly(instance.getReadOnly());
            this.withVolumeAttributes(instance.getVolumeAttributes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public LocalObjectReference buildNodePublishSecretRef() {
        return this.nodePublishSecretRef != null ? this.nodePublishSecretRef.build() : null;
    }

    public A withNodePublishSecretRef(LocalObjectReference nodePublishSecretRef) {
        this._visitables.get("nodePublishSecretRef").remove(this.nodePublishSecretRef);
        if (nodePublishSecretRef != null) {
            this.nodePublishSecretRef = new LocalObjectReferenceBuilder(nodePublishSecretRef);
            this._visitables.get("nodePublishSecretRef").add(this.nodePublishSecretRef);
        } else {
            this.nodePublishSecretRef = null;
            this._visitables.get("nodePublishSecretRef").remove(this.nodePublishSecretRef);
        }
        return (A)this;
    }

    public boolean hasNodePublishSecretRef() {
        return this.nodePublishSecretRef != null;
    }

    public A withNewNodePublishSecretRef(String name) {
        return this.withNodePublishSecretRef(new LocalObjectReference(name));
    }

    public NodePublishSecretRefNested<A> withNewNodePublishSecretRef() {
        return new NodePublishSecretRefNested(null);
    }

    public NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(LocalObjectReference item) {
        return new NodePublishSecretRefNested(item);
    }

    public NodePublishSecretRefNested<A> editNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(Optional.ofNullable(this.buildNodePublishSecretRef()).orElse(null));
    }

    public NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(Optional.ofNullable(this.buildNodePublishSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(LocalObjectReference item) {
        return this.withNewNodePublishSecretRefLike(Optional.ofNullable(this.buildNodePublishSecretRef()).orElse(item));
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public A addToVolumeAttributes(String key, String value) {
        if (this.volumeAttributes == null && key != null && value != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.volumeAttributes.put(key, value);
        }
        return (A)this;
    }

    public A addToVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null && map != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.volumeAttributes.putAll(map);
        }
        return (A)this;
    }

    public A removeFromVolumeAttributes(String key) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (key != null && this.volumeAttributes != null) {
            this.volumeAttributes.remove(key);
        }
        return (A)this;
    }

    public A removeFromVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.volumeAttributes == null) continue;
                this.volumeAttributes.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    public <K, V> A withVolumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes == null ? null : new LinkedHashMap<String, String>(volumeAttributes);
        return (A)this;
    }

    public boolean hasVolumeAttributes() {
        return this.volumeAttributes != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSIVolumeSourceFluent that = (CSIVolumeSourceFluent)o;
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.nodePublishSecretRef, that.nodePublishSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.volumeAttributes, that.volumeAttributes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.driver, this.fsType, this.nodePublishSecretRef, this.readOnly, this.volumeAttributes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.nodePublishSecretRef != null) {
            sb.append("nodePublishSecretRef:");
            sb.append(this.nodePublishSecretRef + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.volumeAttributes != null && !this.volumeAttributes.isEmpty()) {
            sb.append("volumeAttributes:");
            sb.append(this.volumeAttributes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public class NodePublishSecretRefNested<N>
    extends LocalObjectReferenceFluent<NodePublishSecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        NodePublishSecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSIVolumeSourceFluent.this.withNodePublishSecretRef(this.builder.build());
        }

        public N endNodePublishSecretRef() {
            return this.and();
        }
    }
}

