/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.brooklynnode;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.core.entity.EntityFunctions;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.brooklynnode.BrooklynCluster;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNode;
import org.apache.brooklyn.entity.brooklynnode.effector.BrooklynClusterUpgradeEffectorBody;
import org.apache.brooklyn.entity.brooklynnode.effector.SelectMasterEffectorBody;
import org.apache.brooklyn.entity.group.DynamicClusterImpl;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynClusterImpl
extends DynamicClusterImpl
implements BrooklynCluster {
    private static final String MSG_NO_MASTER = "No master node in cluster";
    private static final String MSG_TOO_MANY_MASTERS = "Too many master nodes in cluster";
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynClusterImpl.class);

    public void init() {
        super.init();
        this.getMutableEntityType().addEffector(SelectMasterEffectorBody.SELECT_MASTER);
        this.getMutableEntityType().addEffector(BrooklynClusterUpgradeEffectorBody.UPGRADE_CLUSTER);
        ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((Entity)this, (Sensor)MASTER_NODE, (Object)MSG_NO_MASTER);
        FunctionFeed.builder().entity((Entity)this).poll(((FunctionPollConfig)new FunctionPollConfig(MASTER_NODE).period(Duration.ONE_SECOND)).callable((Callable)new MasterChildFinder())).build(true);
        this.enrichers().add(((Enrichers.TransformerBuilder)((Enrichers.TransformerBuilder)Enrichers.builder().transforming(MASTER_NODE).uniqueTag("master-node-web-uri")).publishing(BrooklynNode.WEB_CONSOLE_URI).computing(EntityFunctions.attribute(BrooklynNode.WEB_CONSOLE_URI))).build());
    }

    BrooklynNode findMasterChild() {
        ImmutableList masters = FluentIterable.from((Iterable)this.getMembers()).filter(EntityPredicates.attributeEqualTo(BrooklynNode.MANAGEMENT_NODE_STATE, (Object)ManagementNodeState.MASTER)).toList();
        if (masters.size() == 0) {
            ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((Entity)this, (Sensor)MASTER_NODE, (Object)MSG_NO_MASTER);
            return null;
        }
        if (masters.size() == 1) {
            ServiceStateLogic.ServiceProblemsLogic.clearProblemsIndicator((Entity)this, (Sensor)MASTER_NODE);
            return (BrooklynNode)Iterables.getOnlyElement((Iterable)masters);
        }
        if (masters.size() == 2) {
            LOG.warn("Two masters detected, probably a handover just occured: " + masters);
            return (BrooklynNode)masters.iterator().next();
        }
        ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((Entity)this, (Sensor)MASTER_NODE, (Object)MSG_TOO_MANY_MASTERS);
        String msg = "Multiple (>=3) master nodes in cluster: " + masters;
        LOG.error(msg);
        throw new IllegalStateException(msg);
    }

    private final class MasterChildFinder
    implements Callable<BrooklynNode> {
        private MasterChildFinder() {
        }

        @Override
        public BrooklynNode call() throws Exception {
            return BrooklynClusterImpl.this.findMasterChild();
        }
    }
}

