/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import org.jclouds.azurecompute.arm.domain.AutoValue_ProbeProperties;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class ProbeProperties
implements Provisionable {
    @Nullable
    public abstract Protocol protocol();

    public abstract int port();

    @Nullable
    public abstract String requestPath();

    public abstract int intervalInSeconds();

    public abstract int numberOfProbes();

    @Override
    @Nullable
    public abstract String provisioningState();

    @SerializedNames(value={"protocol", "port", "requestPath", "intervalInSeconds", "numberOfProbes", "provisioningState"})
    public static ProbeProperties create(Protocol protocol, int port, String requestPath, int intervalInSeconds, int numberOfProbes, String provisioningState) {
        return ProbeProperties.builder().protocol(protocol).port(port).requestPath(requestPath).intervalInSeconds(intervalInSeconds).numberOfProbes(numberOfProbes).provisioningState(provisioningState).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_ProbeProperties.Builder();
    }

    public static abstract class Builder {
        public abstract Builder protocol(Protocol var1);

        public abstract Builder port(int var1);

        public abstract Builder requestPath(String var1);

        public abstract Builder intervalInSeconds(int var1);

        public abstract Builder numberOfProbes(int var1);

        public abstract Builder provisioningState(String var1);

        public abstract ProbeProperties build();
    }

    public static enum Protocol {
        Tcp("Tcp"),
        Http("Http"),
        UNRECOGNIZED("Unrecognized");

        private final String label;

        private Protocol(String label) {
            this.label = label;
        }

        public static Protocol fromValue(String text) {
            return (Protocol)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }

        public String toString() {
            return this.label;
        }
    }
}

