/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.config.ConfigInheritance;
import org.apache.brooklyn.config.ConfigInheritances;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.ConfigMap;
import org.apache.brooklyn.config.ConfigValueAtContainer;
import org.apache.brooklyn.core.config.BasicConfigInheritance;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.config.StructuredConfigKey;
import org.apache.brooklyn.core.config.internal.AbstractStructuredConfigKey;
import org.apache.brooklyn.core.config.internal.AncestorContainerAndKeyValueIterator;
import org.apache.brooklyn.core.entity.internal.ConfigMapViewWithStringKeys;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.internal.ConfigKeySelfExtracting;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigMapImpl<TContainer extends BrooklynObject>
implements ConfigMap.ConfigMapWithInheritance<TContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConfigMapImpl.class);
    @Deprecated
    protected final transient ConfigMapViewWithStringKeys mapViewWithStringKeys = new ConfigMapViewWithStringKeys((ConfigMap)this);
    protected TContainer bo;
    protected final Map<ConfigKey<?>, Object> ownConfig;

    protected AbstractConfigMapImpl(TContainer bo) {
        this(bo, Collections.synchronizedMap(new LinkedHashMap()));
    }

    protected AbstractConfigMapImpl(TContainer bo, Map<ConfigKey<?>, Object> storage) {
        this.bo = bo;
        this.ownConfig = storage;
    }

    public TContainer getContainer() {
        return this.bo;
    }

    public abstract <T> void assertValid(ConfigKey<T> var1, T var2);

    protected final BrooklynObjectInternal getBrooklynObject() {
        return (BrooklynObjectInternal)this.bo;
    }

    public <T> T getConfig(ConfigKey<T> key) {
        return (T)((ConfigValueAtContainer)this.getConfigImpl(key, false).getWithoutError()).get();
    }

    public <T> T getConfig(ConfigKey.HasConfigKey<T> key) {
        return this.getConfig(key.getConfigKey());
    }

    public Maybe<Object> getConfigLocalRaw(ConfigKey<?> key) {
        return this.getConfigRaw(key, false);
    }

    protected abstract ExecutionContext getExecutionContext(BrooklynObject var1);

    protected abstract void postLocalEvaluate(ConfigKey<?> var1, BrooklynObject var2, Maybe<?> var3, Maybe<?> var4);

    public Map<ConfigKey<?>, Object> getAllConfigLocalRaw() {
        LinkedHashMap result = new LinkedHashMap();
        this.putAllOwnConfigIntoSafely(result);
        return Collections.unmodifiableMap(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<ConfigKey<?>, Object> putAllOwnConfigIntoSafely(Map<ConfigKey<?>, Object> result) {
        Map<ConfigKey<?>, Object> map = this.ownConfig;
        synchronized (map) {
            result.putAll(this.ownConfig);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfigBag putAllOwnConfigIntoSafely(ConfigBag bag) {
        Map<ConfigKey<?>, Object> map = this.ownConfig;
        synchronized (map) {
            return bag.putAll(this.ownConfig);
        }
    }

    @Deprecated
    public Map<ConfigKey<?>, Object> getAllConfig() {
        LinkedHashMap result = new LinkedHashMap();
        if (this.getParent() != null) {
            result.putAll(this.getParentInternal().config().getInternalConfigMap().getAllConfig());
        }
        this.putAllOwnConfigIntoSafely(result);
        return Collections.unmodifiableMap(result);
    }

    @Deprecated
    public ConfigBag getAllConfigBag() {
        ConfigBag result = this.putAllOwnConfigIntoSafely(ConfigBag.newInstance());
        if (this.getParent() != null) {
            result.putIfAbsent(((AbstractConfigMapImpl)this.getParentInternal().config().getInternalConfigMap()).getAllConfigBag());
        }
        return result.seal();
    }

    public ConfigBag getLocalConfigBag() {
        return this.putAllOwnConfigIntoSafely(ConfigBag.newInstance()).seal();
    }

    public Object setConfig(ConfigKey<?> key, Object v) {
        return this.setConfigCoercingAndValidating(key, v, false).getLeft();
    }

    public <T> Pair<Object, Object> setConfigCoercingAndValidating(ConfigKey<T> key, Object v, boolean validate) {
        ConfigKey<T> ownKey = this.getKeyAtContainer(this.getContainer(), key);
        if (ownKey == null) {
            ownKey = key;
        }
        Object val = this.coerceConfigValAndValidate(ownKey, v, validate);
        Object oldVal = ownKey instanceof StructuredConfigKey ? ((StructuredConfigKey)ownKey).applyValueToMap(val, this.ownConfig) : this.ownConfig.put(ownKey, val);
        this.postSetConfig();
        return ImmutablePair.of((Object)oldVal, (Object)val);
    }

    protected abstract void postSetConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalConfig(Map<ConfigKey<?>, ?> vals) {
        Map<ConfigKey<?>, Object> map = this.ownConfig;
        synchronized (map) {
            this.ownConfig.clear();
            this.ownConfig.putAll(vals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRaw(ConfigKey<?> key, boolean preferContainerKey, Object value) {
        Map<ConfigKey<?>, Object> map = this.ownConfig;
        synchronized (map) {
            ConfigKey<?> ownKey;
            ConfigKey<?> configKey = ownKey = preferContainerKey ? this.getKeyAtContainer(this.getContainer(), key) : null;
            if (ownKey == null) {
                ownKey = key;
            }
            this.ownConfig.put(key, value);
        }
    }

    public void putAll(Map<?, ?> vals) {
        for (Map.Entry<?, ?> entry : vals.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("Cannot put null key into " + this);
            }
            if (entry.getKey() instanceof String) {
                this.setConfig(ConfigKeys.newConfigKey(Object.class, (String)entry.getKey()), entry.getValue());
                continue;
            }
            if (entry.getKey() instanceof ConfigKey) {
                this.setConfig((ConfigKey)entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getKey() instanceof ConfigKey.HasConfigKey) {
                this.setConfig(((ConfigKey.HasConfigKey)entry.getKey()).getConfigKey(), entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Cannot put key " + entry.getKey() + " (unknown type " + entry.getKey().getClass() + ") into " + this);
        }
    }

    public void removeKey(String key) {
        this.ownConfig.remove(ConfigKeys.newConfigKey(Object.class, key));
    }

    public void removeKey(ConfigKey<?> key) {
        this.ownConfig.remove(key);
    }

    protected final TContainer getParent() {
        return this.getParentOfContainer(this.getContainer());
    }

    protected final BrooklynObjectInternal getParentInternal() {
        return (BrooklynObjectInternal)this.getParent();
    }

    public Maybe<Object> getConfigRaw(ConfigKey<?> key, boolean includeInherited) {
        if (this.ownConfig.containsKey(key)) {
            return Maybe.of((Object)this.ownConfig.get(key));
        }
        for (String deprecatedName : key.getDeprecatedNames()) {
            ConfigKey<?> deprecatedKey = ConfigKeys.newConfigKeyRenamed(deprecatedName, key);
            if (!this.ownConfig.containsKey(deprecatedKey)) continue;
            LOG.warn("Retrieving value with deprecated config key name '" + deprecatedName + "' for key " + key);
            return Maybe.of((Object)this.ownConfig.get(deprecatedKey));
        }
        if (key instanceof AbstractStructuredConfigKey) {
            Object result = ((AbstractStructuredConfigKey)key).rawValue(this.ownConfig);
            if (result instanceof Iterable) {
                if (!((Iterable)result).iterator().hasNext()) {
                    return Maybe.absent((String)("No value for structured collection key " + key));
                }
            } else if (result instanceof Map) {
                if (((Map)result).isEmpty()) {
                    return Maybe.absent((String)("No value for structured map key " + key));
                }
            } else {
                LOG.warn("Unsupported structured config key " + key + "; may return default empty value if unset");
            }
            return Maybe.ofDisallowingNull(result);
        }
        if (!includeInherited || this.getParent() == null) {
            return Maybe.absent();
        }
        return this.getParentInternal().config().getInternalConfigMap().getConfigRaw(key, includeInherited);
    }

    protected final Object coerceConfigVal(ConfigKey<?> key, Object v) {
        return this.coerceConfigValAndValidate(key, v, false);
    }

    protected <T> Object coerceConfigValAndValidate(ConfigKey<T> key, Object v, boolean validate) {
        Object result = this.coerceConfigValPreValidate(key, v);
        if (validate) {
            this.assertValid(key, result);
        }
        return result;
    }

    protected <T> Object coerceConfigValPreValidate(ConfigKey<T> key, Object v) {
        Object result;
        if (v instanceof Future || v instanceof DeferredSupplier || v instanceof TaskFactory) {
            return v;
        }
        if (key instanceof StructuredConfigKey) {
            return v;
        }
        if ((v instanceof Map || v instanceof Iterable) && this.isStructurallyCompatible(key, v)) {
            return v;
        }
        try {
            result = TypeCoercions.coerce(v, key.getTypeToken());
        }
        catch (Exception e) {
            throw Exceptions.propagateAnnotated((String)("Cannot coerce or set " + v + " to " + key), (Throwable)e);
        }
        return result;
    }

    private <T> boolean isStructurallyCompatible(ConfigKey<T> key, Object v) {
        if (key.getType().isInstance(v)) {
            return true;
        }
        return Collection.class.isAssignableFrom(key.getType()) && v instanceof Iterable;
    }

    public Map<String, Object> asMapWithStringKeys() {
        return this.mapViewWithStringKeys;
    }

    public int size() {
        return this.ownConfig.size();
    }

    public boolean isEmpty() {
        return this.ownConfig.isEmpty();
    }

    protected ConfigInheritance getDefaultRuntimeInheritance() {
        return BasicConfigInheritance.OVERWRITE;
    }

    public <T> ReferenceWithError<ConfigValueAtContainer<TContainer, T>> getConfigAndContainer(ConfigKey<T> key) {
        return this.getConfigImpl(key, false);
    }

    protected abstract TContainer getParentOfContainer(TContainer var1);

    @Nullable
    protected final <T> ConfigKey<T> getKeyAtContainer(TContainer container, ConfigKey<T> queryKey) {
        if (container == null) {
            return null;
        }
        ConfigKey<?> candidate = this.getKeyAtContainerImpl(container, queryKey);
        return candidate;
    }

    @Nullable
    protected abstract <T> ConfigKey<?> getKeyAtContainerImpl(@Nonnull TContainer var1, ConfigKey<T> var2);

    protected abstract Collection<ConfigKey<?>> getKeysAtContainer(@Nonnull TContainer var1);

    protected Maybe<Object> getRawValueAtContainer(TContainer container, ConfigKey<? extends Object> configKey) {
        return ((BrooklynObjectInternal)container).config().getInternalConfigMap().getConfigLocalRaw(configKey);
    }

    protected Maybe<Object> resolveRawValueFromContainer(TContainer container, ConfigKey<?> key, Maybe<Object> value) {
        Maybe<Object> result = this.resolveRawValueFromContainerIgnoringDeprecatedNames(container, key, value);
        if (result.isPresent()) {
            return result;
        }
        for (String deprecatedName : key.getDeprecatedNames()) {
            ConfigKey<?> deprecatedKey = ConfigKeys.newConfigKeyRenamed(deprecatedName, key);
            result = this.resolveRawValueFromContainerIgnoringDeprecatedNames(container, deprecatedKey, value);
            if (!result.isPresent()) continue;
            LOG.warn("Retrieving value with deprecated config key name '" + deprecatedName + "' for key " + key);
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Maybe<Object> resolveRawValueFromContainerIgnoringDeprecatedNames(TContainer container, ConfigKey<?> key, Maybe<Object> value) {
        Map<ConfigKey<?>, Object> oc = ((AbstractConfigMapImpl)((BrooklynObjectInternal)container).config().getInternalConfigMap()).ownConfig;
        if (key instanceof ConfigKeySelfExtracting) {
            if (((ConfigKeySelfExtracting)key).isSet(oc)) {
                MutableMap ownCopy;
                Map<ConfigKey<?>, Object> map = oc;
                synchronized (map) {
                    ownCopy = MutableMap.copyOf(oc);
                }
                Maybe result = Maybe.of(((ConfigKeySelfExtracting)key).extractValue((Map<?, ?>)ownCopy, this.getExecutionContext((BrooklynObject)container)));
                this.postLocalEvaluate(key, (BrooklynObject)this.bo, value, (Maybe<?>)result);
                return result;
            }
            return Maybe.absent();
        }
        LOG.warn("Unexpected key type " + key + " (" + key.getClass() + ") in " + this.bo + "; ignoring value");
        return Maybe.absent();
    }

    protected <T> T resolveCoerceAndValidate(TContainer container, String name, Object value, TypeToken<T> type, ConfigKey<?> key1, ConfigKey<?> key2) {
        if (type == null || value == null) {
            return (T)value;
        }
        ExecutionContext exec = this.getExecutionContext((BrooklynObject)container);
        try {
            T result = Tasks.resolveDeepValueCoerced(value, type, exec, "config " + name);
            this.assertValid(key1, value);
            if (key2 != null && !Objects.equals(key1, key2)) {
                this.assertValid(key2, value);
            }
            if (result instanceof Map) {
                return (T)Collections.unmodifiableMap((Map)result);
            }
            if (result instanceof List) {
                return (T)Collections.unmodifiableList((List)result);
            }
            if (result instanceof Set) {
                return (T)Collections.unmodifiableSet((Set)result);
            }
            if (result instanceof Collection) {
                return (T)Collections.unmodifiableCollection((Collection)result);
            }
            return result;
        }
        catch (Exception e) {
            throw Exceptions.propagateAnnotated((String)("Error coercing " + container + "->" + name), (Throwable)e);
        }
    }

    protected <T> ReferenceWithError<ConfigValueAtContainer<TContainer, T>> getConfigImpl(final ConfigKey<T> queryKey, final boolean raw) {
        Maybe defaultValue;
        if (queryKey == null) {
            return ReferenceWithError.newInstanceThrowingError((Object)new ConfigInheritances.BasicConfigValueAtContainer(this.getContainer(), null, null, false, null), (Throwable)new NullPointerException("Query key cannot be null"));
        }
        Function keyFn = new Function<TContainer, ConfigKey<T>>(){

            public ConfigKey<T> apply(TContainer input) {
                return AbstractConfigMapImpl.this.getKeyAtContainer(input, queryKey);
            }
        };
        ConfigKey<T> ownKey1 = (ConfigKey<T>)keyFn.apply(this.getContainer());
        if (ownKey1 == null) {
            ownKey1 = queryKey;
        }
        final ConfigKey<T> ownKey = ownKey1;
        final TypeToken<T> type = AbstractConfigMapImpl.moreSpecificOrWarningPreferringFirst(ownKey, queryKey, "" + this.getContainer().getId() + "[" + this.getContainer().getDisplayName() + "]");
        Function coerceFn = new Function<Maybe<Object>, Maybe<T>>(){

            public Maybe<T> apply(Maybe<Object> input) {
                if (raw || input == null || input.isAbsent()) {
                    return input;
                }
                return new Maybe.MaybeSupplier(() -> AbstractConfigMapImpl.this.resolveCoerceAndValidate(AbstractConfigMapImpl.this.getContainer(), ownKey.getName(), input.get(), type, ownKey, queryKey));
            }
        };
        Maybe maybe = raw ? Maybe.absent() : (ownKey.hasDefaultValue() ? (Maybe)coerceFn.apply((Object)Maybe.of((Object)ownKey.getDefaultValue())) : (defaultValue = queryKey.hasDefaultValue() ? (Maybe)coerceFn.apply((Object)Maybe.of((Object)queryKey.getDefaultValue())) : Maybe.absent()));
        if (ownKey instanceof ConfigKeySelfExtracting) {
            Function lookupFn = new Function<TContainer, Maybe<Object>>(){

                public Maybe<Object> apply(TContainer input) {
                    Maybe<Object> result = AbstractConfigMapImpl.this.getRawValueAtContainer(input, (ConfigKey<Object>)ownKey);
                    if (!raw) {
                        result = AbstractConfigMapImpl.this.resolveRawValueFromContainer(input, ownKey, result);
                    }
                    return result;
                }
            };
            Function parentFn = new Function<TContainer, TContainer>(){

                public TContainer apply(TContainer input) {
                    return AbstractConfigMapImpl.this.getParentOfContainer(input);
                }
            };
            AncestorContainerAndKeyValueIterator ckvi = new AncestorContainerAndKeyValueIterator(this.getContainer(), keyFn, lookupFn, coerceFn, parentFn);
            return ConfigInheritances.resolveInheriting(this.getContainer(), ownKey, (Maybe)((Maybe)coerceFn.apply(lookupFn.apply(this.getContainer()))), (Maybe)defaultValue, ckvi, (ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.RUNTIME_MANAGEMENT, (ConfigInheritance)this.getDefaultRuntimeInheritance());
        }
        String message = "Config key " + ownKey + " of " + this.getBrooklynObject() + " is not a ConfigKeySelfExtracting; cannot retrieve value; returning default";
        LOG.warn(message);
        return ReferenceWithError.newInstanceThrowingError((Object)new ConfigInheritances.BasicConfigValueAtContainer(this.getContainer(), ownKey, null, false, defaultValue), (Throwable)new IllegalStateException(message));
    }

    private static TypeToken<?> moreSpecificOrWarningPreferringFirst(ConfigKey<?> ownKey, ConfigKey<?> queryKey, String context) {
        if (ownKey == null && queryKey == null) {
            return null;
        }
        if (queryKey == null) {
            return ownKey.getTypeToken();
        }
        if (ownKey == null) {
            return queryKey.getTypeToken();
        }
        TypeToken ownType = ownKey.getTypeToken();
        TypeToken queryType = queryKey.getTypeToken();
        if (queryType.isSupertypeOf(ownType)) {
            return ownType;
        }
        if (ownType.isSupertypeOf(queryType)) {
            LOG.debug("Query for " + queryKey + " wants more specific type than key " + ownKey + " declared on " + context + " (unusual but clear what to do)");
            return queryType;
        }
        LOG.warn("Query for " + queryKey + " on " + context + " matched incompatible declared type in key " + ownKey + "; using the declared type");
        return ownType;
    }

    public List<ConfigValueAtContainer<TContainer, ?>> getConfigAllInheritedRaw(ConfigKey<?> queryKey) {
        MutableList result = MutableList.of();
        TContainer c = this.getContainer();
        int count = 0;
        ConfigKeys.InheritanceContext context = ConfigKeys.InheritanceContext.RUNTIME_MANAGEMENT;
        ConfigInheritance currentInheritance = ConfigInheritances.findInheritance(queryKey, (ConfigInheritance.ConfigInheritanceContext)context, (ConfigInheritance)this.getDefaultRuntimeInheritance());
        ConfigInheritances.BasicConfigValueAtContainer last = null;
        while (c != null) {
            Maybe<Object> v = this.getRawValueAtContainer(c, queryKey);
            ConfigInheritances.BasicConfigValueAtContainer next = new ConfigInheritances.BasicConfigValueAtContainer(c, this.getKeyAtContainer(c, queryKey), v);
            if (last != null && !currentInheritance.considerParent(last, (ConfigValueAtContainer)next, (ConfigInheritance.ConfigInheritanceContext)context)) break;
            ConfigInheritance currentInheritanceExplicit = ConfigInheritances.findInheritance((ConfigKey)next.getKey(), (ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.RUNTIME_MANAGEMENT, null);
            if (currentInheritanceExplicit != null) {
                if (count > 0 && !currentInheritanceExplicit.isReinheritable((ConfigValueAtContainer)next, (ConfigInheritance.ConfigInheritanceContext)context)) break;
                currentInheritance = currentInheritanceExplicit;
            }
            if (next.isValueExplicitlySet()) {
                result.add(0, next);
            }
            last = next;
            c = this.getParentOfContainer(c);
            ++count;
        }
        return result;
    }

    @Deprecated
    public Set<ConfigKey<?>> findKeys(Predicate<? super ConfigKey<?>> filter) {
        return this.findKeys(filter, KeyFindingMode.PRESENT_NOT_RESOLVED);
    }

    public Set<ConfigKey<?>> findKeysDeclared(Predicate<? super ConfigKey<?>> filter) {
        return this.findKeys(filter, KeyFindingMode.DECLARED_OR_PRESENT);
    }

    public Set<ConfigKey<?>> findKeysPresent(Predicate<? super ConfigKey<?>> filter) {
        return this.findKeys(filter, KeyFindingMode.PRESENT_AND_RESOLVED);
    }

    protected Set<ConfigKey<?>> findKeys(Predicate<? super ConfigKey<?>> filter, KeyFindingMode mode) {
        MutableSet result = MutableSet.of();
        for (ConfigKey k : Iterables.filter(this.ownConfig.keySet(), filter)) {
            ConfigKey k2;
            if (result.contains((Object)k)) continue;
            if (mode != KeyFindingMode.PRESENT_NOT_RESOLVED && (k2 = this.getKeyAtContainer(this.getContainer(), k)) != null) {
                k = k2;
            }
            result.add((Object)k);
        }
        if (mode == KeyFindingMode.DECLARED_OR_PRESENT) {
            result.addAll(Iterables.filter(this.getKeysAtContainer(this.getContainer()), filter));
        }
        if (this.getParent() != null) {
            Set inherited;
            switch (mode) {
                case DECLARED_OR_PRESENT: {
                    inherited = this.getParentInternal().config().getInternalConfigMap().findKeysDeclared(filter);
                    break;
                }
                case PRESENT_AND_RESOLVED: {
                    inherited = this.getParentInternal().config().getInternalConfigMap().findKeysPresent(filter);
                    break;
                }
                case PRESENT_NOT_RESOLVED: {
                    inherited = this.getParentInternal().config().getInternalConfigMap().findKeys(filter);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported key finding mode: " + (Object)((Object)mode));
                }
            }
            result.addAll(AbstractConfigMapImpl.filterOutRuntimeNotReinherited(inherited));
        }
        return result;
    }

    private static Set<ConfigKey<?>> filterOutRuntimeNotReinherited(Set<ConfigKey<?>> inherited) {
        MutableSet result = MutableSet.of();
        for (ConfigKey<?> k : inherited) {
            if (!ConfigInheritances.isKeyReinheritable(k, (ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.RUNTIME_MANAGEMENT)) continue;
            result.add(k);
        }
        return result;
    }

    public ReferenceWithError<ConfigValueAtContainer<TContainer, ?>> getConfigInheritedRaw(ConfigKey<?> key) {
        return this.getConfigImpl(key, true);
    }

    public Map<ConfigKey<?>, Object> getAllConfigInheritedRawValuesIgnoringErrors() {
        Map<ConfigKey<?>, ReferenceWithError<ConfigValueAtContainer<TContainer, ?>>> input = this.getAllConfigInheritedRawWithErrors();
        MutableMap result = MutableMap.of();
        for (Map.Entry<ConfigKey<?>, ReferenceWithError<ConfigValueAtContainer<TContainer, ?>>> pair : input.entrySet()) {
            result.put(pair.getKey(), ((ConfigValueAtContainer)pair.getValue().getWithoutError()).get());
        }
        return result;
    }

    public Map<ConfigKey<?>, ReferenceWithError<ConfigValueAtContainer<TContainer, ?>>> getAllConfigInheritedRawWithErrors() {
        return this.getSelectedConfigInheritedRaw(null, false);
    }

    public Map<ConfigKey<?>, ReferenceWithError<ConfigValueAtContainer<TContainer, ?>>> getAllReinheritableConfigRaw() {
        return this.getSelectedConfigInheritedRaw(null, true);
    }

    protected Map<ConfigKey<?>, ReferenceWithError<ConfigValueAtContainer<TContainer, ?>>> getSelectedConfigInheritedRaw(Map<ConfigKey<?>, ConfigKey<?>> knownKeys, boolean onlyReinheritable) {
        MutableMap knownKeysOnType = MutableMap.of();
        for (ConfigKey<?> k : this.getKeysAtContainer(this.getContainer())) {
            knownKeysOnType.put(k, k);
        }
        MutableMap knownKeysIncludingDescendants = MutableMap.copyOf(knownKeys);
        knownKeysIncludingDescendants.putAll(knownKeysOnType);
        MutableMap parents = MutableMap.of();
        if (this.getParent() != null) {
            Map<ConfigKey<?>, ReferenceWithError<ConfigValueAtContainer<TContainer, ?>>> po = ((AbstractConfigMapImpl)this.getParentInternal().config().getInternalConfigMap()).getSelectedConfigInheritedRaw((Map<ConfigKey<?>, ConfigKey<?>>)knownKeysIncludingDescendants, true);
            parents.putAll(po);
        }
        Map<ConfigKey<?>, Object> local = this.getAllConfigLocalRaw();
        MutableMap result = MutableMap.of();
        for (ConfigKey kSet : MutableSet.copyOf(local.keySet()).putAll(parents.keySet())) {
            ConfigInheritance inhHere;
            Maybe localValue = local.containsKey(kSet) ? Maybe.ofAllowingNull((Object)local.get(kSet)) : Maybe.absent();
            ReferenceWithError vpr = (ReferenceWithError)parents.remove(kSet);
            ConfigValueAtContainer vp = vpr == null ? null : (ConfigValueAtContainer)vpr.getWithoutError();
            ConfigKey kOnType = (ConfigKey)knownKeysOnType.get(kSet);
            ConfigKey kTypeOrDescendant = (ConfigKey)knownKeysIncludingDescendants.get(kSet);
            assert (kOnType == null || kOnType == kTypeOrDescendant);
            ConfigInheritance inhHereOrDesc = ConfigInheritances.findInheritance((ConfigKey)kTypeOrDescendant, (ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.RUNTIME_MANAGEMENT, (ConfigInheritance)this.getDefaultRuntimeInheritance());
            ConfigInheritances.BasicConfigValueAtContainer vl = new ConfigInheritances.BasicConfigValueAtContainer(this.getContainer(), kOnType, localValue);
            ReferenceWithError vlr = null;
            if (inhHereOrDesc.considerParent((ConfigValueAtContainer)vl, vp, (ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.RUNTIME_MANAGEMENT)) {
                vlr = inhHereOrDesc.resolveWithParent((ConfigValueAtContainer)vl, vp, (ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.RUNTIME_MANAGEMENT);
            } else {
                if (!vl.isValueExplicitlySet()) continue;
                vlr = ReferenceWithError.newInstanceWithoutError((Object)vl);
            }
            if (onlyReinheritable && !(inhHere = ConfigInheritances.findInheritance((ConfigKey)kOnType, (ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.RUNTIME_MANAGEMENT, (ConfigInheritance)this.getDefaultRuntimeInheritance())).isReinheritable((ConfigValueAtContainer)vl, (ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.RUNTIME_MANAGEMENT)) continue;
            ReferenceWithError vlro = vlr;
            result.put(kSet, vlro);
        }
        assert (parents.isEmpty());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<ConfigKey<?>, Object> sanitizeConfig;
        Map<ConfigKey<?>, Object> map = this.ownConfig;
        synchronized (map) {
            sanitizeConfig = Sanitizer.sanitize(this.ownConfig);
        }
        return super.toString() + "[local=" + sanitizeConfig + "]";
    }

    protected static enum KeyFindingMode {
        DECLARED_OR_PRESENT,
        PRESENT_AND_RESOLVED,
        PRESENT_NOT_RESOLVED;

    }
}

