/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.google.common.annotations.Beta;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.util.core.BrooklynEntityUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class AddChildrenInitializer
extends EntityInitializers.InitializerPatternWithConfigKeys {
    private static final Logger log = LoggerFactory.getLogger(AddChildrenInitializer.class);
    public static final ConfigKey<Object> BLUEPRINT_YAML = ConfigKeys.newConfigKey(Object.class, "blueprint_yaml");
    public static final ConfigKey<String> BLUEPRINT_TYPE = ConfigKeys.newStringConfigKey("blueprint_type");
    public static final ConfigKey<Boolean> AUTO_START = ConfigKeys.newBooleanConfigKey("auto_start");

    private AddChildrenInitializer() {
    }

    public AddChildrenInitializer(ConfigBag params) {
        super(params);
    }

    public void apply(EntityLocal entity) {
        ConfigBag params = this.initParams();
        Object yaml = params.get(BLUEPRINT_YAML);
        String blueprintType = params.get(BLUEPRINT_TYPE);
        String blueprint = BrooklynEntityUtils.parseBlueprintYaml(yaml, blueprintType);
        BrooklynEntityUtils.addChildrenToEntity((Entity)entity, params, blueprint, params.get(AUTO_START));
    }
}

