/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.feed;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;

public class ConfigToAttributes {
    public static void apply(Entity entity) {
        for (Sensor it : entity.getEntityType().getSensors()) {
            if (!(it instanceof AttributeSensorAndConfigKey)) continue;
            ConfigToAttributes.apply(entity, (AttributeSensorAndConfigKey)it);
        }
    }

    public static <T> T apply(Entity entity, AttributeSensorAndConfigKey<?, T> key) {
        Object v = entity.getAttribute(key);
        if (v != null) {
            return (T)v;
        }
        v = key.getAsSensorValue(entity);
        if (v != null) {
            entity.sensors().set(key, v);
        }
        return (T)v;
    }

    public static <T> T transform(ManagementContext managementContext, AttributeSensorAndConfigKey<?, T> key) {
        return key.getAsSensorValue(managementContext);
    }
}

