/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import java.util.function.Function;
import org.apache.brooklyn.core.resolve.jackson.AsPropertyIfAmbiguous;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonSerializationUtils;

public abstract class JsonSymbolDependentDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer {
    public static final Set<JsonToken> SIMPLE_TOKENS = ImmutableSet.of((Object)JsonToken.VALUE_STRING, (Object)JsonToken.VALUE_NUMBER_FLOAT, (Object)JsonToken.VALUE_NUMBER_INT, (Object)JsonToken.VALUE_TRUE, (Object)JsonToken.VALUE_FALSE, (Object)JsonToken.VALUE_NULL, (Object[])new JsonToken[0]);
    protected DeserializationContext ctxt;
    protected BeanProperty beanProp;
    private BeanDescription beanDesc;
    protected JavaType type;

    public BeanDescription getBeanDescription() {
        if (this.beanDesc != null) {
            return this.beanDesc;
        }
        if (this.type != null) {
            this.beanDesc = this.ctxt.getConfig().introspect(this.type);
            return this.beanDesc;
        }
        return null;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        this.ctxt = ctxt;
        this.beanProp = property;
        if (property != null) {
            this.type = property.getType();
        }
        if (this.type == null) {
            this.type = ctxt.getContextualType();
        }
        if (this.isTypeReplaceableByDefault()) {
            this.type = this.getDefaultType();
        }
        return this;
    }

    protected boolean isTypeReplaceableByDefault() {
        if (this.type == null) {
            return true;
        }
        return this.type.getRawClass().isInterface();
    }

    public abstract JavaType getDefaultType();

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Function<Object, Object> post = x -> x;
        if (p.getCurrentToken() == JsonToken.START_ARRAY) {
            return this.deserializeArray(p);
        }
        if (SIMPLE_TOKENS.contains(p.getCurrentToken())) {
            return this.deserializeToken(p);
        }
        return this.deserializeObject(p);
    }

    protected JsonDeserializer<?> contextualize(JsonDeserializer<?> deser) throws IOException, JsonProcessingException {
        if (deser instanceof ContextualDeserializer) {
            return ((ContextualDeserializer)deser).createContextual(this.ctxt, this.beanProp);
        }
        return deser;
    }

    protected Object deserializeArray(JsonParser p) throws IOException, JsonProcessingException {
        return this.contextualize(this.getArrayDeserializer()).deserialize(p, this.ctxt);
    }

    protected JsonDeserializer<?> getArrayDeserializer() throws IOException {
        if (this.type != null) {
            Object handler = this.type.getTypeHandler();
            if (handler == null) {
                this.type = this.ctxt.constructType(Object.class);
                handler = this.ctxt.getFactory().findTypeDeserializer(this.ctxt.getConfig(), this.type);
            }
            if (handler instanceof AsPropertyIfAmbiguous.AsPropertyButNotIfFieldConflictTypeDeserializer) {
                final AsPropertyIfAmbiguous.AsPropertyButNotIfFieldConflictTypeDeserializer hf = (AsPropertyIfAmbiguous.AsPropertyButNotIfFieldConflictTypeDeserializer)((Object)handler);
                return new JsonDeserializer<Object>(){

                    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                        return hf.deserializeArrayContainingType(p, ctxt);
                    }
                };
            }
        }
        throw new IllegalStateException("List input not supported for " + this.type);
    }

    protected Object deserializeToken(JsonParser p) throws IOException, JsonProcessingException {
        return this.contextualize(this.getTokenDeserializer()).deserialize(p, this.ctxt);
    }

    protected JsonDeserializer<?> getTokenDeserializer() throws IOException, JsonProcessingException {
        return this.getObjectDeserializer();
    }

    protected Object deserializeObject(JsonParser p) throws IOException, JsonProcessingException {
        return this.contextualize(this.getObjectDeserializer()).deserialize(p, this.ctxt);
    }

    protected JsonDeserializer<?> getObjectDeserializer() throws IOException, JsonProcessingException {
        return BrooklynJacksonSerializationUtils.createBeanDeserializer(this.ctxt, this.type, this.getBeanDescription(), true, true);
    }
}

