/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypePlanTransformer;
import org.apache.brooklyn.core.typereg.AbstractFormatSpecificTypeImplementationPlan;
import org.apache.brooklyn.core.typereg.AbstractTypePlanTransformer;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.yaml.Yamls;

public class JavaClassNameTypePlanTransformer
extends AbstractTypePlanTransformer {
    public static final String FORMAT = "java-type-name";

    public JavaClassNameTypePlanTransformer() {
        super(FORMAT, "Java type name", "Expects a java type name in a format suitable for use with ClassLoader.loadClass");
    }

    @Override
    protected double scoreForNullFormat(Object planData, RegisteredType type, RegisteredTypeLoadingContext context) {
        if (type.getPlan().getPlanData() instanceof String && ((String)type.getPlan().getPlanData()).matches("([ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_][ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890]*\\.)*[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_][ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890]*(\\$[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890]+)*")) {
            return 0.1;
        }
        return 0.0;
    }

    @Override
    protected double scoreForNonmatchingNonnullFormat(String planFormat, Object planData, RegisteredType type, RegisteredTypeLoadingContext context) {
        return 0.0;
    }

    @Override
    protected AbstractBrooklynObjectSpec<?, ?> createSpec(RegisteredType type, RegisteredTypeLoadingContext context) throws Exception {
        return this.decorateWithCommonTagsModifyingSpecSummary(RegisteredTypes.newSpecInstance(this.mgmt, this.getType(type, context)), type, null, null, null);
    }

    @Override
    protected Object createBean(RegisteredType type, RegisteredTypeLoadingContext context) throws Exception {
        Constructor<?> constr;
        Class<?> clz = this.getType(type, context);
        try {
            constr = clz.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw Exceptions.propagateAnnotated((String)("No 0-arg constructor found for " + clz + " for " + type.getId()), (Throwable)e);
        }
        return constr.newInstance(new Object[0]);
    }

    private Class<?> getType(RegisteredType type, RegisteredTypeLoadingContext context) throws Exception {
        String planData = ((String)type.getPlan().getPlanData()).trim();
        try {
            Object ym;
            Iterable yaml = Yamls.parseAll((String)planData);
            if (Iterables.size((Iterable)yaml) == 1 && (ym = yaml.iterator().next()) instanceof Map) {
                Object yt = ((Map)ym).get(BeanWithTypePlanTransformer.TYPE_UNAMBIGUOUS_KEY);
                if (yt instanceof String) {
                    planData = (String)yt;
                } else {
                    yt = ((Map)ym).get("type");
                    if (yt instanceof String) {
                        planData = (String)yt;
                    }
                }
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
        }
        return RegisteredTypes.loadActualJavaType(planData, this.mgmt, type, context);
    }

    public static class JavaClassNameTypeImplementationPlan
    extends AbstractFormatSpecificTypeImplementationPlan<String> {
        public JavaClassNameTypeImplementationPlan(String javaType) {
            super(JavaClassNameTypePlanTransformer.FORMAT, javaType);
        }
    }
}

