/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.brooklyn.api.framework.FrameworkLookup;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.plan.PlanNotRecognizedException;
import org.apache.brooklyn.core.typereg.BrooklynTypePlanTransformer;
import org.apache.brooklyn.core.typereg.TypePlanException;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.PropagatedRuntimeException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypePlanTransformers {
    private static final Logger log = LoggerFactory.getLogger(TypePlanTransformers.class);
    private static Collection<Class<? extends BrooklynTypePlanTransformer>> OVERRIDE;

    private static Collection<BrooklynTypePlanTransformer> getAll() {
        return ImmutableList.copyOf((Iterable)FrameworkLookup.lookupAll(BrooklynTypePlanTransformer.class));
    }

    @SafeVarargs
    @VisibleForTesting
    public static synchronized void forceAvailable(Class<? extends BrooklynTypePlanTransformer> ... classes) {
        OVERRIDE = Arrays.asList(classes);
    }

    public static synchronized void clearForced() {
        OVERRIDE = null;
    }

    public static Collection<BrooklynTypePlanTransformer> all(ManagementContext mgmt) {
        Collection<Class<? extends BrooklynTypePlanTransformer>> override = OVERRIDE;
        ArrayList<BrooklynTypePlanTransformer> result = new ArrayList<BrooklynTypePlanTransformer>();
        if (override != null) {
            for (Class<? extends BrooklynTypePlanTransformer> o1 : override) {
                try {
                    result.add(o1.newInstance());
                }
                catch (Exception e) {
                    Exceptions.propagate((Throwable)e);
                }
            }
        } else {
            result.addAll(TypePlanTransformers.getAll());
        }
        for (BrooklynTypePlanTransformer t : result) {
            t.setManagementContext(mgmt);
        }
        return result;
    }

    @Beta
    public static List<BrooklynTypePlanTransformer> forType(ManagementContext mgmt, RegisteredType type, RegisteredTypeLoadingContext constraint) {
        TreeMultimap byScoreMulti = TreeMultimap.create(Comparator.reverseOrder(), (r1, r2) -> 0);
        Collection<BrooklynTypePlanTransformer> transformers = TypePlanTransformers.all(mgmt);
        for (BrooklynTypePlanTransformer transformer : transformers) {
            double score = transformer.scoreForType(type, constraint);
            if (log.isTraceEnabled()) {
                log.trace("SCORE for '" + type + "' at " + transformer + ": " + score);
            }
            if (!(score > 0.0)) continue;
            byScoreMulti.put((Object)score, (Object)transformer);
        }
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable[])new Iterable[]{byScoreMulti.values()}));
    }

    @Beta
    public static Maybe<Object> transform(ManagementContext mgmt, RegisteredType type, RegisteredTypeLoadingContext constraint) {
        RuntimeException result;
        if (type == null) {
            return Maybe.absent((String)"type cannot be null");
        }
        if (type.getPlan() == null) {
            return Maybe.absent((String)("type plan cannot be null, when instantiating " + type));
        }
        List<BrooklynTypePlanTransformer> transformers = TypePlanTransformers.forType(mgmt, type, constraint);
        ArrayList<String> transformersWhoDontSupport = new ArrayList<String>();
        ArrayList<PropagatedRuntimeException> failuresFromTransformers = new ArrayList<PropagatedRuntimeException>();
        for (BrooklynTypePlanTransformer t : transformers) {
            try {
                Object result2 = t.create(type, constraint);
                if (result2 == null) {
                    transformersWhoDontSupport.add(t.getFormatCode() + " (returned null)");
                    continue;
                }
                return Maybe.of((Object)result2);
            }
            catch (PlanNotRecognizedException | UnsupportedTypePlanException e) {
                transformersWhoDontSupport.add(t.getFormatCode() + (Strings.isNonBlank((CharSequence)e.getMessage()) ? " (" + e.getMessage() + ")" : ""));
            }
            catch (Throwable e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (log.isTraceEnabled()) {
                    log.trace("Transformer for " + t.getFormatCode() + " gave an error creating this plan (may retry): " + e, e);
                }
                PropagatedRuntimeException e1 = new PropagatedRuntimeException((type.getSymbolicName() != null ? t.getFormatCode() + " plan creation error in " + type.getId() : t.getFormatCode() + " plan creation error") + ": " + Exceptions.collapseText((Throwable)e), e);
                if (Exceptions.getFirstThrowableOfType((Throwable)e, TypePlanException.class) != null && (type.getPlan().getPlanFormat() == null || Objects.equals(type.getPlan().getPlanFormat(), t.getFormatCode()))) {
                    failuresFromTransformers.add(0, e1);
                    continue;
                }
                failuresFromTransformers.add(e1);
            }
        }
        if (log.isDebugEnabled()) {
            Supplier<String> s = () -> "Interim failure transforming plan " + BasicBrooklynCatalog.currentlyResolvingType.get() + "/" + BasicBrooklynCatalog.currentlyValidatingType.get() + "; will throw/return summary failure and catalog routines often wrap and retry, but for reference in the event this failure is unexpected: potentially applicable transformers were " + transformers + ", available ones are " + MutableList.builder().addAll(TypePlanTransformers.all(mgmt)).build() + "; unsupported by: " + transformersWhoDontSupport + "; failures: " + failuresFromTransformers;
            if (BasicBrooklynCatalog.currentlyResolvingType.get() == null && BasicBrooklynCatalog.currentlyValidatingType.get() == null) {
                log.debug(s.get());
            } else if (log.isTraceEnabled()) {
                log.trace(s.get());
            }
        }
        if (!failuresFromTransformers.isEmpty()) {
            result = failuresFromTransformers.size() == 1 ? Exceptions.create(null, failuresFromTransformers) : Exceptions.create((String)"All applicable plan transformers failed", failuresFromTransformers);
        } else {
            String prefix;
            String string = prefix = Strings.isBlank((CharSequence)type.getPlan().getPlanFormat()) ? "Invalid plan" : "Invalid '" + type.getPlan().getPlanFormat() + "' plan";
            result = transformers.isEmpty() ? new UnsupportedTypePlanException(prefix + "; format could not be recognized, none of the available transformers " + TypePlanTransformers.all(mgmt) + " support " + (type.getId() != null ? type.getId() : "plan:\n" + Sanitizer.sanitizeJsonTypes(type.getPlan().getPlanData()))) : new UnsupportedTypePlanException(prefix + "; potentially applicable transformers " + transformers + " do not support it, and other available transformers do not accept it");
        }
        return Maybe.absent((Throwable)result);
    }
}

