/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.variables;

import com.google.common.collect.Iterables;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.steps.variables.SetVariableWorkflowStep;
import org.apache.brooklyn.core.workflow.steps.variables.WorkflowTransformDefault;
import org.apache.brooklyn.util.collections.MutableSet;

public class TransformSetWorkflowVariable
extends WorkflowTransformDefault {
    private String name;

    @Override
    protected void initCheckingDefinition() {
        MutableSet d = MutableSet.copyOf(this.definition.subList(1, this.definition.size()));
        if (d.isEmpty()) {
            throw new IllegalArgumentException("Transform 'set' requires a variable name");
        }
        if (d.size() > 1) {
            throw new IllegalArgumentException("Transform 'set' requires a single argument being the variable name; not " + d);
        }
        this.name = (String)Iterables.getOnlyElement((Iterable)d);
    }

    public Object apply(Object v) {
        String nameToSet = this.context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, (Object)this.name, String.class);
        SetVariableWorkflowStep.setWorkflowScratchVariableDotSeparated(this.stepContext, nameToSet, v);
        return v;
    }
}

