/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.cassandra;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.database.DatastoreMixins;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraDatacenterImpl;
import org.apache.brooklyn.entity.nosql.cassandra.TokenGenerator;
import org.apache.brooklyn.entity.nosql.cassandra.TokenGenerators;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

@Deprecated
@Catalog(name="Apache Cassandra Datacenter Cluster", description="Cassandra is a highly scalable, eventually consistent, distributed, structured key-value store which provides a ColumnFamily-based data model richer than typical key/value systems", iconUrl="classpath:///cassandra-logo.jpeg")
@ImplementedBy(value=CassandraDatacenterImpl.class)
public interface CassandraDatacenter
extends DynamicCluster,
DatastoreMixins.HasDatastoreUrl,
DatastoreMixins.CanExecuteScript {
    @SetFromFlag(value="clusterName")
    public static final BasicAttributeSensorAndConfigKey<String> CLUSTER_NAME = new BasicAttributeSensorAndConfigKey(String.class, "cassandra.cluster.name", "Name of the Cassandra cluster", (Object)"BrooklynCluster");
    @SetFromFlag(value="snitchName")
    public static final ConfigKey<String> ENDPOINT_SNITCH_NAME = ConfigKeys.newStringConfigKey((String)"cassandra.cluster.snitchName", (String)"Type of the Cassandra snitch", (String)"SimpleSnitch");
    @SetFromFlag(value="seedSupplier")
    public static final ConfigKey<Supplier<Set<Entity>>> SEED_SUPPLIER = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Supplier<Set<Entity>>>(){}, (String)"cassandra.cluster.seedSupplier", (String)"For determining the seed nodes", null);
    @SetFromFlag(value="tokenGeneratorClass")
    public static final ConfigKey<Class<? extends TokenGenerator>> TOKEN_GENERATOR_CLASS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Class<? extends TokenGenerator>>(){}, (String)"cassandra.cluster.tokenGenerator.class", (String)"For determining the tokens of nodes", TokenGenerators.PosNeg63TokenGenerator.class);
    @SetFromFlag(value="tokenShift")
    public static final ConfigKey<BigInteger> TOKEN_SHIFT = ConfigKeys.newConfigKey(BigInteger.class, (String)"cassandra.cluster.tokenShift", (String)"Delta applied to all tokens generated for this Cassandra datacenter, useful when configuring multiple datacenters which should be shifted; if not set, a random shift is applied. (Pass 0 to prevent any shift.)", null);
    public static final ConfigKey<Boolean> USE_VNODES = ConfigKeys.newBooleanConfigKey((String)"cassandra.cluster.useVnodes", (String)"Determines whether to use vnodes; if doing so, tokens will not be explicitly assigned to nodes in the cluster", (Boolean)false);
    public static final ConfigKey<Integer> NUM_TOKENS_PER_NODE = ConfigKeys.newIntegerConfigKey((String)"cassandra.numTokensPerNode", (String)"Number of tokens per node; if using vnodes, should set this to a value like 256; will be overridden to 1 if USE_VNODES==false", (Integer)256);
    @SetFromFlag(value="delayBeforeAdvertisingCluster")
    public static final ConfigKey<Duration> DELAY_BEFORE_ADVERTISING_CLUSTER = ConfigKeys.newConfigKey(Duration.class, (String)"cassandra.cluster.delayBeforeAdvertisingCluster", (String)"Delay after cluster is started before checking and advertising its availability", (Object)Duration.TEN_SECONDS);
    public static final AttributeSensor<Multimap<String, Entity>> DATACENTER_USAGE = Sensors.newSensor((TypeToken)new TypeToken<Multimap<String, Entity>>(){}, (String)"cassandra.cluster.datacenterUsages", (String)"Current set of datacenters in use, with nodes in each");
    public static final AttributeSensor<Set<String>> DATACENTERS = Sensors.newSensor((TypeToken)new TypeToken<Set<String>>(){}, (String)"cassandra.cluster.datacenters", (String)"Current set of datacenters in use");
    public static final AttributeSensor<Boolean> HAS_PUBLISHED_SEEDS = Sensors.newBooleanSensor((String)"cassandra.cluster.seeds.hasPublished", (String)"Whether we have published any seeds");
    public static final AttributeSensor<Set<Entity>> CURRENT_SEEDS = Sensors.newSensor((TypeToken)new TypeToken<Set<Entity>>(){}, (String)"cassandra.cluster.seeds.current", (String)"Current set of seeds to use to bootstrap the cluster");
    public static final AttributeSensor<String> HOSTNAME = Sensors.newStringSensor((String)"cassandra.cluster.hostname", (String)"Hostname to connect to cluster with");
    public static final AttributeSensor<List<String>> CASSANDRA_CLUSTER_NODES = Sensors.newSensor((TypeToken)new TypeToken<List<String>>(){}, (String)"cassandra.cluster.nodes", (String)"List of host:port of all active nodes in the cluster (thrift port, and public hostname/IP)");
    public static final AttributeSensor<Integer> THRIFT_PORT = Sensors.newIntegerSensor((String)"cassandra.cluster.thrift.port", (String)"Cassandra Thrift RPC port to connect to cluster with");
    public static final AttributeSensor<Long> FIRST_NODE_STARTED_TIME_UTC = Sensors.newLongSensor((String)"cassandra.cluster.first.node.started.utc", (String)"Time (UTC) when the first node was started");
    public static final AttributeSensor<List<Entity>> QUEUED_START_NODES = Sensors.newSensor((TypeToken)new TypeToken<List<Entity>>(){}, (String)"cassandra.cluster.start.nodes.queued", (String)"Nodes queued for starting (for sequential start)");
    public static final AttributeSensor<Integer> SCHEMA_VERSION_COUNT = Sensors.newIntegerSensor((String)"cassandra.cluster.schema.versions.count", (String)"Number of different schema versions in the cluster; should be 1 for a healthy cluster, 0 when off; 2 and above indicats a Schema Disagreement Error (and keyspace access may fail)");
    public static final AttributeSensor<Long> READ_PENDING = Sensors.newLongSensor((String)"cassandra.cluster.read.pending", (String)"Current pending ReadStage tasks");
    public static final AttributeSensor<Integer> READ_ACTIVE = Sensors.newIntegerSensor((String)"cassandra.cluster.read.active", (String)"Current active ReadStage tasks");
    public static final AttributeSensor<Long> WRITE_PENDING = Sensors.newLongSensor((String)"cassandra.cluster.write.pending", (String)"Current pending MutationStage tasks");
    public static final AttributeSensor<Integer> WRITE_ACTIVE = Sensors.newIntegerSensor((String)"cassandra.cluster.write.active", (String)"Current active MutationStage tasks");
    public static final AttributeSensor<Long> THRIFT_PORT_LATENCY_PER_NODE = Sensors.newLongSensor((String)"cassandra.cluster.thrift.latency.perNode", (String)"Latency for thrift port connection  averaged over all nodes (ms)");
    public static final AttributeSensor<Double> READS_PER_SECOND_LAST_PER_NODE = Sensors.newDoubleSensor((String)"cassandra.reads.perSec.last.perNode", (String)"Reads/sec (last datapoint) averaged over all nodes");
    public static final AttributeSensor<Double> WRITES_PER_SECOND_LAST_PER_NODE = Sensors.newDoubleSensor((String)"cassandra.write.perSec.last.perNode", (String)"Writes/sec (last datapoint) averaged over all nodes");
    public static final AttributeSensor<Double> PROCESS_CPU_TIME_FRACTION_LAST_PER_NODE = Sensors.newDoubleSensor((String)"cassandra.cluster.metrics.processCpuTime.fraction.perNode", (String)"Fraction of CPU time used (percentage reported by JMX), averaged over all nodes");
    public static final AttributeSensor<Double> READS_PER_SECOND_IN_WINDOW_PER_NODE = Sensors.newDoubleSensor((String)"cassandra.reads.perSec.windowed.perNode", (String)"Reads/sec (over time window) averaged over all nodes");
    public static final AttributeSensor<Double> WRITES_PER_SECOND_IN_WINDOW_PER_NODE = Sensors.newDoubleSensor((String)"cassandra.writes.perSec.windowed.perNode", (String)"Writes/sec (over time window) averaged over all nodes");
    public static final AttributeSensor<Double> THRIFT_PORT_LATENCY_IN_WINDOW_PER_NODE = Sensors.newDoubleSensor((String)"cassandra.thrift.latency.windowed.perNode", (String)"Latency for thrift port (ms, over time window) averaged over all nodes");
    public static final AttributeSensor<Double> PROCESS_CPU_TIME_FRACTION_IN_WINDOW_PER_NODE = Sensors.newDoubleSensor((String)"cassandra.cluster.metrics.processCpuTime.fraction.windowed", (String)"Fraction of CPU time used (percentage, over time window), averaged over all nodes");
    public static final MethodEffector<Void> UPDATE = new MethodEffector(CassandraDatacenter.class, "update");
    public static final Effector<String> EXECUTE_SCRIPT = Effectors.effector((Effector)DatastoreMixins.EXECUTE_SCRIPT).description("executes the given script contents using cassandra-cli").buildAbstract();
    public static final int DEFAULT_SEED_QUORUM = 2;
    public static final Duration DELAY_AFTER_FIRST = Duration.ONE_MINUTE;
    public static final Duration DELAY_BETWEEN_STARTS = null;
    public static final boolean WAIT_FOR_FIRST = true;

    @org.apache.brooklyn.core.annotation.Effector(description="Updates the cluster members")
    public void update();

    public String getClusterName();

    public Set<Entity> gatherPotentialSeeds();

    public Set<Entity> gatherPotentialRunningSeeds();

    public String executeScript(String var1);
}

