/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn;

import com.google.common.annotations.Beta;
import java.io.InputStream;
import java.io.Reader;
import java.util.Set;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.camp.CampPlatform;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampPlatform;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampPlatformLauncherAbstract;
import org.apache.brooklyn.camp.spi.Assembly;
import org.apache.brooklyn.camp.spi.AssemblyTemplate;
import org.apache.brooklyn.camp.spi.instantiate.AssemblyTemplateInstantiator;
import org.apache.brooklyn.core.entity.Dumper;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.internal.BrooklynShutdownHooks;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class YamlLauncherAbstract {
    private static final Logger log = LoggerFactory.getLogger(YamlLauncherAbstract.class);
    protected final BrooklynCampPlatformLauncherAbstract platformLauncher = this.newPlatformLauncher();
    protected final BrooklynCampPlatform platform;
    protected final ManagementContext brooklynMgmt;
    protected boolean shutdownAppsOnExit = false;

    public YamlLauncherAbstract() {
        this.platformLauncher.launch();
        this.platform = this.platformLauncher.getCampPlatform();
        this.brooklynMgmt = this.platformLauncher.getBrooklynMgmt();
    }

    public ManagementContext getManagementContext() {
        return this.brooklynMgmt;
    }

    public boolean getShutdownAppsOnExit() {
        return this.shutdownAppsOnExit;
    }

    public void setShutdownAppsOnExit(boolean shutdownAppsOnExit) {
        this.shutdownAppsOnExit = shutdownAppsOnExit;
    }

    protected abstract BrooklynCampPlatformLauncherAbstract newPlatformLauncher();

    public Application launchAppYaml(String url) {
        return this.launchAppYaml(url, true);
    }

    public Application launchAppYaml(String url, boolean waitForTasksToComplete) {
        try {
            Reader input = Streams.reader((InputStream)new ResourceUtils((Object)this).getResourceFromUrl(url));
            Application app = this.launchAppYaml(input, waitForTasksToComplete);
            log.info("Application started from YAML file " + url + ": " + app);
            return app;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Application launchAppYaml(Reader input) {
        return this.launchAppYaml(input, true);
    }

    public Application launchAppYaml(Reader input, boolean waitForTasksToComplete) {
        try {
            AssemblyTemplate at = this.platform.pdp().registerDeploymentPlan(input);
            Assembly assembly = ((AssemblyTemplateInstantiator)at.getInstantiator().newInstance()).instantiate(at, (CampPlatform)this.platform);
            Entity app = this.brooklynMgmt.getEntityManager().getEntity(assembly.getId());
            log.info("Launching " + app);
            if (this.getShutdownAppsOnExit()) {
                BrooklynShutdownHooks.invokeStopOnShutdown((Entity)app);
            }
            if (waitForTasksToComplete) {
                Set tasks = BrooklynTaskTags.getTasksInEntityContext((ExecutionManager)this.brooklynMgmt.getExecutionManager(), (Entity)app);
                log.info("Waiting on " + tasks.size() + " task(s)");
                for (Task t : tasks) {
                    t.blockUntilEnded();
                }
            }
            log.info("Application started from YAML: " + app);
            Dumper.dumpInfo((Entity)app);
            return (Application)app;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void destroyAll() {
        Entities.destroyAll((ManagementContext)this.getManagementContext());
        try {
            this.platformLauncher.stopServers();
        }
        catch (Exception e) {
            log.warn("Unable to stop servers (ignoring): " + e);
        }
    }
}

