/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.creation;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynComponentTemplateResolver;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynYamlTypeInstantiator;
import org.apache.brooklyn.camp.brooklyn.spi.creation.CampInternalUtils;
import org.apache.brooklyn.camp.brooklyn.spi.creation.CampResolver;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.objs.BasicSpecParameter;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.typereg.AbstractTypePlanTransformer;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrooklynEntityDecorationResolver<DT> {
    private static final Logger log = LoggerFactory.getLogger(BrooklynEntityDecorationResolver.class);
    final BrooklynYamlTypeInstantiator.Factory instantiator;
    final String decorationKind;
    final String typeKeyPrefix;
    final String objectKey;

    protected BrooklynEntityDecorationResolver(BrooklynYamlTypeInstantiator.Factory instantiator, String decorationKind, String typeKeyPrefix, String objectKey) {
        this.instantiator = instantiator;
        this.decorationKind = decorationKind;
        this.typeKeyPrefix = typeKeyPrefix;
        this.objectKey = objectKey;
    }

    @Deprecated
    public final void decorate(EntitySpec<?> entitySpec, ConfigBag attrs) {
        this.decorate(entitySpec, attrs, (Set<String>)ImmutableSet.of());
    }

    public abstract void decorate(EntitySpec<?> var1, ConfigBag var2, Set<String> var3);

    protected List<? extends DT> buildListOfTheseDecorationsFromEntityAttributes(ConfigBag attrs) {
        Object value = this.getDecorationAttributeJsonValue(attrs);
        if (value == null) {
            return MutableList.of();
        }
        if (value instanceof Iterable) {
            return this.buildListOfTheseDecorationsFromIterable((Iterable)value);
        }
        throw new IllegalArgumentException(this.getDecorationKind() + " body should be iterable, not " + value.getClass());
    }

    protected Map<?, ?> checkIsMap(Object decorationJson) {
        if (!(decorationJson instanceof Map)) {
            throw new IllegalArgumentException(this.getDecorationKind() + " value must be a Map, not " + (decorationJson == null ? null : decorationJson.getClass()));
        }
        return (Map)decorationJson;
    }

    protected List<DT> buildListOfTheseDecorationsFromIterable(Iterable<?> value) {
        MutableList decorations = MutableList.of();
        for (Object decorationJson : value) {
            this.addDecorationFromJsonMap(this.checkIsMap(decorationJson), (List<DT>)decorations);
        }
        return decorations;
    }

    protected final String getDecorationKind() {
        return this.decorationKind;
    }

    protected Object getDecorationAttributeJsonValue(ConfigBag attrs) {
        return attrs.getStringKey(this.objectKey);
    }

    protected abstract void addDecorationFromJsonMap(Map<?, ?> var1, List<DT> var2);

    public static class TagsResolver
    extends BrooklynEntityDecorationResolver<Iterable<Object>> {
        protected TagsResolver(BrooklynYamlTypeInstantiator.Factory instantiator) {
            super(instantiator, "Brooklyn Tags", null, "brooklyn.tags");
        }

        @Override
        public void decorate(EntitySpec<?> entitySpec, ConfigBag attrs, Set<String> encounteredRegisteredTypeIds) {
            String iconUrl;
            Object decorationAttributeJsonValue = this.getDecorationAttributeJsonValue(attrs);
            if (decorationAttributeJsonValue != null) {
                entitySpec.tagsAddAtStart((Iterable)decorationAttributeJsonValue);
            }
            if ((iconUrl = (String)attrs.get(BrooklynConfigKeys.ICON_URL)) != null) {
                entitySpec.tagsAddAtStart((Iterable)MutableList.of((Object)BrooklynTags.newIconUrlTag((String)iconUrl)));
            }
        }

        @Override
        protected Iterable<Object> getDecorationAttributeJsonValue(ConfigBag attrs) {
            Object brooklynTags = super.getDecorationAttributeJsonValue(attrs);
            if (brooklynTags == null) {
                return null;
            }
            if (!(brooklynTags instanceof List)) {
                throw new IllegalArgumentException("brooklyn.tags should be a List of String elements. You supplied " + brooklynTags);
            }
            Preconditions.checkArgument((boolean)((List)brooklynTags).stream().noneMatch(input -> input instanceof DeferredSupplier), (Object)("brooklyn.tags should not contain DeferredSupplier. A DeferredSupplier is made when using $brooklyn:attributeWhenReady. You supplied " + brooklynTags));
            return (List)brooklynTags;
        }

        @Override
        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<Iterable<Object>> decorations) {
            throw new UnsupportedOperationException("TagsResolver.addDecorationFromJsonMap should never be called.");
        }
    }

    public static class SpecParameterResolver
    extends BrooklynEntityDecorationResolver<SpecParameter<?>> {
        private Function<Object, Object> transformer;

        protected SpecParameterResolver(BrooklynYamlTypeInstantiator.Factory instantiator) {
            super(instantiator, "Spec Parameter initializer", null, "brooklyn.parameters");
        }

        @Override
        public void decorate(EntitySpec<?> entitySpec, ConfigBag attrs, Set<String> encounteredRegisteredTypeIds) {
            this.transformer = new BrooklynComponentTemplateResolver.SpecialFlagsTransformer(this.instantiator.loader, encounteredRegisteredTypeIds);
            List explicitParams = this.buildListOfTheseDecorationsFromEntityAttributes(attrs);
            BasicSpecParameter.initializeSpecWithExplicitParameters(entitySpec, explicitParams, (BrooklynClassLoadingContext)this.instantiator.loader);
        }

        @Override
        protected List<SpecParameter<?>> buildListOfTheseDecorationsFromIterable(Iterable<?> value) {
            return BasicSpecParameter.parseParameterDefinitionList((List)ImmutableList.copyOf(value), this.transformer, (BrooklynClassLoadingContext)this.instantiator.loader);
        }

        @Override
        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<SpecParameter<?>> decorations) {
            throw new UnsupportedOperationException("SpecParameterResolver.addDecorationFromJsonMap should never be called.");
        }
    }

    public static class InitializerResolver
    extends BrooklynEntityDecorationResolver<EntityInitializer> {
        public InitializerResolver(BrooklynYamlTypeInstantiator.Factory instantiator) {
            super(instantiator, "Entity initializer", "initializer", "brooklyn.initializers");
        }

        @Override
        public void decorate(EntitySpec<?> entitySpec, ConfigBag attrs, Set<String> encounteredRegisteredTypeIds) {
            entitySpec.addInitializers(this.buildListOfTheseDecorationsFromEntityAttributes(attrs));
        }

        @Override
        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<EntityInitializer> decorations) {
            EntityInitializer result;
            try {
                result = (EntityInitializer)BeanWithTypeUtils.convert((ManagementContext)this.instantiator.getClassLoadingContext().getManagementContext(), decorationJson, (TypeToken)TypeToken.of(EntityInitializer.class), (boolean)true, (BrooklynClassLoadingContext)this.instantiator.getClassLoadingContext(), (boolean)true);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                Object type = decorationJson.get(CampInternalUtils.TYPE_UNAMBIGUOUS_KEY);
                if (type == null) {
                    type = decorationJson.get("type");
                }
                try {
                    result = this.instantiator.from(decorationJson).prefix(this.typeKeyPrefix).newInstance(EntityInitializer.class);
                    if (type != null) {
                        if (EntityInitializer.class.isInstance(result)) {
                            log.trace("Initializer for type {} instantiated via old syntax (due to {})", new Object[]{type, e});
                        } else {
                            log.debug("Initializer for type {} instantiated via old syntax (due to {})", new Object[]{type, e});
                        }
                    }
                }
                catch (Exception e2) {
                    Exceptions.propagateIfFatal((Throwable)e2);
                    throw Exceptions.propagate((String)("Error instantiating " + this.typeKeyPrefix + (type != null ? " '" + type + "'" : "") + " (stack " + Arrays.asList(CampResolver.currentlyCreatingSpec.get()) + ")"), Arrays.asList(e, e2));
                }
            }
            decorations.add(result);
        }
    }

    public static class EnricherSpecResolver
    extends BrooklynObjectSpecResolver<Enricher, EnricherSpec<Enricher>> {
        public EnricherSpecResolver(BrooklynYamlTypeInstantiator.Factory initializer) {
            super(initializer, "Enricher", "enricher", "brooklyn.enrichers", BrooklynObjectType.ENRICHER);
        }

        @Override
        public void decorate(EntitySpec<?> entitySpec, ConfigBag attrs, Set<String> encounteredRegisteredTypeIds) {
            entitySpec.enricherSpecs(this.buildListOfTheseDecorationsFromEntityAttributes(attrs));
        }

        @Override
        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<EnricherSpec<Enricher>> decorations) {
            this.addDecorationFromJsonMap(decorationJson, decorations, type -> EnricherSpec.create((Class)type));
        }
    }

    public static class PolicySpecResolver
    extends BrooklynObjectSpecResolver<Policy, PolicySpec<Policy>> {
        public PolicySpecResolver(BrooklynYamlTypeInstantiator.Factory initializer) {
            super(initializer, "Policy", "policy", "brooklyn.policies", BrooklynObjectType.POLICY);
        }

        @Override
        public void decorate(EntitySpec<?> entitySpec, ConfigBag attrs, Set<String> encounteredRegisteredTypeIds) {
            entitySpec.policySpecs(this.buildListOfTheseDecorationsFromEntityAttributes(attrs));
        }

        @Override
        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<PolicySpec<Policy>> decorations) {
            this.addDecorationFromJsonMap(decorationJson, decorations, type -> PolicySpec.create((Class)type));
        }
    }

    public static abstract class BrooklynObjectSpecResolver<DTInterface extends BrooklynObject, DTSpec extends AbstractBrooklynObjectSpec<DTInterface, DTSpec>>
    extends BrooklynEntityDecorationResolver<DTSpec> {
        final BrooklynObjectType boType;

        protected BrooklynObjectSpecResolver(BrooklynYamlTypeInstantiator.Factory instantiator, String decorationKind, String typeKeyPrefix, String objectKey, BrooklynObjectType boType) {
            super(instantiator, decorationKind, typeKeyPrefix, objectKey);
            this.boType = boType;
        }

        protected DTSpec instantiateSpec(Map<?, ?> decorationJson, Function<Class<DTInterface>, DTSpec> classFactory) {
            AbstractBrooklynObjectSpec spec;
            BrooklynYamlTypeInstantiator.InstantiatorFromKey decoLoader = this.instantiator.from(decorationJson).prefix(this.typeKeyPrefix);
            String typeName = (String)decoLoader.getTypeName().get();
            ManagementContext mgmt = this.instantiator.loader.getManagementContext();
            Maybe item = RegisteredTypes.tryValidate((RegisteredType)mgmt.getTypeRegistry().get(typeName), (RegisteredTypeLoadingContext)RegisteredTypeLoadingContexts.spec((Class)this.boType.getInterfaceType()));
            if (!item.isNull()) {
                spec = mgmt.getTypeRegistry().createSpec((RegisteredType)item.get(), null, this.boType.getSpecType());
            } else {
                Class type = decoLoader.getType(this.boType.getInterfaceType());
                spec = ((AbstractBrooklynObjectSpec)classFactory.apply(type)).parameters((Iterable)BasicSpecParameter.fromClass((ManagementContext)mgmt, type));
            }
            spec.configure(decoLoader.getConfigMap());
            AbstractTypePlanTransformer.checkSecuritySensitiveFields((AbstractBrooklynObjectSpec)spec);
            return (DTSpec)spec;
        }

        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<DTSpec> decorations, Function<Class<DTInterface>, DTSpec> classFactory) {
            decorations.add(this.instantiateSpec(decorationJson, classFactory));
        }
    }
}

