/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.templates;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;

public abstract class AbstractPortableTemplateBuilder<T extends AbstractPortableTemplateBuilder<?>>
implements TemplateBuilder {
    protected List<Function<TemplateBuilder, TemplateBuilder>> commands = new ArrayList<Function<TemplateBuilder, TemplateBuilder>>();
    private Hardware hardware;
    private Image image;
    private Template template;
    private String locationId;
    private String imageId;
    private String hardwareId;
    private OsFamily os;
    private String osNameRegex;
    private String osDescriptionRegex;
    private String osVersionRegex;
    private String osArchitectureRegex;
    private String hypervisorRegex;
    private Boolean is64bit;
    private String imageNameRegex;
    private String imageDescriptionRegex;
    private String imageVersionRegex;
    private Double minCores;
    private Integer minRam;
    private Double minDisk;
    private Predicate<Image> imageCondition;
    private Function<Iterable<? extends Image>, Image> imageChooserFunction;
    private TemplateOptions options;
    private List<TemplateOptions> additionalOptions = new ArrayList<TemplateOptions>();
    @VisibleForTesting
    protected Boolean forceCacheReload;

    public T any() {
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.any();
            }
        });
        return (T)this;
    }

    public T fromHardware(final Hardware hardware) {
        this.hardware = hardware;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.fromHardware(hardware);
            }
        });
        return (T)this;
    }

    public Hardware getHardware() {
        return this.hardware;
    }

    public T fromImage(final Image image) {
        this.image = image;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.fromImage(image);
            }
        });
        return (T)this;
    }

    public Image getImage() {
        return this.image;
    }

    public T fromTemplate(final Template template) {
        this.template = template;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.fromTemplate(template);
            }
        });
        return (T)this;
    }

    public Template getTemplate() {
        return this.template;
    }

    public T smallest() {
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.smallest();
            }
        });
        return (T)this;
    }

    public T fastest() {
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.fastest();
            }
        });
        return (T)this;
    }

    public T biggest() {
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.biggest();
            }
        });
        return (T)this;
    }

    public T locationId(final String locationId) {
        this.locationId = locationId;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.locationId(locationId);
            }
        });
        return (T)this;
    }

    public String getLocationId() {
        return this.locationId;
    }

    public T imageId(final String imageId) {
        this.imageId = imageId;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.imageId(imageId);
            }
        });
        return (T)this;
    }

    public String getImageId() {
        return this.imageId;
    }

    public T hardwareId(final String hardwareId) {
        this.hardwareId = hardwareId;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.hardwareId(hardwareId);
            }
        });
        return (T)this;
    }

    public String getHardwareId() {
        return this.hardwareId;
    }

    public T osNameMatches(final String osNameRegex) {
        this.osNameRegex = osNameRegex;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.osNameMatches(osNameRegex);
            }
        });
        return (T)this;
    }

    public String getOsNameMatchesRegex() {
        return this.osNameRegex;
    }

    public T osDescriptionMatches(final String osDescriptionRegex) {
        this.osDescriptionRegex = osDescriptionRegex;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.osDescriptionMatches(osDescriptionRegex);
            }
        });
        return (T)this;
    }

    public String getOsDescriptionMatchesRegex() {
        return this.osDescriptionRegex;
    }

    public T osVersionMatches(final String osVersionRegex) {
        this.osVersionRegex = osVersionRegex;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.osVersionMatches(osVersionRegex);
            }
        });
        return (T)this;
    }

    public String getOsVersionMatchesRegex() {
        return this.osVersionRegex;
    }

    public T osArchMatches(final String osArchitectureRegex) {
        this.osArchitectureRegex = osArchitectureRegex;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.osArchMatches(osArchitectureRegex);
            }
        });
        return (T)this;
    }

    public String getOsArchitectureMatchesRegex() {
        return this.osArchitectureRegex;
    }

    public T os64Bit(final boolean is64bit) {
        this.is64bit = is64bit;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.os64Bit(is64bit);
            }
        });
        return (T)this;
    }

    public Boolean getIs64bit() {
        return this.is64bit;
    }

    public T osFamily(final OsFamily os) {
        this.os = os;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.osFamily(os);
            }
        });
        return (T)this;
    }

    public OsFamily getOsFamily() {
        return this.os;
    }

    public T hypervisorMatches(final String hypervisorRegex) {
        this.hypervisorRegex = hypervisorRegex;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.hypervisorMatches(hypervisorRegex);
            }
        });
        return (T)this;
    }

    public String getHypervisorMatchesRegex() {
        return this.hypervisorRegex;
    }

    public T imageNameMatches(final String imageNameRegex) {
        this.imageNameRegex = imageNameRegex;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.imageNameMatches(imageNameRegex);
            }
        });
        return (T)this;
    }

    public String getImageNameMatchesRegex() {
        return this.imageNameRegex;
    }

    public T imageDescriptionMatches(final String imageDescriptionRegex) {
        this.imageDescriptionRegex = imageDescriptionRegex;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.imageDescriptionMatches(imageDescriptionRegex);
            }
        });
        return (T)this;
    }

    public String getImageDescriptionMatchesRegex() {
        return this.imageDescriptionRegex;
    }

    public T imageVersionMatches(final String imageVersionRegex) {
        this.imageVersionRegex = imageVersionRegex;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.imageVersionMatches(imageVersionRegex);
            }
        });
        return (T)this;
    }

    public String getImageVersionMatchesRegex() {
        return this.imageVersionRegex;
    }

    public T imageMatches(final Predicate<Image> condition) {
        this.imageCondition = condition;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.imageMatches(condition);
            }
        });
        return (T)this;
    }

    public Predicate<Image> getImageMatchesCondition() {
        return this.imageCondition;
    }

    public T minCores(final double minCores) {
        this.minCores = minCores;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.minCores(minCores);
            }
        });
        return (T)this;
    }

    public Double getMinCores() {
        return this.minCores;
    }

    public T minRam(final int megabytes) {
        this.minRam = megabytes;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.minRam(megabytes);
            }
        });
        return (T)this;
    }

    public Integer getMinRam() {
        return this.minRam;
    }

    public T minDisk(final double gigabytes) {
        this.minDisk = gigabytes;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.minDisk(gigabytes);
            }
        });
        return (T)this;
    }

    public Double getMinDisk() {
        return this.minDisk;
    }

    public T imageChooser(final Function<Iterable<? extends Image>, Image> imageChooserFunction) {
        this.imageChooserFunction = imageChooserFunction;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.imageChooser(imageChooserFunction);
            }
        });
        return (T)this;
    }

    public Function<Iterable<? extends Image>, Image> imageChooser() {
        return this.imageChooserFunction;
    }

    public T blank() {
        this.hardware = null;
        this.image = null;
        this.template = null;
        this.hypervisorRegex = null;
        this.os = null;
        this.locationId = null;
        this.imageId = null;
        this.hardwareId = null;
        this.osNameRegex = null;
        this.osDescriptionRegex = null;
        this.osVersionRegex = null;
        this.osArchitectureRegex = null;
        this.is64bit = null;
        this.imageNameRegex = null;
        this.imageDescriptionRegex = null;
        this.imageVersionRegex = null;
        this.imageCondition = null;
        this.minCores = null;
        this.minRam = null;
        this.options = null;
        this.additionalOptions.clear();
        this.commands.clear();
        this.osFamily(null);
        this.osVersionMatches(null);
        this.minRam(1);
        return (T)this;
    }

    public boolean isBlank() {
        if (this.commands.isEmpty()) {
            return true;
        }
        return this.commands.size() == 1 && this.minRam != null && this.minRam == 1;
    }

    public T options(final TemplateOptions options) {
        this.options = options;
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.options(options);
            }
        });
        return (T)this;
    }

    public TemplateOptions getOptions() {
        return this.options;
    }

    public T addOptions(final TemplateOptions options) {
        this.additionalOptions.add(options);
        this.commands.add(new Function<TemplateBuilder, TemplateBuilder>(){

            public TemplateBuilder apply(TemplateBuilder b) {
                return b.options(options);
            }
        });
        return (T)this;
    }

    public List<TemplateOptions> getAdditionalOptions() {
        return ImmutableList.copyOf(this.additionalOptions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hypervisorRegex, this.os, this.locationId, this.hardwareId, this.imageId, this.imageDescriptionRegex, this.imageNameRegex, this.imageVersionRegex, this.is64bit, this.locationId, this.osArchitectureRegex, this.osDescriptionRegex, this.osNameRegex, this.osVersionRegex, this.minCores, this.minRam, this.minDisk, this.options, this.additionalOptions, 0});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPortableTemplateBuilder other = (AbstractPortableTemplateBuilder)obj;
        if (!Objects.equal(this.additionalOptions, other.additionalOptions)) {
            return false;
        }
        if (!Objects.equal(this.commands, other.commands)) {
            return false;
        }
        if (!Objects.equal((Object)this.locationId, (Object)other.locationId)) {
            return false;
        }
        if (!Objects.equal((Object)this.hardware, (Object)other.hardware)) {
            return false;
        }
        if (!Objects.equal((Object)this.hardwareId, (Object)other.hardwareId)) {
            return false;
        }
        if (!Objects.equal((Object)this.image, (Object)other.image)) {
            return false;
        }
        if (!Objects.equal((Object)this.imageId, (Object)other.imageId)) {
            return false;
        }
        if (!Objects.equal((Object)this.imageDescriptionRegex, (Object)other.imageDescriptionRegex)) {
            return false;
        }
        if (!Objects.equal((Object)this.imageNameRegex, (Object)other.imageNameRegex)) {
            return false;
        }
        if (!Objects.equal((Object)this.imageVersionRegex, (Object)other.imageVersionRegex)) {
            return false;
        }
        if (!Objects.equal(this.imageCondition, other.imageCondition)) {
            return false;
        }
        if (!Objects.equal(this.imageChooserFunction, other.imageChooserFunction)) {
            return false;
        }
        if (!Objects.equal((Object)this.os, (Object)other.os)) {
            return false;
        }
        if (!Objects.equal((Object)this.osArchitectureRegex, (Object)other.osArchitectureRegex)) {
            return false;
        }
        if (!Objects.equal((Object)this.osDescriptionRegex, (Object)other.osDescriptionRegex)) {
            return false;
        }
        if (!Objects.equal((Object)this.osNameRegex, (Object)other.osNameRegex)) {
            return false;
        }
        if (!Objects.equal((Object)this.osVersionRegex, (Object)other.osVersionRegex)) {
            return false;
        }
        if (!Objects.equal((Object)this.is64bit, (Object)other.is64bit)) {
            return false;
        }
        if (!Objects.equal((Object)this.hypervisorRegex, (Object)other.hypervisorRegex)) {
            return false;
        }
        if (!Objects.equal((Object)this.minCores, (Object)other.minCores)) {
            return false;
        }
        if (!Objects.equal((Object)this.minRam, (Object)other.minRam)) {
            return false;
        }
        if (!Objects.equal((Object)this.minDisk, (Object)other.minDisk)) {
            return false;
        }
        if (!Objects.equal((Object)this.options, (Object)other.options)) {
            return false;
        }
        return Objects.equal((Object)this.template, (Object)other.template);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.makeNonTrivialArgumentsString() + "]";
    }

    protected String makeNonTrivialArgumentsString() {
        String s = (this.hardware != null ? "hardware=" + this.hardware + ", " : "") + (this.image != null ? "image=" + this.image + ", " : "") + (this.template != null ? "template=" + this.template + ", " : "") + (this.hypervisorRegex != null ? "hypervisorRegex=" + this.hypervisorRegex + ", " : "") + (this.os != null ? "os=" + this.os + ", " : "") + (this.locationId != null ? "locationId=" + this.locationId + ", " : "") + (this.imageId != null ? "imageId=" + this.imageId + ", " : "") + (this.hardwareId != null ? "hardwareId=" + this.hardwareId + ", " : "") + (this.osNameRegex != null ? "osNameRegex=" + this.osNameRegex + ", " : "") + (this.osDescriptionRegex != null ? "osDescriptionRegex=" + this.osDescriptionRegex + ", " : "") + (this.osVersionRegex != null ? "osVersionRegex=" + this.osVersionRegex + ", " : "") + (this.osArchitectureRegex != null ? "osArchictectureRegex=" + this.osArchitectureRegex + ", " : "") + (this.is64bit != null ? "is64bit=" + this.is64bit + ", " : "") + (this.imageNameRegex != null ? "imageNameRegex=" + this.imageNameRegex + ", " : "") + (this.imageDescriptionRegex != null ? "imageDescriptionRegex=" + this.imageDescriptionRegex + ", " : "") + (this.imageVersionRegex != null ? "imageVersionRegex=" + this.imageVersionRegex + ", " : "") + (this.imageCondition != null ? "imageCondition=" + this.imageCondition + ", " : "") + (this.imageChooserFunction != null ? "imageChooserFunction=" + this.imageChooserFunction + ", " : "") + (this.minCores != null ? "minCores=" + this.minCores + ", " : "") + (this.minRam != null ? "minRam=" + this.minRam + ", " : "") + (this.minDisk != null ? "minDisk=" + this.minDisk + ", " : "");
        if (s.endsWith(", ")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }
}

