/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.filters;

import com.google.common.base.Supplier;
import javax.inject.Inject;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.location.Provider;
import org.jclouds.oauth.v2.filters.OAuthFilter;

public final class BearerTokenFromCredentials
implements OAuthFilter {
    private final Supplier<Credentials> creds;

    @Inject
    BearerTokenFromCredentials(@Provider Supplier<Credentials> creds) {
        this.creds = creds;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        return ((HttpRequest.Builder)request.toBuilder().addHeader("Authorization", new String[]{String.format("%s %s", "Bearer", ((Credentials)this.creds.get()).credential)})).build();
    }
}

