/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import com.google.common.annotations.Beta;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.rest.domain.HighAvailabilitySummary;
import org.apache.brooklyn.rest.domain.VersionSummary;

@Path(value="/server")
@Api(value="Server")
@Produces(value={"application/json"})
@Beta
public interface ServerApi {
    public static final String MIME_TYPE_ZIP = "application/zip";
    public static final String MIME_TYPE_TGZ = "application/gzip";

    @POST
    @Path(value="/properties/reload")
    @ApiOperation(value="Reload brooklyn.properties")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public void reloadBrooklynProperties();

    @POST
    @Path(value="/shutdown")
    @ApiOperation(value="Terminate this Brooklyn server instance")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public void shutdown(@ApiParam(name="stopAppsFirst", value="Whether to stop running applications before shutting down") @FormParam(value="stopAppsFirst") @DefaultValue(value="false") boolean var1, @ApiParam(name="forceShutdownOnError", value="Force shutdown if apps fail to stop or timeout") @FormParam(value="forceShutdownOnError") @DefaultValue(value="false") boolean var2, @ApiParam(name="shutdownTimeout", value="A maximum delay to wait for apps to gracefully stop before giving up or forcibly exiting, 0 to wait infinitely") @FormParam(value="shutdownTimeout") @DefaultValue(value="20s") String var3, @ApiParam(name="requestTimeout", value="Maximum time to block the request for the shutdown to finish, 0 to wait infinitely") @FormParam(value="requestTimeout") @DefaultValue(value="20s") String var4, @ApiParam(name="delayForHttpReturn", value="The delay before exiting the process, to permit the REST response to be returned") @FormParam(value="delayForHttpReturn") @DefaultValue(value="5s") String var5, @ApiParam(name="delayMillis", value="Deprecated, analogous to delayForHttpReturn") @FormParam(value="delayMillis") Long var6);

    @GET
    @Path(value="/version")
    @ApiOperation(value="Return version identifier information for this Brooklyn instance", response=VersionSummary.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public VersionSummary getVersion();

    @GET
    @Path(value="/planeid")
    @ApiOperation(value="Return the plane id (an identifier that is stable across restarts and HA failovers)")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public String getPlaneId();

    @GET
    @Path(value="/up")
    @ApiOperation(value="Returns whether this server is up - fully started, and not stopping, though it may have errors")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public boolean isUp();

    @GET
    @Path(value="/shuttingDown")
    @ApiOperation(value="Returns whether this server is shutting down")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public boolean isShuttingDown();

    @GET
    @Path(value="/healthy")
    @ApiOperation(value="Returns whether this node is healthy - fully started, not stopping, and no errors")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public boolean isHealthy();

    @GET
    @Path(value="/up/extended")
    @ApiOperation(value="Returns extended server-up information, a map including up (/up), shuttingDown (/shuttingDown), healthy (/healthy), and ha (/ha/states) (qv) as well as selected settings such as sensitive field treatment; also forces a session, so a useful general-purpose call for a UI client to do when starting")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public Map<String, Object> getUpExtended();

    @GET
    @Path(value="/config/{configKey}")
    @ApiOperation(value="Get the value of the specified config key from brooklyn properties")
    @ApiResponses(value={@ApiResponse(code=204, message="Could not find config key"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Config key not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public String getConfig(@ApiParam(value="Config key ID", required=true) @PathParam(value="configKey") String var1, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") Boolean var2);

    @GET
    @Path(value="/ha/state")
    @ApiOperation(value="Returns the HA state of this management node")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public ManagementNodeState getHighAvailabilityNodeState();

    @GET
    @Path(value="/ha/metrics")
    @ApiOperation(value="Returns a collection of HA metrics")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public Map<String, Object> getHighAvailabilityMetrics();

    @POST
    @Path(value="/ha/state")
    @ApiOperation(value="Changes the HA state of this management node")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public ManagementNodeState setHighAvailabilityNodeState(@ApiParam(name="mode", value="The state to change to") @FormParam(value="mode") HighAvailabilityMode var1);

    @GET
    @Path(value="/ha/states")
    @ApiOperation(value="Returns the HA states and detail for all nodes in this management plane", response=HighAvailabilitySummary.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public HighAvailabilitySummary getHighAvailabilityPlaneStates();

    @POST
    @Path(value="/ha/states/clear")
    @ApiOperation(value="Clears HA node information for non-master nodes; active nodes will repopulate and other records will be erased")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response clearHighAvailabilityPlaneStates();

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/ha/states/clear/node")
    @ApiOperation(value="Clears HA node information for a particular non-master node; other nodes will repopulate and selected node will be erased", consumes="application/x-www-form-urlencoded")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response clearHighAvailabilityPlaneStates(@ApiParam(name="nodeId", value="ID of node to be removed") @FormParam(value="nodeId") String var1);

    @GET
    @Path(value="/ha/priority")
    @ApiOperation(value="Returns the HA node priority for MASTER failover")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public long getHighAvailabilityPriority();

    @POST
    @Path(value="/ha/priority")
    @ApiOperation(value="Sets the HA node priority for MASTER failover")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public long setHighAvailabilityPriority(@ApiParam(name="priority", value="The priority to be set") @FormParam(value="priority") long var1);

    @GET
    @Produces(value={"application/zip"})
    @Path(value="/ha/persist/export")
    @ApiOperation(value="Retrieves the persistence store data, as an archive")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response exportPersistenceData(@ApiParam(name="origin", value="Whether to take from LOCAL or REMOTE state; default to AUTO detect, using LOCAL as master and REMOTE for other notes") @QueryParam(value="origin") @DefaultValue(value="AUTO") String var1);

    @POST
    @Path(value="/ha/persist/import")
    @Consumes
    @ApiOperation(value="Imports a persistence export to a file-based store, moving catalog items, locations and managed applications (merged with the current persistence).")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response importPersistenceData(@ApiParam(name="persistenceData", value="Archived data", required=true) byte[] var1);

    @GET
    @Path(value="/user")
    @ApiOperation(value="Return user information for this Brooklyn instance; also forces a session, so a useful general-purpose call for a UI client to do when starting", response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public String getUser();
}

