/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import com.google.common.annotations.Beta;
import com.google.common.base.Supplier;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.StartableMethods;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.entity.software.base.lifecycle.MachineLifecycleEffectorTasks;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SoftwareProcessDriverLifecycleEffectorTasks
extends MachineLifecycleEffectorTasks {
    private static final Logger log = LoggerFactory.getLogger(SoftwareProcessDriverLifecycleEffectorTasks.class);

    @Override
    public void restart(ConfigBag parameters) {
        SoftwareProcess.RestartSoftwareParameters.RestartMachineMode isRestartMachine = (SoftwareProcess.RestartSoftwareParameters.RestartMachineMode)((Object)parameters.get(SoftwareProcess.RestartSoftwareParameters.RESTART_MACHINE_TYPED));
        if (isRestartMachine == null) {
            isRestartMachine = SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.AUTO;
        }
        if (isRestartMachine == SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.AUTO) {
            SoftwareProcess.RestartSoftwareParameters.RestartMachineMode restartMachineMode = isRestartMachine = this.getDefaultRestartStopsMachine() ? SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.TRUE : SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.FALSE;
        }
        if (isRestartMachine == SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.TRUE) {
            log.debug("restart of " + this.entity() + " requested be applied at machine level");
            super.restart(parameters);
            return;
        }
        DynamicTasks.queue((String)"pre-restart", (Runnable)new PreRestartTask());
        log.debug("restart of " + this.entity() + " appears to have driver and hostname - doing driver-level restart");
        this.entity().getDriver().restart();
        this.restartChildren(parameters);
        DynamicTasks.queue((String)"post-restart", (Runnable)new PostRestartTask());
    }

    @Override
    protected boolean getDefaultRestartStopsMachine() {
        if (this.entity().getDriver() == null) {
            log.debug("restart of " + this.entity() + " has no driver - doing machine-level restart");
            return true;
        }
        if (Strings.isEmpty((CharSequence)((CharSequence)this.entity().getAttribute(Attributes.HOSTNAME)))) {
            log.debug("restart of " + this.entity() + " has no hostname - doing machine-level restart");
            return true;
        }
        return false;
    }

    protected SoftwareProcessImpl entity() {
        return (SoftwareProcessImpl)super.entity();
    }

    @Override
    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation<?> location) {
        return this.entity().obtainProvisioningFlags(location);
    }

    @Override
    protected void preStartCustom(MachineLocation machine, ConfigBag parameters) {
        this.entity().initDriver(machine);
        super.preStartCustom(machine, parameters);
        this.entity().preStart();
    }

    protected SoftwareProcess.ChildStartableMode getChildrenStartableModeEffective() {
        if (this.entity().getChildren().isEmpty()) {
            return SoftwareProcess.ChildStartableMode.NONE;
        }
        SoftwareProcess.ChildStartableMode result = (SoftwareProcess.ChildStartableMode)((Object)this.entity().getConfig(SoftwareProcess.CHILDREN_STARTABLE_MODE));
        if (result != null) {
            return result;
        }
        return SoftwareProcess.ChildStartableMode.NONE;
    }

    @Override
    protected String startProcessesAtMachine(Supplier<MachineLocation> machineS) {
        SoftwareProcess.ChildStartableMode mode = this.getChildrenStartableModeEffective();
        TaskAdaptable children = null;
        if (!mode.isDisabled) {
            children = StartableMethods.startingChildren((Entity)this.entity(), (Location)((Location)machineS.get()));
            if (!mode.isLate) {
                Entities.submit((Entity)this.entity(), (TaskAdaptable)children);
            }
        }
        this.entity().getDriver().start();
        String result = "Started with driver " + this.entity().getDriver();
        if (!mode.isDisabled) {
            if (mode.isLate) {
                DynamicTasks.waitForLast();
                if (mode.isBackground) {
                    Entities.submit((Entity)this.entity(), (TaskAdaptable)children);
                } else {
                    DynamicTasks.queue((TaskAdaptable)children);
                }
            }
            if (!mode.isBackground) {
                children.asTask().getUnchecked();
            }
            result = result + "; children started " + (Object)((Object)mode);
        }
        return result;
    }

    @Override
    protected void postStartCustom(ConfigBag parameters) {
        this.entity().postDriverStart();
        if (this.entity().connectedSensors) {
            log.debug("skipping connecting sensors for " + this.entity() + " in driver-tasks postStartCustom because already connected (e.g. restarting)");
        } else {
            log.debug("connecting sensors for " + this.entity() + " in driver-tasks postStartCustom because already connected (e.g. restarting)");
            this.entity().connectSensors();
        }
        this.entity().waitForServiceUp();
        this.entity().postStart();
        super.postStartCustom(parameters);
    }

    @Override
    @Deprecated
    protected void preStopConfirmCustom(ConfigBag parameters) {
        super.preStopConfirmCustom(parameters);
        this.entity().preStopConfirmCustom();
    }

    @Override
    protected void preStopCustom(ConfigBag parameters) {
        super.preStopCustom(parameters);
        this.entity().preStop();
    }

    @Override
    protected void preRestartCustom(ConfigBag parameters) {
        super.preRestartCustom(parameters);
        this.entity().preRestart();
    }

    @Override
    protected void postRestartCustom(ConfigBag parameters) {
        super.postRestartCustom(parameters);
        this.entity().postRestart();
    }

    @Override
    protected String stopProcessesAtMachine(ConfigBag parameters) {
        String result;
        SoftwareProcess.ChildStartableMode mode = this.getChildrenStartableModeEffective();
        TaskAdaptable children = null;
        Exception childException = null;
        if (!mode.isDisabled) {
            children = StartableMethods.stoppingChildren((Entity)this.entity());
            if (mode.isBackground || !mode.isLate) {
                Entities.submit((Entity)this.entity(), (TaskAdaptable)children);
            } else {
                DynamicTasks.queue((TaskAdaptable)children);
                try {
                    DynamicTasks.waitForLast();
                }
                catch (Exception e) {
                    childException = e;
                }
            }
        }
        if (this.entity().getDriver() != null) {
            this.entity().getDriver().stop();
            result = "Driver stop completed";
        } else {
            result = "No driver (nothing to do here)";
        }
        if (!mode.isDisabled && !mode.isBackground) {
            try {
                children.asTask().get();
            }
            catch (Exception e) {
                childException = e;
                log.debug("Error stopping children; continuing and will rethrow if no other errors", (Throwable)e);
            }
        }
        if (childException != null) {
            throw new IllegalStateException(result + "; but error stopping child: " + childException, childException);
        }
        return result;
    }

    @Override
    protected void postStopCustom(ConfigBag parameters) {
        this.entity().postStop();
        super.postStopCustom(parameters);
    }

    public String toString() {
        return this.getClass().getName();
    }

    private class PostRestartTask
    implements Runnable {
        protected final ConfigBag parameters;

        public PostRestartTask() {
            this(null);
        }

        public PostRestartTask(ConfigBag parameters) {
            this.parameters = parameters;
        }

        @Override
        public void run() {
            try {
                SoftwareProcessDriverLifecycleEffectorTasks.this.postStartCustom(this.parameters);
                SoftwareProcessDriverLifecycleEffectorTasks.this.postRestartCustom(this.parameters);
            }
            finally {
                ServiceStateLogic.setExpectedState((Entity)SoftwareProcessDriverLifecycleEffectorTasks.this.entity(), (Lifecycle)Lifecycle.RUNNING);
            }
        }
    }

    private class PreRestartTask
    implements Runnable {
        protected final ConfigBag parameters;

        public PreRestartTask() {
            this(null);
        }

        public PreRestartTask(ConfigBag parameters) {
            this.parameters = parameters;
        }

        @Override
        public void run() {
            SoftwareProcessDriverLifecycleEffectorTasks.this.preRestartCustom(this.parameters);
        }
    }
}

