/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.rest.util.MultiSessionAttributeAdapter;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=200)
public class LoggingResourceFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.brooklyn.REST");
    private static final Set<String> UNINTERESTING_METHODS = ImmutableSet.of((Object)"GET", (Object)"HEAD");
    private static final Set<String> CENSORED_HEADERS = ImmutableSet.of((Object)"Authorization", (Object)"Cookie");
    private static final Duration REQUEST_DURATION_LOG_POINT = Duration.FIVE_SECONDS;
    private final WeakHashMap<HttpServletRequest, Long> requestTimestamps = new WeakHashMap();
    @Context
    private HttpServletRequest servletRequest;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.requestTimestamps.put(this.servletRequest, System.nanoTime());
        String method = requestContext.getMethod();
        boolean isInteresting = !UNINTERESTING_METHODS.contains(method.toUpperCase());
        LogLevel logLevel = isInteresting ? LogLevel.DEBUG : LogLevel.TRACE;
        this.logRequest(requestContext, logLevel);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String method;
        Long requestTime = this.requestTimestamps.remove(this.servletRequest);
        Duration requestDuration = null;
        if (requestTime != null) {
            long responseTime = System.nanoTime();
            requestDuration = Duration.nanos((Number)(responseTime - requestTime));
        }
        boolean isInteresting = !UNINTERESTING_METHODS.contains((method = requestContext.getMethod()).toUpperCase()) || requestDuration != null && requestDuration.isLongerThan(REQUEST_DURATION_LOG_POINT);
        LogLevel logLevel = isInteresting ? LogLevel.DEBUG : LogLevel.TRACE;
        this.logResponse(requestContext, responseContext, requestDuration, logLevel);
    }

    private void logRequest(ContainerRequestContext requestContext, LogLevel level) {
        if (!this.isLogEnabled(LOG, level)) {
            return;
        }
        String method = requestContext.getMethod();
        String path = requestContext.getUriInfo().getPath();
        requestContext.getSecurityContext();
        SecurityContext securityContext = requestContext.getSecurityContext();
        Principal userPrincipal = securityContext != null ? requestContext.getSecurityContext().getUserPrincipal() : null;
        String userName = userPrincipal != null ? userPrincipal.getName() : this.tryFindUserName();
        String remoteAddr = this.servletRequest.getRemoteAddr();
        StringBuilder message = new StringBuilder("Request received: ").append(method).append(" ").append(path).append(" from user '").append(userName).append("' @ ").append(remoteAddr);
        this.log(LOG, level, message.toString());
    }

    private String tryFindUserName() {
        String userName;
        MultiSessionAttributeAdapter s;
        Maybe entitlementContextUserMaybe = Entitlements.getEntitlementContextUserMaybe();
        if (entitlementContextUserMaybe.isPresent()) {
            return (String)entitlementContextUserMaybe.get();
        }
        if (this.servletRequest != null && (s = MultiSessionAttributeAdapter.of(this.servletRequest, false)) != null && (userName = (String)s.getAttribute("brooklyn.user")) != null) {
            return userName;
        }
        return "<no-user>";
    }

    private void logResponse(ContainerRequestContext requestContext, ContainerResponseContext responseContext, Duration requestDuration, LogLevel level) {
        if (!this.isLogEnabled(LOG, level)) {
            return;
        }
        int status = responseContext.getStatus();
        String method = requestContext.getMethod();
        String path = requestContext.getUriInfo().getPath();
        requestContext.getSecurityContext();
        MultivaluedMap queryParams = requestContext.getUriInfo().getQueryParameters();
        SecurityContext securityContext = requestContext.getSecurityContext();
        Principal userPrincipal = securityContext != null ? requestContext.getSecurityContext().getUserPrincipal() : null;
        String userName = userPrincipal != null ? userPrincipal.getName() : "<no-user>";
        String remoteAddr = this.servletRequest.getRemoteAddr();
        boolean includeHeaders = responseContext.getStatus() / 100 == 5 || LOG.isTraceEnabled();
        StringBuilder message = new StringBuilder("Request completed: ").append("status ").append(status).append(" in ").append(requestDuration).append(", ").append(method).append(" ").append(path).append(" from ").append(userName).append(" @ ").append(remoteAddr);
        if (!queryParams.isEmpty()) {
            message.append(", queryParams: {");
            message.append(Joiner.on((String)", ").withKeyValueSeparator("=").join((Map)queryParams));
            message.append("}");
        }
        if (requestContext.getLength() > 0) {
            int len = requestContext.getLength();
            message.append(", mediaType=").append(requestContext.getMediaType()).append(" (length=").append(len).append(")");
        }
        if (includeHeaders) {
            MultivaluedMap headers = requestContext.getHeaders();
            message.append(", headers={");
            if (!headers.isEmpty()) {
                boolean first = true;
                for (Map.Entry entry : headers.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        message.append(", ");
                    }
                    String headerName = (String)entry.getKey();
                    message.append(headerName).append(": ");
                    if (CENSORED_HEADERS.contains(headerName)) {
                        message.append("******");
                        continue;
                    }
                    message.append(entry.getValue());
                }
            }
            message.append("}");
        }
        this.log(LOG, level, message.toString());
    }

    private boolean isLogEnabled(Logger logger, LogLevel level) {
        switch (level) {
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
        }
        throw new IllegalStateException("Unexpected log level: " + (Object)((Object)level));
    }

    private void log(Logger logger, LogLevel level, String msg) {
        switch (level) {
            case TRACE: {
                logger.trace(msg);
                break;
            }
            case DEBUG: {
                logger.debug(msg);
                break;
            }
            case INFO: {
                logger.info(msg);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected log level: " + (Object)((Object)level));
            }
        }
    }

    private static enum LogLevel {
        TRACE,
        DEBUG,
        INFO;

    }
}

